<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Edit_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data that may be updated using the asset's related task Asset Edit, such as description, name, identifier, serial number, asset class, asset type, asset manufacturer, related assets and attachments. If any attributes are updated that
 * bonus depreciation rules are based on (e.g. asset type or asset class), bonus depreciation percent is not defaulted again from bonus depreciation rules.
 * @subpackage Structs
 */
class Asset_Edit_DataType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy. Value is read-only and will not be updated upon submission.
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType
     */
    public $Company_Reference;
    /**
     * The Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: Asset ID
     * - maxOccurs: 1
     * @var string
     */
    public $Asset_ID;
    /**
     * The Asset_Description
     * Meta information extracted from the WSDL
     * - documentation: Asset Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Description;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Asset_Name
     * Meta information extracted from the WSDL
     * - documentation: Asset Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Name;
    /**
     * The Total_Asset_Cost
     * Meta information extracted from the WSDL
     * - documentation: Total Asset Cost | The total asset cost entered has too many digits beyond the decimal point | The current total cost of this asset. | This field is for display only, any values updated will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Asset_Cost;
    /**
     * The Total_Quantity
     * Meta information extracted from the WSDL
     * - documentation: The number of units
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Total_Quantity;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a purchase item for the asset.
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Reference;
    /**
     * The Asset_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Asset Identifier can be any identifier for the business asset such as a tag number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Identifier;
    /**
     * The Serial_Number
     * Meta information extracted from the WSDL
     * - documentation: Asset Serial Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Serial_Number;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: Configured in Maintain Asset Class by users, Asset Class allows for applying an addtional reporting criteria. Very useful if you are reporting to tax authorities for trackable, depreciating assets. Field is not required.
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Configured in Maintain Asset Type by users, Asset Type allows for applying an additional layer for describing assets and also helpful for reporting trackable, depreciating assets. Field is not required.
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - documentation: Asset Manufacturer name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Manufacturer;
    /**
     * The Business_Use_Percentage
     * Meta information extracted from the WSDL
     * - documentation: The Business Use % for the asset. If left empty, will default to 100. | Business Use Percentage | The Business Use Percentage for this asset, as a number from 1 to 100.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Business_Use_Percentage;
    /**
     * The Coordinating_Cost_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: In the worktag configuration for Business Asset, if inactive values are disallowed for cost centers, then the coordinating cost center must be active. | If the cost center is restricted to a company, then the company on the asset
     * must match the company on the cost center. | References the coordinating cost center for reporting only.
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Coordinating_Cost_Center_Reference;
    /**
     * The Asset_Coordinator_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter a valid worker who hasn't been terminated. | References the asset coordinator for reporting only.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Asset_Coordinator_Reference;
    /**
     * The Discrete_Child_Component_Asset_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Discrete_Child_ComponentType[]
     */
    public $Discrete_Child_Component_Asset_Data;
    /**
     * The Related_Asset_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: References to other assets to which this asset is related. Related assets must be within the same company.Related assets can be loaded using the Edit Asset web service or the Asset > Edit related task.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Related_Asset_Replacement_DataType[]
     */
    public $Related_Asset_Replacement_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Financial Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Asset_Edit_DataType
     * @uses Asset_Edit_DataType::setCompany_Reference()
     * @uses Asset_Edit_DataType::setAsset_ID()
     * @uses Asset_Edit_DataType::setAsset_Description()
     * @uses Asset_Edit_DataType::setMemo()
     * @uses Asset_Edit_DataType::setAsset_Name()
     * @uses Asset_Edit_DataType::setTotal_Asset_Cost()
     * @uses Asset_Edit_DataType::setTotal_Quantity()
     * @uses Asset_Edit_DataType::setItem_Reference()
     * @uses Asset_Edit_DataType::setAsset_Identifier()
     * @uses Asset_Edit_DataType::setSerial_Number()
     * @uses Asset_Edit_DataType::setAsset_Class_Reference()
     * @uses Asset_Edit_DataType::setAsset_Type_Reference()
     * @uses Asset_Edit_DataType::setManufacturer()
     * @uses Asset_Edit_DataType::setBusiness_Use_Percentage()
     * @uses Asset_Edit_DataType::setCoordinating_Cost_Center_Reference()
     * @uses Asset_Edit_DataType::setAsset_Coordinator_Reference()
     * @uses Asset_Edit_DataType::setDiscrete_Child_Component_Asset_Data()
     * @uses Asset_Edit_DataType::setRelated_Asset_Replacement_Data()
     * @uses Asset_Edit_DataType::setAttachment_Data()
     * @param \StructType\OrganizationObjectType $company_Reference
     * @param string $asset_ID
     * @param string $asset_Description
     * @param string $memo
     * @param string $asset_Name
     * @param float $total_Asset_Cost
     * @param float $total_Quantity
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @param string $asset_Identifier
     * @param string $serial_Number
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param string $manufacturer
     * @param float $business_Use_Percentage
     * @param \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference
     * @param \StructType\WorkerObjectType $asset_Coordinator_Reference
     * @param \StructType\Discrete_Child_ComponentType[] $discrete_Child_Component_Asset_Data
     * @param \StructType\Related_Asset_Replacement_DataType[] $related_Asset_Replacement_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     */
    public function __construct(\StructType\OrganizationObjectType $company_Reference = null, $asset_ID = null, $asset_Description = null, $memo = null, $asset_Name = null, $total_Asset_Cost = null, $total_Quantity = null, \StructType\Item_DescriptorObjectType $item_Reference = null, $asset_Identifier = null, $serial_Number = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, \StructType\Asset_TypeObjectType $asset_Type_Reference = null, $manufacturer = null, $business_Use_Percentage = null, \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference = null, \StructType\WorkerObjectType $asset_Coordinator_Reference = null, array $discrete_Child_Component_Asset_Data = array(), array $related_Asset_Replacement_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setAsset_ID($asset_ID)
            ->setAsset_Description($asset_Description)
            ->setMemo($memo)
            ->setAsset_Name($asset_Name)
            ->setTotal_Asset_Cost($total_Asset_Cost)
            ->setTotal_Quantity($total_Quantity)
            ->setItem_Reference($item_Reference)
            ->setAsset_Identifier($asset_Identifier)
            ->setSerial_Number($serial_Number)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setManufacturer($manufacturer)
            ->setBusiness_Use_Percentage($business_Use_Percentage)
            ->setCoordinating_Cost_Center_Reference($coordinating_Cost_Center_Reference)
            ->setAsset_Coordinator_Reference($asset_Coordinator_Reference)
            ->setDiscrete_Child_Component_Asset_Data($discrete_Child_Component_Asset_Data)
            ->setRelated_Asset_Replacement_Data($related_Asset_Replacement_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\OrganizationObjectType $company_Reference
     * @return \StructType\Asset_Edit_DataType
     */
    public function setCompany_Reference(\StructType\OrganizationObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Asset_ID value
     * @return string|null
     */
    public function getAsset_ID()
    {
        return $this->Asset_ID;
    }
    /**
     * Set Asset_ID value
     * @param string $asset_ID
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAsset_ID($asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($asset_ID) && !is_string($asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_ID, true), gettype($asset_ID)), __LINE__);
        }
        $this->Asset_ID = $asset_ID;
        return $this;
    }
    /**
     * Get Asset_Description value
     * @return string|null
     */
    public function getAsset_Description()
    {
        return $this->Asset_Description;
    }
    /**
     * Set Asset_Description value
     * @param string $asset_Description
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAsset_Description($asset_Description = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Description) && !is_string($asset_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Description, true), gettype($asset_Description)), __LINE__);
        }
        $this->Asset_Description = $asset_Description;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Asset_Edit_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Asset_Name value
     * @return string|null
     */
    public function getAsset_Name()
    {
        return $this->Asset_Name;
    }
    /**
     * Set Asset_Name value
     * @param string $asset_Name
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAsset_Name($asset_Name = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Name) && !is_string($asset_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Name, true), gettype($asset_Name)), __LINE__);
        }
        $this->Asset_Name = $asset_Name;
        return $this;
    }
    /**
     * Get Total_Asset_Cost value
     * @return float|null
     */
    public function getTotal_Asset_Cost()
    {
        return $this->Total_Asset_Cost;
    }
    /**
     * Set Total_Asset_Cost value
     * @param float $total_Asset_Cost
     * @return \StructType\Asset_Edit_DataType
     */
    public function setTotal_Asset_Cost($total_Asset_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($total_Asset_Cost) && !(is_float($total_Asset_Cost) || is_numeric($total_Asset_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Asset_Cost, true), gettype($total_Asset_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Asset_Cost) && mb_strlen(mb_substr($total_Asset_Cost, false !== mb_strpos($total_Asset_Cost, '.') ? mb_strpos($total_Asset_Cost, '.') + 1 : mb_strlen($total_Asset_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Asset_Cost, true), mb_strlen(mb_substr($total_Asset_Cost, mb_strpos($total_Asset_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Asset_Cost) && mb_strlen(preg_replace('/(\D)/', '', $total_Asset_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Asset_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $total_Asset_Cost))), __LINE__);
        }
        $this->Total_Asset_Cost = $total_Asset_Cost;
        return $this;
    }
    /**
     * Get Total_Quantity value
     * @return float|null
     */
    public function getTotal_Quantity()
    {
        return $this->Total_Quantity;
    }
    /**
     * Set Total_Quantity value
     * @param float $total_Quantity
     * @return \StructType\Asset_Edit_DataType
     */
    public function setTotal_Quantity($total_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($total_Quantity) && !(is_float($total_Quantity) || is_numeric($total_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Quantity, true), gettype($total_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($total_Quantity) && mb_strlen(mb_substr($total_Quantity, false !== mb_strpos($total_Quantity, '.') ? mb_strpos($total_Quantity, '.') + 1 : mb_strlen($total_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($total_Quantity, true), mb_strlen(mb_substr($total_Quantity, mb_strpos($total_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($total_Quantity) && $total_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($total_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($total_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $total_Quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($total_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $total_Quantity))), __LINE__);
        }
        $this->Total_Quantity = $total_Quantity;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @return \StructType\Asset_Edit_DataType
     */
    public function setItem_Reference(\StructType\Item_DescriptorObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Asset_Identifier value
     * @return string|null
     */
    public function getAsset_Identifier()
    {
        return $this->Asset_Identifier;
    }
    /**
     * Set Asset_Identifier value
     * @param string $asset_Identifier
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAsset_Identifier($asset_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Identifier) && !is_string($asset_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Identifier, true), gettype($asset_Identifier)), __LINE__);
        }
        $this->Asset_Identifier = $asset_Identifier;
        return $this;
    }
    /**
     * Get Serial_Number value
     * @return string|null
     */
    public function getSerial_Number()
    {
        return $this->Serial_Number;
    }
    /**
     * Set Serial_Number value
     * @param string $serial_Number
     * @return \StructType\Asset_Edit_DataType
     */
    public function setSerial_Number($serial_Number = null)
    {
        // validation for constraint: string
        if (!is_null($serial_Number) && !is_string($serial_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial_Number, true), gettype($serial_Number)), __LINE__);
        }
        $this->Serial_Number = $serial_Number;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param string $manufacturer
     * @return \StructType\Asset_Edit_DataType
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Business_Use_Percentage value
     * @return float|null
     */
    public function getBusiness_Use_Percentage()
    {
        return $this->Business_Use_Percentage;
    }
    /**
     * Set Business_Use_Percentage value
     * @param float $business_Use_Percentage
     * @return \StructType\Asset_Edit_DataType
     */
    public function setBusiness_Use_Percentage($business_Use_Percentage = null)
    {
        // validation for constraint: float
        if (!is_null($business_Use_Percentage) && !(is_float($business_Use_Percentage) || is_numeric($business_Use_Percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($business_Use_Percentage, true), gettype($business_Use_Percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($business_Use_Percentage) && mb_strlen(mb_substr($business_Use_Percentage, false !== mb_strpos($business_Use_Percentage, '.') ? mb_strpos($business_Use_Percentage, '.') + 1 : mb_strlen($business_Use_Percentage))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($business_Use_Percentage, true), mb_strlen(mb_substr($business_Use_Percentage, mb_strpos($business_Use_Percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($business_Use_Percentage) && $business_Use_Percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($business_Use_Percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($business_Use_Percentage) && mb_strlen(preg_replace('/(\D)/', '', $business_Use_Percentage)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($business_Use_Percentage, true), mb_strlen(preg_replace('/(\D)/', '', $business_Use_Percentage))), __LINE__);
        }
        $this->Business_Use_Percentage = $business_Use_Percentage;
        return $this;
    }
    /**
     * Get Coordinating_Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCoordinating_Cost_Center_Reference()
    {
        return $this->Coordinating_Cost_Center_Reference;
    }
    /**
     * Set Coordinating_Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference
     * @return \StructType\Asset_Edit_DataType
     */
    public function setCoordinating_Cost_Center_Reference(\StructType\Cost_CenterObjectType $coordinating_Cost_Center_Reference = null)
    {
        $this->Coordinating_Cost_Center_Reference = $coordinating_Cost_Center_Reference;
        return $this;
    }
    /**
     * Get Asset_Coordinator_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAsset_Coordinator_Reference()
    {
        return $this->Asset_Coordinator_Reference;
    }
    /**
     * Set Asset_Coordinator_Reference value
     * @param \StructType\WorkerObjectType $asset_Coordinator_Reference
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAsset_Coordinator_Reference(\StructType\WorkerObjectType $asset_Coordinator_Reference = null)
    {
        $this->Asset_Coordinator_Reference = $asset_Coordinator_Reference;
        return $this;
    }
    /**
     * Get Discrete_Child_Component_Asset_Data value
     * @return \StructType\Discrete_Child_ComponentType[]|null
     */
    public function getDiscrete_Child_Component_Asset_Data()
    {
        return $this->Discrete_Child_Component_Asset_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscrete_Child_Component_Asset_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscrete_Child_Component_Asset_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscrete_Child_Component_Asset_DataForArrayConstraintsFromSetDiscrete_Child_Component_Asset_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Edit_DataTypeDiscrete_Child_Component_Asset_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Edit_DataTypeDiscrete_Child_Component_Asset_DataItem instanceof \StructType\Discrete_Child_ComponentType) {
                $invalidValues[] = is_object($asset_Edit_DataTypeDiscrete_Child_Component_Asset_DataItem) ? get_class($asset_Edit_DataTypeDiscrete_Child_Component_Asset_DataItem) : sprintf('%s(%s)', gettype($asset_Edit_DataTypeDiscrete_Child_Component_Asset_DataItem), var_export($asset_Edit_DataTypeDiscrete_Child_Component_Asset_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Discrete_Child_Component_Asset_Data property can only contain items of type \StructType\Discrete_Child_ComponentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Discrete_Child_Component_Asset_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Discrete_Child_ComponentType[] $discrete_Child_Component_Asset_Data
     * @return \StructType\Asset_Edit_DataType
     */
    public function setDiscrete_Child_Component_Asset_Data(array $discrete_Child_Component_Asset_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($discrete_Child_Component_Asset_DataArrayErrorMessage = self::validateDiscrete_Child_Component_Asset_DataForArrayConstraintsFromSetDiscrete_Child_Component_Asset_Data($discrete_Child_Component_Asset_Data))) {
            throw new \InvalidArgumentException($discrete_Child_Component_Asset_DataArrayErrorMessage, __LINE__);
        }
        $this->Discrete_Child_Component_Asset_Data = $discrete_Child_Component_Asset_Data;
        return $this;
    }
    /**
     * Add item to Discrete_Child_Component_Asset_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Discrete_Child_ComponentType $item
     * @return \StructType\Asset_Edit_DataType
     */
    public function addToDiscrete_Child_Component_Asset_Data(\StructType\Discrete_Child_ComponentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Discrete_Child_ComponentType) {
            throw new \InvalidArgumentException(sprintf('The Discrete_Child_Component_Asset_Data property can only contain items of type \StructType\Discrete_Child_ComponentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Discrete_Child_Component_Asset_Data[] = $item;
        return $this;
    }
    /**
     * Get Related_Asset_Replacement_Data value
     * @return \StructType\Related_Asset_Replacement_DataType[]|null
     */
    public function getRelated_Asset_Replacement_Data()
    {
        return $this->Related_Asset_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRelated_Asset_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelated_Asset_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelated_Asset_Replacement_DataForArrayConstraintsFromSetRelated_Asset_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Edit_DataTypeRelated_Asset_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Edit_DataTypeRelated_Asset_Replacement_DataItem instanceof \StructType\Related_Asset_Replacement_DataType) {
                $invalidValues[] = is_object($asset_Edit_DataTypeRelated_Asset_Replacement_DataItem) ? get_class($asset_Edit_DataTypeRelated_Asset_Replacement_DataItem) : sprintf('%s(%s)', gettype($asset_Edit_DataTypeRelated_Asset_Replacement_DataItem), var_export($asset_Edit_DataTypeRelated_Asset_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Related_Asset_Replacement_Data property can only contain items of type \StructType\Related_Asset_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Related_Asset_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Related_Asset_Replacement_DataType[] $related_Asset_Replacement_Data
     * @return \StructType\Asset_Edit_DataType
     */
    public function setRelated_Asset_Replacement_Data(array $related_Asset_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($related_Asset_Replacement_DataArrayErrorMessage = self::validateRelated_Asset_Replacement_DataForArrayConstraintsFromSetRelated_Asset_Replacement_Data($related_Asset_Replacement_Data))) {
            throw new \InvalidArgumentException($related_Asset_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Related_Asset_Replacement_Data = $related_Asset_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Related_Asset_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Related_Asset_Replacement_DataType $item
     * @return \StructType\Asset_Edit_DataType
     */
    public function addToRelated_Asset_Replacement_Data(\StructType\Related_Asset_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Related_Asset_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Related_Asset_Replacement_Data property can only contain items of type \StructType\Related_Asset_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Related_Asset_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Edit_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Edit_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($asset_Edit_DataTypeAttachment_DataItem) ? get_class($asset_Edit_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($asset_Edit_DataTypeAttachment_DataItem), var_export($asset_Edit_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Asset_Edit_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Asset_Edit_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
