<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Travel_Profile_Attachment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Worker Travel Profile Attachment data.
 * @subpackage Structs
 */
class Worker_Travel_Profile_Attachment_DataType extends AbstractStructBase
{
    /**
     * The File
     * Meta information extracted from the WSDL
     * - documentation: File content in binary format.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Content_Type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * @var string
     */
    public $Content_Type;
    /**
     * The Filename
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * @var string
     */
    public $Filename;
    /**
     * The Attachment_Encoding
     * Meta information extracted from the WSDL
     * - documentation: Text attribute identifying Encoding of the Attachment.
     * @var string
     */
    public $Attachment_Encoding;
    /**
     * The Compressed
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute identifying whether the Attachment is compressed.
     * @var bool
     */
    public $Compressed;
    /**
     * Constructor method for Worker_Travel_Profile_Attachment_DataType
     * @uses Worker_Travel_Profile_Attachment_DataType::setFile()
     * @uses Worker_Travel_Profile_Attachment_DataType::setComment()
     * @uses Worker_Travel_Profile_Attachment_DataType::setContent_Type()
     * @uses Worker_Travel_Profile_Attachment_DataType::setFilename()
     * @uses Worker_Travel_Profile_Attachment_DataType::setAttachment_Encoding()
     * @uses Worker_Travel_Profile_Attachment_DataType::setCompressed()
     * @param string $file
     * @param string $comment
     * @param string $content_Type
     * @param string $filename
     * @param string $attachment_Encoding
     * @param bool $compressed
     */
    public function __construct($file = null, $comment = null, $content_Type = null, $filename = null, $attachment_Encoding = null, $compressed = null)
    {
        $this
            ->setFile($file)
            ->setComment($comment)
            ->setContent_Type($content_Type)
            ->setFilename($filename)
            ->setAttachment_Encoding($attachment_Encoding)
            ->setCompressed($compressed);
    }
    /**
     * Get File value
     * @return string|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @param string $file
     * @return \StructType\Worker_Travel_Profile_Attachment_DataType
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file, true), gettype($file)), __LINE__);
        }
        $this->File = $file;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Worker_Travel_Profile_Attachment_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Content_Type value
     * @return string|null
     */
    public function getContent_Type()
    {
        return $this->Content_Type;
    }
    /**
     * Set Content_Type value
     * @param string $content_Type
     * @return \StructType\Worker_Travel_Profile_Attachment_DataType
     */
    public function setContent_Type($content_Type = null)
    {
        // validation for constraint: string
        if (!is_null($content_Type) && !is_string($content_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content_Type, true), gettype($content_Type)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($content_Type) && mb_strlen($content_Type) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($content_Type)), __LINE__);
        }
        $this->Content_Type = $content_Type;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\Worker_Travel_Profile_Attachment_DataType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($filename) && mb_strlen($filename) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Attachment_Encoding value
     * @return string|null
     */
    public function getAttachment_Encoding()
    {
        return $this->Attachment_Encoding;
    }
    /**
     * Set Attachment_Encoding value
     * @param string $attachment_Encoding
     * @return \StructType\Worker_Travel_Profile_Attachment_DataType
     */
    public function setAttachment_Encoding($attachment_Encoding = null)
    {
        // validation for constraint: string
        if (!is_null($attachment_Encoding) && !is_string($attachment_Encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachment_Encoding, true), gettype($attachment_Encoding)), __LINE__);
        }
        $this->Attachment_Encoding = $attachment_Encoding;
        return $this;
    }
    /**
     * Get Compressed value
     * @return bool|null
     */
    public function getCompressed()
    {
        return $this->Compressed;
    }
    /**
     * Set Compressed value
     * @param bool $compressed
     * @return \StructType\Worker_Travel_Profile_Attachment_DataType
     */
    public function setCompressed($compressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($compressed) && !is_bool($compressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compressed, true), gettype($compressed)), __LINE__);
        }
        $this->Compressed = $compressed;
        return $this;
    }
}
