<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_Status_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: If Delete is set to true, Replace All must be set to false in Tax Status Widget Data. | Tax Status Widget Element to include Tax Status information
 * @subpackage Structs
 */
class Tax_Status_Widget_DataType extends AbstractStructBase
{
    /**
     * The Tax_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Tax Status Data WWS element to specify 1 or more Tax Statuses for a company.
     * - maxOccurs: unbounded
     * @var \StructType\Tax_Status_WWS_DataType[]
     */
    public $Tax_Status_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: Replace All boolean to replace (True) or update (False) Tax Status information for a Supplier.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Tax_Status_Widget_DataType
     * @uses Tax_Status_Widget_DataType::setTax_Status_Data()
     * @uses Tax_Status_Widget_DataType::setReplace_All()
     * @param \StructType\Tax_Status_WWS_DataType[] $tax_Status_Data
     * @param bool $replace_All
     */
    public function __construct(array $tax_Status_Data = array(), $replace_All = null)
    {
        $this
            ->setTax_Status_Data($tax_Status_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Tax_Status_Data value
     * @return \StructType\Tax_Status_WWS_DataType[]|null
     */
    public function getTax_Status_Data()
    {
        return $this->Tax_Status_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Status_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Status_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Status_DataForArrayConstraintsFromSetTax_Status_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_Status_Widget_DataTypeTax_Status_DataItem) {
            // validation for constraint: itemType
            if (!$tax_Status_Widget_DataTypeTax_Status_DataItem instanceof \StructType\Tax_Status_WWS_DataType) {
                $invalidValues[] = is_object($tax_Status_Widget_DataTypeTax_Status_DataItem) ? get_class($tax_Status_Widget_DataTypeTax_Status_DataItem) : sprintf('%s(%s)', gettype($tax_Status_Widget_DataTypeTax_Status_DataItem), var_export($tax_Status_Widget_DataTypeTax_Status_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Status_Data property can only contain items of type \StructType\Tax_Status_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Status_WWS_DataType[] $tax_Status_Data
     * @return \StructType\Tax_Status_Widget_DataType
     */
    public function setTax_Status_Data(array $tax_Status_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Status_DataArrayErrorMessage = self::validateTax_Status_DataForArrayConstraintsFromSetTax_Status_Data($tax_Status_Data))) {
            throw new \InvalidArgumentException($tax_Status_DataArrayErrorMessage, __LINE__);
        }
        $this->Tax_Status_Data = $tax_Status_Data;
        return $this;
    }
    /**
     * Add item to Tax_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Status_WWS_DataType $item
     * @return \StructType\Tax_Status_Widget_DataType
     */
    public function addToTax_Status_Data(\StructType\Tax_Status_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Status_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Status_Data property can only contain items of type \StructType\Tax_Status_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Status_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Tax_Status_Widget_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
