<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Template_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing filter criteria for Requisition Templates
 * @subpackage Structs
 */
class Requisition_Template_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company for Requisition Template. This value will be used as a filter criteria for Requisition Templates
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Template_Name
     * Meta information extracted from the WSDL
     * - documentation: Requisition Template Name. This value will be used as a filter criteria for Requisition Templates
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Template_Name;
    /**
     * The Owned_by_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requisition Template Owned By. This value will be used as a filter criteria for Requisition Templates
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Owned_by_Reference;
    /**
     * Constructor method for Requisition_Template_Request_CriteriaType
     * @uses Requisition_Template_Request_CriteriaType::setCompany_Reference()
     * @uses Requisition_Template_Request_CriteriaType::setTemplate_Name()
     * @uses Requisition_Template_Request_CriteriaType::setOwned_by_Reference()
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $template_Name
     * @param \StructType\WorkerObjectType $owned_by_Reference
     */
    public function __construct(\StructType\CompanyObjectType $company_Reference = null, $template_Name = null, \StructType\WorkerObjectType $owned_by_Reference = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setTemplate_Name($template_Name)
            ->setOwned_by_Reference($owned_by_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Requisition_Template_Request_CriteriaType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Template_Name value
     * @return string|null
     */
    public function getTemplate_Name()
    {
        return $this->Template_Name;
    }
    /**
     * Set Template_Name value
     * @param string $template_Name
     * @return \StructType\Requisition_Template_Request_CriteriaType
     */
    public function setTemplate_Name($template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($template_Name) && !is_string($template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_Name, true), gettype($template_Name)), __LINE__);
        }
        $this->Template_Name = $template_Name;
        return $this;
    }
    /**
     * Get Owned_by_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getOwned_by_Reference()
    {
        return $this->Owned_by_Reference;
    }
    /**
     * Set Owned_by_Reference value
     * @param \StructType\WorkerObjectType $owned_by_Reference
     * @return \StructType\Requisition_Template_Request_CriteriaType
     */
    public function setOwned_by_Reference(\StructType\WorkerObjectType $owned_by_Reference = null)
    {
        $this->Owned_by_Reference = $owned_by_Reference;
        return $this;
    }
}
