<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Payment Tax Certificate Manual Numbers Data
 * @subpackage Structs
 */
class Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType extends AbstractStructBase
{
    /**
     * The Tax_Certificate_Number
     * Meta information extracted from the WSDL
     * - documentation: Manual Tax Certificate Numbers On Payment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tax_Certificate_Number;
    /**
     * Constructor method for Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType
     * @uses Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType::setTax_Certificate_Number()
     * @param string $tax_Certificate_Number
     */
    public function __construct($tax_Certificate_Number = null)
    {
        $this
            ->setTax_Certificate_Number($tax_Certificate_Number);
    }
    /**
     * Get Tax_Certificate_Number value
     * @return string|null
     */
    public function getTax_Certificate_Number()
    {
        return $this->Tax_Certificate_Number;
    }
    /**
     * Set Tax_Certificate_Number value
     * @param string $tax_Certificate_Number
     * @return \StructType\Supplier_Payment_Tax_Certificate_Manual_Numbers_DataType
     */
    public function setTax_Certificate_Number($tax_Certificate_Number = null)
    {
        // validation for constraint: string
        if (!is_null($tax_Certificate_Number) && !is_string($tax_Certificate_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_Certificate_Number, true), gettype($tax_Certificate_Number)), __LINE__);
        }
        $this->Tax_Certificate_Number = $tax_Certificate_Number;
        return $this;
    }
}
