<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Retention_Release_Line_WWS_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing Supplier Invoice Retention Release Line data.
 * @subpackage Structs
 */
class Supplier_Invoice_Retention_Release_Line_WWS_DataType extends AbstractStructBase
{
    /**
     * The Retention_Release_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Retention Release Line Reference ID. This is the Retention Release Line unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Retention_Release_Line_ID;
    /**
     * The PO_or_Contract_Line_with_Retention_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to an existing Supplier Contract Line or Purchase Order Line with a retained amount in the Workday system. This is used to link the Supplier Invoice Retention Release Line with a Supplier Contract Line or Purchase Order
     * Line.
     * @var \StructType\Abstract_Retainable_LineObjectType
     */
    public $PO_or_Contract_Line_with_Retention_Reference;
    /**
     * The Amount_Released
     * Meta information extracted from the WSDL
     * - documentation: The Retention Amount to release. Amount may not exceed the remaining retention balance for this line.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Amount_Released;
    /**
     * Constructor method for Supplier_Invoice_Retention_Release_Line_WWS_DataType
     * @uses Supplier_Invoice_Retention_Release_Line_WWS_DataType::setRetention_Release_Line_ID()
     * @uses Supplier_Invoice_Retention_Release_Line_WWS_DataType::setPO_or_Contract_Line_with_Retention_Reference()
     * @uses Supplier_Invoice_Retention_Release_Line_WWS_DataType::setAmount_Released()
     * @param string $retention_Release_Line_ID
     * @param \StructType\Abstract_Retainable_LineObjectType $pO_or_Contract_Line_with_Retention_Reference
     * @param float $amount_Released
     */
    public function __construct($retention_Release_Line_ID = null, \StructType\Abstract_Retainable_LineObjectType $pO_or_Contract_Line_with_Retention_Reference = null, $amount_Released = null)
    {
        $this
            ->setRetention_Release_Line_ID($retention_Release_Line_ID)
            ->setPO_or_Contract_Line_with_Retention_Reference($pO_or_Contract_Line_with_Retention_Reference)
            ->setAmount_Released($amount_Released);
    }
    /**
     * Get Retention_Release_Line_ID value
     * @return string|null
     */
    public function getRetention_Release_Line_ID()
    {
        return $this->Retention_Release_Line_ID;
    }
    /**
     * Set Retention_Release_Line_ID value
     * @param string $retention_Release_Line_ID
     * @return \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType
     */
    public function setRetention_Release_Line_ID($retention_Release_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($retention_Release_Line_ID) && !is_string($retention_Release_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retention_Release_Line_ID, true), gettype($retention_Release_Line_ID)), __LINE__);
        }
        $this->Retention_Release_Line_ID = $retention_Release_Line_ID;
        return $this;
    }
    /**
     * Get PO_or_Contract_Line_with_Retention_Reference value
     * @return \StructType\Abstract_Retainable_LineObjectType|null
     */
    public function getPO_or_Contract_Line_with_Retention_Reference()
    {
        return $this->PO_or_Contract_Line_with_Retention_Reference;
    }
    /**
     * Set PO_or_Contract_Line_with_Retention_Reference value
     * @param \StructType\Abstract_Retainable_LineObjectType $pO_or_Contract_Line_with_Retention_Reference
     * @return \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType
     */
    public function setPO_or_Contract_Line_with_Retention_Reference(\StructType\Abstract_Retainable_LineObjectType $pO_or_Contract_Line_with_Retention_Reference = null)
    {
        $this->PO_or_Contract_Line_with_Retention_Reference = $pO_or_Contract_Line_with_Retention_Reference;
        return $this;
    }
    /**
     * Get Amount_Released value
     * @return float|null
     */
    public function getAmount_Released()
    {
        return $this->Amount_Released;
    }
    /**
     * Set Amount_Released value
     * @param float $amount_Released
     * @return \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType
     */
    public function setAmount_Released($amount_Released = null)
    {
        // validation for constraint: float
        if (!is_null($amount_Released) && !(is_float($amount_Released) || is_numeric($amount_Released))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_Released, true), gettype($amount_Released)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount_Released) && mb_strlen(mb_substr($amount_Released, false !== mb_strpos($amount_Released, '.') ? mb_strpos($amount_Released, '.') + 1 : mb_strlen($amount_Released))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount_Released, true), mb_strlen(mb_substr($amount_Released, mb_strpos($amount_Released, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($amount_Released) && $amount_Released < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($amount_Released, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($amount_Released) && mb_strlen(preg_replace('/(\D)/', '', $amount_Released)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($amount_Released, true), mb_strlen(preg_replace('/(\D)/', '', $amount_Released))), __LINE__);
        }
        $this->Amount_Released = $amount_Released;
        return $this;
    }
}
