<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Procurement_Mass_Close_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Procurement Mass Close reference for submit and all Procurement Mass Close data items.
 * @subpackage Structs
 */
class Submit_Procurement_Mass_Close_RequestType extends AbstractStructBase
{
    /**
     * The Procurement_Mass_Close_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Mass Close Reference
     * - minOccurs: 0
     * @var \StructType\Procurement_Document_Mass_ActionObjectType
     */
    public $Procurement_Mass_Close_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-complete the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Procurement_Mass_Close_Data
     * Meta information extracted from the WSDL
     * - documentation: Procurement Mass Close Data
     * - minOccurs: 0
     * @var \StructType\Procurement_Mass_Close_DataType
     */
    public $Procurement_Mass_Close_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Procurement_Mass_Close_RequestType
     * @uses Submit_Procurement_Mass_Close_RequestType::setProcurement_Mass_Close_Reference()
     * @uses Submit_Procurement_Mass_Close_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Procurement_Mass_Close_RequestType::setProcurement_Mass_Close_Data()
     * @uses Submit_Procurement_Mass_Close_RequestType::setVersion()
     * @param \StructType\Procurement_Document_Mass_ActionObjectType $procurement_Mass_Close_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Procurement_Mass_Close_DataType $procurement_Mass_Close_Data
     * @param string $version
     */
    public function __construct(\StructType\Procurement_Document_Mass_ActionObjectType $procurement_Mass_Close_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Procurement_Mass_Close_DataType $procurement_Mass_Close_Data = null, $version = null)
    {
        $this
            ->setProcurement_Mass_Close_Reference($procurement_Mass_Close_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setProcurement_Mass_Close_Data($procurement_Mass_Close_Data)
            ->setVersion($version);
    }
    /**
     * Get Procurement_Mass_Close_Reference value
     * @return \StructType\Procurement_Document_Mass_ActionObjectType|null
     */
    public function getProcurement_Mass_Close_Reference()
    {
        return $this->Procurement_Mass_Close_Reference;
    }
    /**
     * Set Procurement_Mass_Close_Reference value
     * @param \StructType\Procurement_Document_Mass_ActionObjectType $procurement_Mass_Close_Reference
     * @return \StructType\Submit_Procurement_Mass_Close_RequestType
     */
    public function setProcurement_Mass_Close_Reference(\StructType\Procurement_Document_Mass_ActionObjectType $procurement_Mass_Close_Reference = null)
    {
        $this->Procurement_Mass_Close_Reference = $procurement_Mass_Close_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Procurement_Mass_Close_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Procurement_Mass_Close_Data value
     * @return \StructType\Procurement_Mass_Close_DataType|null
     */
    public function getProcurement_Mass_Close_Data()
    {
        return $this->Procurement_Mass_Close_Data;
    }
    /**
     * Set Procurement_Mass_Close_Data value
     * @param \StructType\Procurement_Mass_Close_DataType $procurement_Mass_Close_Data
     * @return \StructType\Submit_Procurement_Mass_Close_RequestType
     */
    public function setProcurement_Mass_Close_Data(\StructType\Procurement_Mass_Close_DataType $procurement_Mass_Close_Data = null)
    {
        $this->Procurement_Mass_Close_Data = $procurement_Mass_Close_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Procurement_Mass_Close_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
