<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ship_to_Address_for_RequisitionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a reference instance or a Address Reference ID for an existing address
 * @subpackage Structs
 */
class Ship_to_Address_for_RequisitionType extends AbstractStructBase
{
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference ID
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceType[]
     */
    public $Address_Reference;
    /**
     * Constructor method for Ship_to_Address_for_RequisitionType
     * @uses Ship_to_Address_for_RequisitionType::setShip_To_Address_Reference()
     * @uses Ship_to_Address_for_RequisitionType::setAddress_Reference()
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\Address_ReferenceType[] $address_Reference
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, array $address_Reference = array())
    {
        $this
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setAddress_Reference($address_Reference);
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Ship_to_Address_for_RequisitionType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Address_Reference value
     * @return \StructType\Address_ReferenceType[]|null
     */
    public function getAddress_Reference()
    {
        return $this->Address_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress_ReferenceForArrayConstraintsFromSetAddress_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ship_to_Address_for_RequisitionTypeAddress_ReferenceItem) {
            // validation for constraint: itemType
            if (!$ship_to_Address_for_RequisitionTypeAddress_ReferenceItem instanceof \StructType\Address_ReferenceType) {
                $invalidValues[] = is_object($ship_to_Address_for_RequisitionTypeAddress_ReferenceItem) ? get_class($ship_to_Address_for_RequisitionTypeAddress_ReferenceItem) : sprintf('%s(%s)', gettype($ship_to_Address_for_RequisitionTypeAddress_ReferenceItem), var_export($ship_to_Address_for_RequisitionTypeAddress_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address_Reference property can only contain items of type \StructType\Address_ReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_ReferenceType[] $address_Reference
     * @return \StructType\Ship_to_Address_for_RequisitionType
     */
    public function setAddress_Reference(array $address_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($address_ReferenceArrayErrorMessage = self::validateAddress_ReferenceForArrayConstraintsFromSetAddress_Reference($address_Reference))) {
            throw new \InvalidArgumentException($address_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Address_Reference = $address_Reference;
        return $this;
    }
    /**
     * Add item to Address_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_ReferenceType $item
     * @return \StructType\Ship_to_Address_for_RequisitionType
     */
    public function addToAddress_Reference(\StructType\Address_ReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address_ReferenceType) {
            throw new \InvalidArgumentException(sprintf('The Address_Reference property can only contain items of type \StructType\Address_ReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address_Reference[] = $item;
        return $this;
    }
}
