<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Return_to_Supplier_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Return Data
 * @subpackage Structs
 */
class Return_to_Supplier_DataType extends AbstractStructBase
{
    /**
     * The Return_Number
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Return_Number;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Return Status. Examples of Document Status are Approved, Denied, Draft, In Progress
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Return_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Return Reason
     * - minOccurs: 0
     * @var \StructType\Return_to_Supplier_ReasonObjectType
     */
    public $Return_Reason_Reference;
    /**
     * The Return_Date
     * Meta information extracted from the WSDL
     * - documentation: Document Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Return_Date;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice on the Return
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Supplier_RMA
     * Meta information extracted from the WSDL
     * - documentation: Supplier RMA on the Return
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_RMA;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Restocking_Fee_Amount
     * Meta information extracted from the WSDL
     * - documentation: Restocking Fee Amount for Return to Supplier
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Restocking_Fee_Amount;
    /**
     * The Return_Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Return Ship-To Address
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Return_Ship_To_Address_Reference;
    /**
     * The Pick_Up_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Pick Up Location
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Pick_Up_Location_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Document Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Created_by_Person_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Person who Created the Return
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Created_by_Person_Reference;
    /**
     * The Return_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Return_to_Supplier_Line_DataType[]
     */
    public $Return_Line_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Return_to_Supplier_DataType
     * @uses Return_to_Supplier_DataType::setReturn_Number()
     * @uses Return_to_Supplier_DataType::setDocument_Status_Reference()
     * @uses Return_to_Supplier_DataType::setCompany_Reference()
     * @uses Return_to_Supplier_DataType::setSupplier_Reference()
     * @uses Return_to_Supplier_DataType::setReturn_Reason_Reference()
     * @uses Return_to_Supplier_DataType::setReturn_Date()
     * @uses Return_to_Supplier_DataType::setSupplier_Invoice_Reference()
     * @uses Return_to_Supplier_DataType::setSupplier_RMA()
     * @uses Return_to_Supplier_DataType::setCurrency_Reference()
     * @uses Return_to_Supplier_DataType::setRestocking_Fee_Amount()
     * @uses Return_to_Supplier_DataType::setReturn_Ship_To_Address_Reference()
     * @uses Return_to_Supplier_DataType::setPick_Up_Location_Reference()
     * @uses Return_to_Supplier_DataType::setMemo()
     * @uses Return_to_Supplier_DataType::setCreated_by_Person_Reference()
     * @uses Return_to_Supplier_DataType::setReturn_Line_Data()
     * @uses Return_to_Supplier_DataType::setAttachment_Data()
     * @param string $return_Number
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference
     * @param string $return_Date
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param string $supplier_RMA
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $restocking_Fee_Amount
     * @param \StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference
     * @param \StructType\LocationObjectType $pick_Up_Location_Reference
     * @param string $memo
     * @param \StructType\Unique_IdentifierObjectType $created_by_Person_Reference
     * @param \StructType\Return_to_Supplier_Line_DataType[] $return_Line_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct($return_Number = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference = null, $return_Date = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, $supplier_RMA = null, \StructType\CurrencyObjectType $currency_Reference = null, $restocking_Fee_Amount = null, \StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference = null, \StructType\LocationObjectType $pick_Up_Location_Reference = null, $memo = null, \StructType\Unique_IdentifierObjectType $created_by_Person_Reference = null, array $return_Line_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setReturn_Number($return_Number)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setReturn_Reason_Reference($return_Reason_Reference)
            ->setReturn_Date($return_Date)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setSupplier_RMA($supplier_RMA)
            ->setCurrency_Reference($currency_Reference)
            ->setRestocking_Fee_Amount($restocking_Fee_Amount)
            ->setReturn_Ship_To_Address_Reference($return_Ship_To_Address_Reference)
            ->setPick_Up_Location_Reference($pick_Up_Location_Reference)
            ->setMemo($memo)
            ->setCreated_by_Person_Reference($created_by_Person_Reference)
            ->setReturn_Line_Data($return_Line_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Return_Number value
     * @return string|null
     */
    public function getReturn_Number()
    {
        return $this->Return_Number;
    }
    /**
     * Set Return_Number value
     * @param string $return_Number
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setReturn_Number($return_Number = null)
    {
        // validation for constraint: string
        if (!is_null($return_Number) && !is_string($return_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_Number, true), gettype($return_Number)), __LINE__);
        }
        $this->Return_Number = $return_Number;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Return_Reason_Reference value
     * @return \StructType\Return_to_Supplier_ReasonObjectType|null
     */
    public function getReturn_Reason_Reference()
    {
        return $this->Return_Reason_Reference;
    }
    /**
     * Set Return_Reason_Reference value
     * @param \StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setReturn_Reason_Reference(\StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference = null)
    {
        $this->Return_Reason_Reference = $return_Reason_Reference;
        return $this;
    }
    /**
     * Get Return_Date value
     * @return string|null
     */
    public function getReturn_Date()
    {
        return $this->Return_Date;
    }
    /**
     * Set Return_Date value
     * @param string $return_Date
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setReturn_Date($return_Date = null)
    {
        // validation for constraint: string
        if (!is_null($return_Date) && !is_string($return_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_Date, true), gettype($return_Date)), __LINE__);
        }
        $this->Return_Date = $return_Date;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Supplier_RMA value
     * @return string|null
     */
    public function getSupplier_RMA()
    {
        return $this->Supplier_RMA;
    }
    /**
     * Set Supplier_RMA value
     * @param string $supplier_RMA
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setSupplier_RMA($supplier_RMA = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_RMA) && !is_string($supplier_RMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_RMA, true), gettype($supplier_RMA)), __LINE__);
        }
        $this->Supplier_RMA = $supplier_RMA;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Restocking_Fee_Amount value
     * @return float|null
     */
    public function getRestocking_Fee_Amount()
    {
        return $this->Restocking_Fee_Amount;
    }
    /**
     * Set Restocking_Fee_Amount value
     * @param float $restocking_Fee_Amount
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setRestocking_Fee_Amount($restocking_Fee_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($restocking_Fee_Amount) && !(is_float($restocking_Fee_Amount) || is_numeric($restocking_Fee_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($restocking_Fee_Amount, true), gettype($restocking_Fee_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($restocking_Fee_Amount) && mb_strlen(mb_substr($restocking_Fee_Amount, false !== mb_strpos($restocking_Fee_Amount, '.') ? mb_strpos($restocking_Fee_Amount, '.') + 1 : mb_strlen($restocking_Fee_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($restocking_Fee_Amount, true), mb_strlen(mb_substr($restocking_Fee_Amount, mb_strpos($restocking_Fee_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($restocking_Fee_Amount) && mb_strlen(preg_replace('/(\D)/', '', $restocking_Fee_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($restocking_Fee_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $restocking_Fee_Amount))), __LINE__);
        }
        $this->Restocking_Fee_Amount = $restocking_Fee_Amount;
        return $this;
    }
    /**
     * Get Return_Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReturn_Ship_To_Address_Reference()
    {
        return $this->{'Return_Ship-To_Address_Reference'};
    }
    /**
     * Set Return_Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setReturn_Ship_To_Address_Reference(\StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference = null)
    {
        $this->Return_Ship_To_Address_Reference = $this->{'Return_Ship-To_Address_Reference'} = $return_Ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Pick_Up_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getPick_Up_Location_Reference()
    {
        return $this->Pick_Up_Location_Reference;
    }
    /**
     * Set Pick_Up_Location_Reference value
     * @param \StructType\LocationObjectType $pick_Up_Location_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setPick_Up_Location_Reference(\StructType\LocationObjectType $pick_Up_Location_Reference = null)
    {
        $this->Pick_Up_Location_Reference = $pick_Up_Location_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Created_by_Person_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getCreated_by_Person_Reference()
    {
        return $this->Created_by_Person_Reference;
    }
    /**
     * Set Created_by_Person_Reference value
     * @param \StructType\Unique_IdentifierObjectType $created_by_Person_Reference
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setCreated_by_Person_Reference(\StructType\Unique_IdentifierObjectType $created_by_Person_Reference = null)
    {
        $this->Created_by_Person_Reference = $created_by_Person_Reference;
        return $this;
    }
    /**
     * Get Return_Line_Data value
     * @return \StructType\Return_to_Supplier_Line_DataType[]|null
     */
    public function getReturn_Line_Data()
    {
        return $this->Return_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReturn_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturn_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturn_Line_DataForArrayConstraintsFromSetReturn_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_to_Supplier_DataTypeReturn_Line_DataItem) {
            // validation for constraint: itemType
            if (!$return_to_Supplier_DataTypeReturn_Line_DataItem instanceof \StructType\Return_to_Supplier_Line_DataType) {
                $invalidValues[] = is_object($return_to_Supplier_DataTypeReturn_Line_DataItem) ? get_class($return_to_Supplier_DataTypeReturn_Line_DataItem) : sprintf('%s(%s)', gettype($return_to_Supplier_DataTypeReturn_Line_DataItem), var_export($return_to_Supplier_DataTypeReturn_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Return_Line_Data property can only contain items of type \StructType\Return_to_Supplier_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Return_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_Line_DataType[] $return_Line_Data
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setReturn_Line_Data(array $return_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($return_Line_DataArrayErrorMessage = self::validateReturn_Line_DataForArrayConstraintsFromSetReturn_Line_Data($return_Line_Data))) {
            throw new \InvalidArgumentException($return_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Return_Line_Data = $return_Line_Data;
        return $this;
    }
    /**
     * Add item to Return_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_Line_DataType $item
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function addToReturn_Line_Data(\StructType\Return_to_Supplier_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Return_to_Supplier_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Return_Line_Data property can only contain items of type \StructType\Return_to_Supplier_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Return_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_to_Supplier_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$return_to_Supplier_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($return_to_Supplier_DataTypeAttachment_DataItem) ? get_class($return_to_Supplier_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($return_to_Supplier_DataTypeAttachment_DataItem), var_export($return_to_Supplier_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Return_to_Supplier_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
