<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Invoice_Types_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; documents cannot be resubmitted. | Element containing the Invoice Type reference for update and all Invoice Type data items.
 * @subpackage Structs
 */
class Put_Invoice_Types_RequestType extends AbstractStructBase
{
    /**
     * The Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Invoice Type for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Invoice_Type_Reference;
    /**
     * The Invoice_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type Data
     * @var \StructType\Invoice_Type_DataType
     */
    public $Invoice_Type_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Invoice_Types_RequestType
     * @uses Put_Invoice_Types_RequestType::setInvoice_Type_Reference()
     * @uses Put_Invoice_Types_RequestType::setInvoice_Type_Data()
     * @uses Put_Invoice_Types_RequestType::setAdd_Only()
     * @uses Put_Invoice_Types_RequestType::setVersion()
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @param \StructType\Invoice_Type_DataType $invoice_Type_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Invoice_TypeObjectType $invoice_Type_Reference = null, \StructType\Invoice_Type_DataType $invoice_Type_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setInvoice_Type_Reference($invoice_Type_Reference)
            ->setInvoice_Type_Data($invoice_Type_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getInvoice_Type_Reference()
    {
        return $this->Invoice_Type_Reference;
    }
    /**
     * Set Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @return \StructType\Put_Invoice_Types_RequestType
     */
    public function setInvoice_Type_Reference(\StructType\Invoice_TypeObjectType $invoice_Type_Reference = null)
    {
        $this->Invoice_Type_Reference = $invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Invoice_Type_Data value
     * @return \StructType\Invoice_Type_DataType|null
     */
    public function getInvoice_Type_Data()
    {
        return $this->Invoice_Type_Data;
    }
    /**
     * Set Invoice_Type_Data value
     * @param \StructType\Invoice_Type_DataType $invoice_Type_Data
     * @return \StructType\Put_Invoice_Types_RequestType
     */
    public function setInvoice_Type_Data(\StructType\Invoice_Type_DataType $invoice_Type_Data = null)
    {
        $this->Invoice_Type_Data = $invoice_Type_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Invoice_Types_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Invoice_Types_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
