<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Template_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains each project template based on the Request References or Request Criteria.
 * @subpackage Structs
 */
class Project_Template_Response_DataType extends AbstractStructBase
{
    /**
     * The Project_Template
     * Meta information extracted from the WSDL
     * - documentation: Contains all project template references and data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_TemplateType[]
     */
    public $Project_Template;
    /**
     * Constructor method for Project_Template_Response_DataType
     * @uses Project_Template_Response_DataType::setProject_Template()
     * @param \StructType\Project_TemplateType[] $project_Template
     */
    public function __construct(array $project_Template = array())
    {
        $this
            ->setProject_Template($project_Template);
    }
    /**
     * Get Project_Template value
     * @return \StructType\Project_TemplateType[]|null
     */
    public function getProject_Template()
    {
        return $this->Project_Template;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Template method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Template method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_TemplateForArrayConstraintsFromSetProject_Template(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Template_Response_DataTypeProject_TemplateItem) {
            // validation for constraint: itemType
            if (!$project_Template_Response_DataTypeProject_TemplateItem instanceof \StructType\Project_TemplateType) {
                $invalidValues[] = is_object($project_Template_Response_DataTypeProject_TemplateItem) ? get_class($project_Template_Response_DataTypeProject_TemplateItem) : sprintf('%s(%s)', gettype($project_Template_Response_DataTypeProject_TemplateItem), var_export($project_Template_Response_DataTypeProject_TemplateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Template property can only contain items of type \StructType\Project_TemplateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_TemplateType[] $project_Template
     * @return \StructType\Project_Template_Response_DataType
     */
    public function setProject_Template(array $project_Template = array())
    {
        // validation for constraint: array
        if ('' !== ($project_TemplateArrayErrorMessage = self::validateProject_TemplateForArrayConstraintsFromSetProject_Template($project_Template))) {
            throw new \InvalidArgumentException($project_TemplateArrayErrorMessage, __LINE__);
        }
        $this->Project_Template = $project_Template;
        return $this;
    }
    /**
     * Add item to Project_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_TemplateType $item
     * @return \StructType\Project_Template_Response_DataType
     */
    public function addToProject_Template(\StructType\Project_TemplateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_TemplateType) {
            throw new \InvalidArgumentException(sprintf('The Project_Template property can only contain items of type \StructType\Project_TemplateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Template[] = $item;
        return $this;
    }
}
