<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order_From_Supplier_Connection_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contains all Order-From Supplier Connections for the supplier
 * @subpackage Structs
 */
class Order_From_Supplier_Connection_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_ID;
    /**
     * The Supplier_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_ID;
    /**
     * The Supplier_Connection_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_Connection_Line_DataType[]
     */
    public $Supplier_Connection_Line_Data;
    /**
     * Constructor method for Order_From_Supplier_Connection_DataType
     * @uses Order_From_Supplier_Connection_DataType::setSupplier_Reference_ID()
     * @uses Order_From_Supplier_Connection_DataType::setSupplier_ID()
     * @uses Order_From_Supplier_Connection_DataType::setSupplier_Connection_Line_Data()
     * @param string $supplier_Reference_ID
     * @param string $supplier_ID
     * @param \StructType\Order_From_Supplier_Connection_Line_DataType[] $supplier_Connection_Line_Data
     */
    public function __construct($supplier_Reference_ID = null, $supplier_ID = null, array $supplier_Connection_Line_Data = array())
    {
        $this
            ->setSupplier_Reference_ID($supplier_Reference_ID)
            ->setSupplier_ID($supplier_ID)
            ->setSupplier_Connection_Line_Data($supplier_Connection_Line_Data);
    }
    /**
     * Get Supplier_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Reference_ID()
    {
        return $this->Supplier_Reference_ID;
    }
    /**
     * Set Supplier_Reference_ID value
     * @param string $supplier_Reference_ID
     * @return \StructType\Order_From_Supplier_Connection_DataType
     */
    public function setSupplier_Reference_ID($supplier_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_ID) && !is_string($supplier_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_ID, true), gettype($supplier_Reference_ID)), __LINE__);
        }
        $this->Supplier_Reference_ID = $supplier_Reference_ID;
        return $this;
    }
    /**
     * Get Supplier_ID value
     * @return string|null
     */
    public function getSupplier_ID()
    {
        return $this->Supplier_ID;
    }
    /**
     * Set Supplier_ID value
     * @param string $supplier_ID
     * @return \StructType\Order_From_Supplier_Connection_DataType
     */
    public function setSupplier_ID($supplier_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_ID) && !is_string($supplier_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_ID, true), gettype($supplier_ID)), __LINE__);
        }
        $this->Supplier_ID = $supplier_ID;
        return $this;
    }
    /**
     * Get Supplier_Connection_Line_Data value
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType[]|null
     */
    public function getSupplier_Connection_Line_Data()
    {
        return $this->Supplier_Connection_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Connection_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Connection_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Connection_Line_DataForArrayConstraintsFromSetSupplier_Connection_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $order_From_Supplier_Connection_DataTypeSupplier_Connection_Line_DataItem) {
            // validation for constraint: itemType
            if (!$order_From_Supplier_Connection_DataTypeSupplier_Connection_Line_DataItem instanceof \StructType\Order_From_Supplier_Connection_Line_DataType) {
                $invalidValues[] = is_object($order_From_Supplier_Connection_DataTypeSupplier_Connection_Line_DataItem) ? get_class($order_From_Supplier_Connection_DataTypeSupplier_Connection_Line_DataItem) : sprintf('%s(%s)', gettype($order_From_Supplier_Connection_DataTypeSupplier_Connection_Line_DataItem), var_export($order_From_Supplier_Connection_DataTypeSupplier_Connection_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Connection_Line_Data property can only contain items of type \StructType\Order_From_Supplier_Connection_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Connection_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Supplier_Connection_Line_DataType[] $supplier_Connection_Line_Data
     * @return \StructType\Order_From_Supplier_Connection_DataType
     */
    public function setSupplier_Connection_Line_Data(array $supplier_Connection_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Connection_Line_DataArrayErrorMessage = self::validateSupplier_Connection_Line_DataForArrayConstraintsFromSetSupplier_Connection_Line_Data($supplier_Connection_Line_Data))) {
            throw new \InvalidArgumentException($supplier_Connection_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Connection_Line_Data = $supplier_Connection_Line_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Connection_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Supplier_Connection_Line_DataType $item
     * @return \StructType\Order_From_Supplier_Connection_DataType
     */
    public function addToSupplier_Connection_Line_Data(\StructType\Order_From_Supplier_Connection_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order_From_Supplier_Connection_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Connection_Line_Data property can only contain items of type \StructType\Order_From_Supplier_Connection_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Connection_Line_Data[] = $item;
        return $this;
    }
}
