<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lease_Supplier_Contract_Details_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Lease Supplier Contract Details.
 * @subpackage Structs
 */
class Lease_Supplier_Contract_Details_DataType extends AbstractStructBase
{
    /**
     * The Lease_Term
     * Meta information extracted from the WSDL
     * - documentation: Lease Term. This field is to be returned for Get Supplier Contracts and not entered for Submit Supplier Contract. Value will not be persisted if entered.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 15
     * @var float
     */
    public $Lease_Term;
    /**
     * The Compound_Period_Reference
     * Meta information extracted from the WSDL
     * - documentation: Compound Period
     * - minOccurs: 0
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Compound_Period_Reference;
    /**
     * The Payment_Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Frequency Reference
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Payment_Frequency_Reference;
    /**
     * The First_Payment_Installment_Date
     * Meta information extracted from the WSDL
     * - documentation: First Payment Installment Date. Input the first payment installment date, including rent free installment periods, which are not prepaid lease payments made prior to the contract start date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $First_Payment_Installment_Date;
    /**
     * The Additional_Payment
     * Meta information extracted from the WSDL
     * - documentation: When you select the Additional Payment checkbox, we include additional installment to the payment information grid
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Additional_Payment;
    /**
     * The Interest_Rate
     * Meta information extracted from the WSDL
     * - documentation: Alternate Contract Interest Rate for Lease Contract Amendment | Interest Rate (%)
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Interest_Rate;
    /**
     * The Fixed_Payment_Amount
     * Meta information extracted from the WSDL
     * - documentation: Fixed Payment Amount to apply to each installment of the Lease Contract. | Fixed Payment Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Fixed_Payment_Amount;
    /**
     * The Lessor_Incentive
     * Meta information extracted from the WSDL
     * - documentation: Initial Incentive for the Lessor under this contract, if any.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Lessor_Incentive;
    /**
     * The Initial_Direct_Cost
     * Meta information extracted from the WSDL
     * - documentation: Initial Direct Cost for the Lessor under this contract, if any.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Initial_Direct_Cost;
    /**
     * The Accounting_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Accounting Method for the Lease Contract. Controls which information is required for the contract and the eventual accounting generated by downstream transactions.Straight Line Expense: ACCOUNTING_METHOD_SL_EXPROU Asset Operating
     * Expense: ACCOUNTING_METHOD_ROU_OPEXROU Asset Depreciation Expense: ACCOUNTING_METHOD_ROU_DEPEX
     * - minOccurs: 0
     * @var \StructType\Lease_Accounting_MethodObjectType
     */
    public $Accounting_Method_Reference;
    /**
     * The Automatically_Generate_Supplier_Invoice_Schedule_And_Installments
     * Meta information extracted from the WSDL
     * - documentation: Automatically Generate Supplier Invoice Schedule And Installments
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Automatically_Generate_Supplier_Invoice_Schedule_And_Installments;
    /**
     * The Automatically_Generate_Expense_Recognition_Schedule_And_Installments
     * Meta information extracted from the WSDL
     * - documentation: Automatically Generate Expense Recognition Schedule And Installments
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Automatically_Generate_Expense_Recognition_Schedule_And_Installments;
    /**
     * The Expense_Recognition_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Recognition Method for the lease contracts. Determines the method through which Expense Recognition schedule will be generated
     * - minOccurs: 0
     * @var \StructType\Schedule_Distribution_MethodObjectType
     */
    public $Expense_Recognition_Method_Reference;
    /**
     * The Prepaid_Lease_Payment
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Lease Contract has been prepaid and whether the prepaid amount should be included as part of the ROU Asset value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid_Lease_Payment;
    /**
     * The Prepaid_Lease_Payment_Date
     * Meta information extracted from the WSDL
     * - documentation: The prepaid lease payment date is required for prepaid leases with fixed payment type. The prepaid date must be before the lease contract start date and no earlier than 1 year before the lease contract start date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prepaid_Lease_Payment_Date;
    /**
     * The Number_of_Payments
     * Meta information extracted from the WSDL
     * - documentation: Number of Payments. This field is to be returned for Get Supplier Contracts and not entered for Submit Supplier Contract. Value will not be persisted if entered.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Payments;
    /**
     * The Total_Interest
     * Meta information extracted from the WSDL
     * - documentation: Total Interest. This field is to be returned for Get Supplier Contracts and not entered for Submit Supplier Contract. Value will not be persisted if entered.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Interest;
    /**
     * The Lease_Liability___Read_Only
     * Meta information extracted from the WSDL
     * - documentation: Workday automatically calculates the Lease Liability value based on the information provided and entered data in this field will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Lease_Liability___Read_Only;
    /**
     * The ROU_Asset___Read_Only
     * Meta information extracted from the WSDL
     * - documentation: Workday automatically calculates the ROU Asset Value based on the information provided and entered data in this field will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $ROU_Asset___Read_Only;
    /**
     * The Total_Lease_Payments___Read_Only
     * Meta information extracted from the WSDL
     * - documentation: Workday automatically calculates the value of Total Lease Payments based on information you provide and entered data in this field will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Lease_Payments___Read_Only;
    /**
     * Constructor method for Lease_Supplier_Contract_Details_DataType
     * @uses Lease_Supplier_Contract_Details_DataType::setLease_Term()
     * @uses Lease_Supplier_Contract_Details_DataType::setCompound_Period_Reference()
     * @uses Lease_Supplier_Contract_Details_DataType::setPayment_Frequency_Reference()
     * @uses Lease_Supplier_Contract_Details_DataType::setFirst_Payment_Installment_Date()
     * @uses Lease_Supplier_Contract_Details_DataType::setAdditional_Payment()
     * @uses Lease_Supplier_Contract_Details_DataType::setInterest_Rate()
     * @uses Lease_Supplier_Contract_Details_DataType::setFixed_Payment_Amount()
     * @uses Lease_Supplier_Contract_Details_DataType::setLessor_Incentive()
     * @uses Lease_Supplier_Contract_Details_DataType::setInitial_Direct_Cost()
     * @uses Lease_Supplier_Contract_Details_DataType::setAccounting_Method_Reference()
     * @uses Lease_Supplier_Contract_Details_DataType::setAutomatically_Generate_Supplier_Invoice_Schedule_And_Installments()
     * @uses Lease_Supplier_Contract_Details_DataType::setAutomatically_Generate_Expense_Recognition_Schedule_And_Installments()
     * @uses Lease_Supplier_Contract_Details_DataType::setExpense_Recognition_Method_Reference()
     * @uses Lease_Supplier_Contract_Details_DataType::setPrepaid_Lease_Payment()
     * @uses Lease_Supplier_Contract_Details_DataType::setPrepaid_Lease_Payment_Date()
     * @uses Lease_Supplier_Contract_Details_DataType::setNumber_of_Payments()
     * @uses Lease_Supplier_Contract_Details_DataType::setTotal_Interest()
     * @uses Lease_Supplier_Contract_Details_DataType::setLease_Liability___Read_Only()
     * @uses Lease_Supplier_Contract_Details_DataType::setROU_Asset___Read_Only()
     * @uses Lease_Supplier_Contract_Details_DataType::setTotal_Lease_Payments___Read_Only()
     * @param float $lease_Term
     * @param \StructType\Frequency_BehaviorObjectType $compound_Period_Reference
     * @param \StructType\Frequency_BehaviorObjectType $payment_Frequency_Reference
     * @param string $first_Payment_Installment_Date
     * @param bool $additional_Payment
     * @param float $interest_Rate
     * @param float $fixed_Payment_Amount
     * @param float $lessor_Incentive
     * @param float $initial_Direct_Cost
     * @param \StructType\Lease_Accounting_MethodObjectType $accounting_Method_Reference
     * @param bool $automatically_Generate_Supplier_Invoice_Schedule_And_Installments
     * @param bool $automatically_Generate_Expense_Recognition_Schedule_And_Installments
     * @param \StructType\Schedule_Distribution_MethodObjectType $expense_Recognition_Method_Reference
     * @param bool $prepaid_Lease_Payment
     * @param string $prepaid_Lease_Payment_Date
     * @param float $number_of_Payments
     * @param float $total_Interest
     * @param float $lease_Liability___Read_Only
     * @param float $rOU_Asset___Read_Only
     * @param float $total_Lease_Payments___Read_Only
     */
    public function __construct($lease_Term = null, \StructType\Frequency_BehaviorObjectType $compound_Period_Reference = null, \StructType\Frequency_BehaviorObjectType $payment_Frequency_Reference = null, $first_Payment_Installment_Date = null, $additional_Payment = null, $interest_Rate = null, $fixed_Payment_Amount = null, $lessor_Incentive = null, $initial_Direct_Cost = null, \StructType\Lease_Accounting_MethodObjectType $accounting_Method_Reference = null, $automatically_Generate_Supplier_Invoice_Schedule_And_Installments = null, $automatically_Generate_Expense_Recognition_Schedule_And_Installments = null, \StructType\Schedule_Distribution_MethodObjectType $expense_Recognition_Method_Reference = null, $prepaid_Lease_Payment = null, $prepaid_Lease_Payment_Date = null, $number_of_Payments = null, $total_Interest = null, $lease_Liability___Read_Only = null, $rOU_Asset___Read_Only = null, $total_Lease_Payments___Read_Only = null)
    {
        $this
            ->setLease_Term($lease_Term)
            ->setCompound_Period_Reference($compound_Period_Reference)
            ->setPayment_Frequency_Reference($payment_Frequency_Reference)
            ->setFirst_Payment_Installment_Date($first_Payment_Installment_Date)
            ->setAdditional_Payment($additional_Payment)
            ->setInterest_Rate($interest_Rate)
            ->setFixed_Payment_Amount($fixed_Payment_Amount)
            ->setLessor_Incentive($lessor_Incentive)
            ->setInitial_Direct_Cost($initial_Direct_Cost)
            ->setAccounting_Method_Reference($accounting_Method_Reference)
            ->setAutomatically_Generate_Supplier_Invoice_Schedule_And_Installments($automatically_Generate_Supplier_Invoice_Schedule_And_Installments)
            ->setAutomatically_Generate_Expense_Recognition_Schedule_And_Installments($automatically_Generate_Expense_Recognition_Schedule_And_Installments)
            ->setExpense_Recognition_Method_Reference($expense_Recognition_Method_Reference)
            ->setPrepaid_Lease_Payment($prepaid_Lease_Payment)
            ->setPrepaid_Lease_Payment_Date($prepaid_Lease_Payment_Date)
            ->setNumber_of_Payments($number_of_Payments)
            ->setTotal_Interest($total_Interest)
            ->setLease_Liability___Read_Only($lease_Liability___Read_Only)
            ->setROU_Asset___Read_Only($rOU_Asset___Read_Only)
            ->setTotal_Lease_Payments___Read_Only($total_Lease_Payments___Read_Only);
    }
    /**
     * Get Lease_Term value
     * @return float|null
     */
    public function getLease_Term()
    {
        return $this->Lease_Term;
    }
    /**
     * Set Lease_Term value
     * @param float $lease_Term
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setLease_Term($lease_Term = null)
    {
        // validation for constraint: float
        if (!is_null($lease_Term) && !(is_float($lease_Term) || is_numeric($lease_Term))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lease_Term, true), gettype($lease_Term)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($lease_Term) && mb_strlen(mb_substr($lease_Term, false !== mb_strpos($lease_Term, '.') ? mb_strpos($lease_Term, '.') + 1 : mb_strlen($lease_Term))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($lease_Term, true), mb_strlen(mb_substr($lease_Term, mb_strpos($lease_Term, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($lease_Term) && mb_strlen(preg_replace('/(\D)/', '', $lease_Term)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($lease_Term, true), mb_strlen(preg_replace('/(\D)/', '', $lease_Term))), __LINE__);
        }
        $this->Lease_Term = $lease_Term;
        return $this;
    }
    /**
     * Get Compound_Period_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getCompound_Period_Reference()
    {
        return $this->Compound_Period_Reference;
    }
    /**
     * Set Compound_Period_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $compound_Period_Reference
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setCompound_Period_Reference(\StructType\Frequency_BehaviorObjectType $compound_Period_Reference = null)
    {
        $this->Compound_Period_Reference = $compound_Period_Reference;
        return $this;
    }
    /**
     * Get Payment_Frequency_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getPayment_Frequency_Reference()
    {
        return $this->Payment_Frequency_Reference;
    }
    /**
     * Set Payment_Frequency_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $payment_Frequency_Reference
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setPayment_Frequency_Reference(\StructType\Frequency_BehaviorObjectType $payment_Frequency_Reference = null)
    {
        $this->Payment_Frequency_Reference = $payment_Frequency_Reference;
        return $this;
    }
    /**
     * Get First_Payment_Installment_Date value
     * @return string|null
     */
    public function getFirst_Payment_Installment_Date()
    {
        return $this->First_Payment_Installment_Date;
    }
    /**
     * Set First_Payment_Installment_Date value
     * @param string $first_Payment_Installment_Date
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setFirst_Payment_Installment_Date($first_Payment_Installment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($first_Payment_Installment_Date) && !is_string($first_Payment_Installment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first_Payment_Installment_Date, true), gettype($first_Payment_Installment_Date)), __LINE__);
        }
        $this->First_Payment_Installment_Date = $first_Payment_Installment_Date;
        return $this;
    }
    /**
     * Get Additional_Payment value
     * @return bool|null
     */
    public function getAdditional_Payment()
    {
        return $this->Additional_Payment;
    }
    /**
     * Set Additional_Payment value
     * @param bool $additional_Payment
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setAdditional_Payment($additional_Payment = null)
    {
        // validation for constraint: boolean
        if (!is_null($additional_Payment) && !is_bool($additional_Payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($additional_Payment, true), gettype($additional_Payment)), __LINE__);
        }
        $this->Additional_Payment = $additional_Payment;
        return $this;
    }
    /**
     * Get Interest_Rate value
     * @return float|null
     */
    public function getInterest_Rate()
    {
        return $this->Interest_Rate;
    }
    /**
     * Set Interest_Rate value
     * @param float $interest_Rate
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setInterest_Rate($interest_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($interest_Rate) && !(is_float($interest_Rate) || is_numeric($interest_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($interest_Rate, true), gettype($interest_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($interest_Rate) && mb_strlen(mb_substr($interest_Rate, false !== mb_strpos($interest_Rate, '.') ? mb_strpos($interest_Rate, '.') + 1 : mb_strlen($interest_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($interest_Rate, true), mb_strlen(mb_substr($interest_Rate, mb_strpos($interest_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($interest_Rate) && $interest_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($interest_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($interest_Rate) && mb_strlen(preg_replace('/(\D)/', '', $interest_Rate)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($interest_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $interest_Rate))), __LINE__);
        }
        $this->Interest_Rate = $interest_Rate;
        return $this;
    }
    /**
     * Get Fixed_Payment_Amount value
     * @return float|null
     */
    public function getFixed_Payment_Amount()
    {
        return $this->Fixed_Payment_Amount;
    }
    /**
     * Set Fixed_Payment_Amount value
     * @param float $fixed_Payment_Amount
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setFixed_Payment_Amount($fixed_Payment_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($fixed_Payment_Amount) && !(is_float($fixed_Payment_Amount) || is_numeric($fixed_Payment_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixed_Payment_Amount, true), gettype($fixed_Payment_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($fixed_Payment_Amount) && mb_strlen(mb_substr($fixed_Payment_Amount, false !== mb_strpos($fixed_Payment_Amount, '.') ? mb_strpos($fixed_Payment_Amount, '.') + 1 : mb_strlen($fixed_Payment_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($fixed_Payment_Amount, true), mb_strlen(mb_substr($fixed_Payment_Amount, mb_strpos($fixed_Payment_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($fixed_Payment_Amount) && mb_strlen(preg_replace('/(\D)/', '', $fixed_Payment_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($fixed_Payment_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $fixed_Payment_Amount))), __LINE__);
        }
        $this->Fixed_Payment_Amount = $fixed_Payment_Amount;
        return $this;
    }
    /**
     * Get Lessor_Incentive value
     * @return float|null
     */
    public function getLessor_Incentive()
    {
        return $this->Lessor_Incentive;
    }
    /**
     * Set Lessor_Incentive value
     * @param float $lessor_Incentive
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setLessor_Incentive($lessor_Incentive = null)
    {
        // validation for constraint: float
        if (!is_null($lessor_Incentive) && !(is_float($lessor_Incentive) || is_numeric($lessor_Incentive))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lessor_Incentive, true), gettype($lessor_Incentive)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($lessor_Incentive) && mb_strlen(mb_substr($lessor_Incentive, false !== mb_strpos($lessor_Incentive, '.') ? mb_strpos($lessor_Incentive, '.') + 1 : mb_strlen($lessor_Incentive))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($lessor_Incentive, true), mb_strlen(mb_substr($lessor_Incentive, mb_strpos($lessor_Incentive, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($lessor_Incentive) && mb_strlen(preg_replace('/(\D)/', '', $lessor_Incentive)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($lessor_Incentive, true), mb_strlen(preg_replace('/(\D)/', '', $lessor_Incentive))), __LINE__);
        }
        $this->Lessor_Incentive = $lessor_Incentive;
        return $this;
    }
    /**
     * Get Initial_Direct_Cost value
     * @return float|null
     */
    public function getInitial_Direct_Cost()
    {
        return $this->Initial_Direct_Cost;
    }
    /**
     * Set Initial_Direct_Cost value
     * @param float $initial_Direct_Cost
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setInitial_Direct_Cost($initial_Direct_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($initial_Direct_Cost) && !(is_float($initial_Direct_Cost) || is_numeric($initial_Direct_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($initial_Direct_Cost, true), gettype($initial_Direct_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($initial_Direct_Cost) && mb_strlen(mb_substr($initial_Direct_Cost, false !== mb_strpos($initial_Direct_Cost, '.') ? mb_strpos($initial_Direct_Cost, '.') + 1 : mb_strlen($initial_Direct_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($initial_Direct_Cost, true), mb_strlen(mb_substr($initial_Direct_Cost, mb_strpos($initial_Direct_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($initial_Direct_Cost) && mb_strlen(preg_replace('/(\D)/', '', $initial_Direct_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($initial_Direct_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $initial_Direct_Cost))), __LINE__);
        }
        $this->Initial_Direct_Cost = $initial_Direct_Cost;
        return $this;
    }
    /**
     * Get Accounting_Method_Reference value
     * @return \StructType\Lease_Accounting_MethodObjectType|null
     */
    public function getAccounting_Method_Reference()
    {
        return $this->Accounting_Method_Reference;
    }
    /**
     * Set Accounting_Method_Reference value
     * @param \StructType\Lease_Accounting_MethodObjectType $accounting_Method_Reference
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setAccounting_Method_Reference(\StructType\Lease_Accounting_MethodObjectType $accounting_Method_Reference = null)
    {
        $this->Accounting_Method_Reference = $accounting_Method_Reference;
        return $this;
    }
    /**
     * Get Automatically_Generate_Supplier_Invoice_Schedule_And_Installments value
     * @return bool|null
     */
    public function getAutomatically_Generate_Supplier_Invoice_Schedule_And_Installments()
    {
        return $this->Automatically_Generate_Supplier_Invoice_Schedule_And_Installments;
    }
    /**
     * Set Automatically_Generate_Supplier_Invoice_Schedule_And_Installments value
     * @param bool $automatically_Generate_Supplier_Invoice_Schedule_And_Installments
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setAutomatically_Generate_Supplier_Invoice_Schedule_And_Installments($automatically_Generate_Supplier_Invoice_Schedule_And_Installments = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatically_Generate_Supplier_Invoice_Schedule_And_Installments) && !is_bool($automatically_Generate_Supplier_Invoice_Schedule_And_Installments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatically_Generate_Supplier_Invoice_Schedule_And_Installments, true), gettype($automatically_Generate_Supplier_Invoice_Schedule_And_Installments)), __LINE__);
        }
        $this->Automatically_Generate_Supplier_Invoice_Schedule_And_Installments = $automatically_Generate_Supplier_Invoice_Schedule_And_Installments;
        return $this;
    }
    /**
     * Get Automatically_Generate_Expense_Recognition_Schedule_And_Installments value
     * @return bool|null
     */
    public function getAutomatically_Generate_Expense_Recognition_Schedule_And_Installments()
    {
        return $this->Automatically_Generate_Expense_Recognition_Schedule_And_Installments;
    }
    /**
     * Set Automatically_Generate_Expense_Recognition_Schedule_And_Installments value
     * @param bool $automatically_Generate_Expense_Recognition_Schedule_And_Installments
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setAutomatically_Generate_Expense_Recognition_Schedule_And_Installments($automatically_Generate_Expense_Recognition_Schedule_And_Installments = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatically_Generate_Expense_Recognition_Schedule_And_Installments) && !is_bool($automatically_Generate_Expense_Recognition_Schedule_And_Installments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatically_Generate_Expense_Recognition_Schedule_And_Installments, true), gettype($automatically_Generate_Expense_Recognition_Schedule_And_Installments)), __LINE__);
        }
        $this->Automatically_Generate_Expense_Recognition_Schedule_And_Installments = $automatically_Generate_Expense_Recognition_Schedule_And_Installments;
        return $this;
    }
    /**
     * Get Expense_Recognition_Method_Reference value
     * @return \StructType\Schedule_Distribution_MethodObjectType|null
     */
    public function getExpense_Recognition_Method_Reference()
    {
        return $this->Expense_Recognition_Method_Reference;
    }
    /**
     * Set Expense_Recognition_Method_Reference value
     * @param \StructType\Schedule_Distribution_MethodObjectType $expense_Recognition_Method_Reference
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setExpense_Recognition_Method_Reference(\StructType\Schedule_Distribution_MethodObjectType $expense_Recognition_Method_Reference = null)
    {
        $this->Expense_Recognition_Method_Reference = $expense_Recognition_Method_Reference;
        return $this;
    }
    /**
     * Get Prepaid_Lease_Payment value
     * @return bool|null
     */
    public function getPrepaid_Lease_Payment()
    {
        return $this->Prepaid_Lease_Payment;
    }
    /**
     * Set Prepaid_Lease_Payment value
     * @param bool $prepaid_Lease_Payment
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setPrepaid_Lease_Payment($prepaid_Lease_Payment = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid_Lease_Payment) && !is_bool($prepaid_Lease_Payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid_Lease_Payment, true), gettype($prepaid_Lease_Payment)), __LINE__);
        }
        $this->Prepaid_Lease_Payment = $prepaid_Lease_Payment;
        return $this;
    }
    /**
     * Get Prepaid_Lease_Payment_Date value
     * @return string|null
     */
    public function getPrepaid_Lease_Payment_Date()
    {
        return $this->Prepaid_Lease_Payment_Date;
    }
    /**
     * Set Prepaid_Lease_Payment_Date value
     * @param string $prepaid_Lease_Payment_Date
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setPrepaid_Lease_Payment_Date($prepaid_Lease_Payment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($prepaid_Lease_Payment_Date) && !is_string($prepaid_Lease_Payment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaid_Lease_Payment_Date, true), gettype($prepaid_Lease_Payment_Date)), __LINE__);
        }
        $this->Prepaid_Lease_Payment_Date = $prepaid_Lease_Payment_Date;
        return $this;
    }
    /**
     * Get Number_of_Payments value
     * @return float|null
     */
    public function getNumber_of_Payments()
    {
        return $this->Number_of_Payments;
    }
    /**
     * Set Number_of_Payments value
     * @param float $number_of_Payments
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setNumber_of_Payments($number_of_Payments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Payments) && !(is_float($number_of_Payments) || is_numeric($number_of_Payments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Payments, true), gettype($number_of_Payments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Payments) && mb_strlen(mb_substr($number_of_Payments, false !== mb_strpos($number_of_Payments, '.') ? mb_strpos($number_of_Payments, '.') + 1 : mb_strlen($number_of_Payments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Payments, true), mb_strlen(mb_substr($number_of_Payments, mb_strpos($number_of_Payments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Payments) && $number_of_Payments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Payments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Payments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Payments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Payments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Payments))), __LINE__);
        }
        $this->Number_of_Payments = $number_of_Payments;
        return $this;
    }
    /**
     * Get Total_Interest value
     * @return float|null
     */
    public function getTotal_Interest()
    {
        return $this->Total_Interest;
    }
    /**
     * Set Total_Interest value
     * @param float $total_Interest
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setTotal_Interest($total_Interest = null)
    {
        // validation for constraint: float
        if (!is_null($total_Interest) && !(is_float($total_Interest) || is_numeric($total_Interest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Interest, true), gettype($total_Interest)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Interest) && mb_strlen(mb_substr($total_Interest, false !== mb_strpos($total_Interest, '.') ? mb_strpos($total_Interest, '.') + 1 : mb_strlen($total_Interest))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Interest, true), mb_strlen(mb_substr($total_Interest, mb_strpos($total_Interest, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($total_Interest) && $total_Interest < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($total_Interest, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Interest) && mb_strlen(preg_replace('/(\D)/', '', $total_Interest)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Interest, true), mb_strlen(preg_replace('/(\D)/', '', $total_Interest))), __LINE__);
        }
        $this->Total_Interest = $total_Interest;
        return $this;
    }
    /**
     * Get Lease_Liability___Read_Only value
     * @return float|null
     */
    public function getLease_Liability___Read_Only()
    {
        return $this->{'Lease_Liability_-_Read_Only'};
    }
    /**
     * Set Lease_Liability___Read_Only value
     * @param float $lease_Liability___Read_Only
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setLease_Liability___Read_Only($lease_Liability___Read_Only = null)
    {
        // validation for constraint: float
        if (!is_null($lease_Liability___Read_Only) && !(is_float($lease_Liability___Read_Only) || is_numeric($lease_Liability___Read_Only))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lease_Liability___Read_Only, true), gettype($lease_Liability___Read_Only)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($lease_Liability___Read_Only) && mb_strlen(mb_substr($lease_Liability___Read_Only, false !== mb_strpos($lease_Liability___Read_Only, '.') ? mb_strpos($lease_Liability___Read_Only, '.') + 1 : mb_strlen($lease_Liability___Read_Only))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($lease_Liability___Read_Only, true), mb_strlen(mb_substr($lease_Liability___Read_Only, mb_strpos($lease_Liability___Read_Only, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($lease_Liability___Read_Only) && mb_strlen(preg_replace('/(\D)/', '', $lease_Liability___Read_Only)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($lease_Liability___Read_Only, true), mb_strlen(preg_replace('/(\D)/', '', $lease_Liability___Read_Only))), __LINE__);
        }
        $this->Lease_Liability___Read_Only = $this->{'Lease_Liability_-_Read_Only'} = $lease_Liability___Read_Only;
        return $this;
    }
    /**
     * Get ROU_Asset___Read_Only value
     * @return float|null
     */
    public function getROU_Asset___Read_Only()
    {
        return $this->{'ROU_Asset_-_Read_Only'};
    }
    /**
     * Set ROU_Asset___Read_Only value
     * @param float $rOU_Asset___Read_Only
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setROU_Asset___Read_Only($rOU_Asset___Read_Only = null)
    {
        // validation for constraint: float
        if (!is_null($rOU_Asset___Read_Only) && !(is_float($rOU_Asset___Read_Only) || is_numeric($rOU_Asset___Read_Only))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rOU_Asset___Read_Only, true), gettype($rOU_Asset___Read_Only)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($rOU_Asset___Read_Only) && mb_strlen(mb_substr($rOU_Asset___Read_Only, false !== mb_strpos($rOU_Asset___Read_Only, '.') ? mb_strpos($rOU_Asset___Read_Only, '.') + 1 : mb_strlen($rOU_Asset___Read_Only))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($rOU_Asset___Read_Only, true), mb_strlen(mb_substr($rOU_Asset___Read_Only, mb_strpos($rOU_Asset___Read_Only, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($rOU_Asset___Read_Only) && mb_strlen(preg_replace('/(\D)/', '', $rOU_Asset___Read_Only)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($rOU_Asset___Read_Only, true), mb_strlen(preg_replace('/(\D)/', '', $rOU_Asset___Read_Only))), __LINE__);
        }
        $this->ROU_Asset___Read_Only = $this->{'ROU_Asset_-_Read_Only'} = $rOU_Asset___Read_Only;
        return $this;
    }
    /**
     * Get Total_Lease_Payments___Read_Only value
     * @return float|null
     */
    public function getTotal_Lease_Payments___Read_Only()
    {
        return $this->{'Total_Lease_Payments_-_Read_Only'};
    }
    /**
     * Set Total_Lease_Payments___Read_Only value
     * @param float $total_Lease_Payments___Read_Only
     * @return \StructType\Lease_Supplier_Contract_Details_DataType
     */
    public function setTotal_Lease_Payments___Read_Only($total_Lease_Payments___Read_Only = null)
    {
        // validation for constraint: float
        if (!is_null($total_Lease_Payments___Read_Only) && !(is_float($total_Lease_Payments___Read_Only) || is_numeric($total_Lease_Payments___Read_Only))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Lease_Payments___Read_Only, true), gettype($total_Lease_Payments___Read_Only)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Lease_Payments___Read_Only) && mb_strlen(mb_substr($total_Lease_Payments___Read_Only, false !== mb_strpos($total_Lease_Payments___Read_Only, '.') ? mb_strpos($total_Lease_Payments___Read_Only, '.') + 1 : mb_strlen($total_Lease_Payments___Read_Only))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Lease_Payments___Read_Only, true), mb_strlen(mb_substr($total_Lease_Payments___Read_Only, mb_strpos($total_Lease_Payments___Read_Only, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Lease_Payments___Read_Only) && mb_strlen(preg_replace('/(\D)/', '', $total_Lease_Payments___Read_Only)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Lease_Payments___Read_Only, true), mb_strlen(preg_replace('/(\D)/', '', $total_Lease_Payments___Read_Only))), __LINE__);
        }
        $this->Total_Lease_Payments___Read_Only = $this->{'Total_Lease_Payments_-_Read_Only'} = $total_Lease_Payments___Read_Only;
        return $this;
    }
}
