<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Central_Travel_Card_Transaction_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Assignee details for Central Travel Card Transaction
 * @subpackage Structs
 */
class Expense_Central_Travel_Card_Transaction_DataType extends AbstractStructBase
{
    /**
     * The New_Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Payee to assign the Central Travel Card Transaction
     * @var \StructType\Expense_PayeeObjectType
     */
    public $New_Assignee_Reference;
    /**
     * The Reason_for_Assignment
     * Meta information extracted from the WSDL
     * - documentation: Reason for Assignment of Central Travel Card Transaction to Assignee
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason_for_Assignment;
    /**
     * Constructor method for Expense_Central_Travel_Card_Transaction_DataType
     * @uses Expense_Central_Travel_Card_Transaction_DataType::setNew_Assignee_Reference()
     * @uses Expense_Central_Travel_Card_Transaction_DataType::setReason_for_Assignment()
     * @param \StructType\Expense_PayeeObjectType $new_Assignee_Reference
     * @param string $reason_for_Assignment
     */
    public function __construct(\StructType\Expense_PayeeObjectType $new_Assignee_Reference = null, $reason_for_Assignment = null)
    {
        $this
            ->setNew_Assignee_Reference($new_Assignee_Reference)
            ->setReason_for_Assignment($reason_for_Assignment);
    }
    /**
     * Get New_Assignee_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getNew_Assignee_Reference()
    {
        return $this->New_Assignee_Reference;
    }
    /**
     * Set New_Assignee_Reference value
     * @param \StructType\Expense_PayeeObjectType $new_Assignee_Reference
     * @return \StructType\Expense_Central_Travel_Card_Transaction_DataType
     */
    public function setNew_Assignee_Reference(\StructType\Expense_PayeeObjectType $new_Assignee_Reference = null)
    {
        $this->New_Assignee_Reference = $new_Assignee_Reference;
        return $this;
    }
    /**
     * Get Reason_for_Assignment value
     * @return string|null
     */
    public function getReason_for_Assignment()
    {
        return $this->Reason_for_Assignment;
    }
    /**
     * Set Reason_for_Assignment value
     * @param string $reason_for_Assignment
     * @return \StructType\Expense_Central_Travel_Card_Transaction_DataType
     */
    public function setReason_for_Assignment($reason_for_Assignment = null)
    {
        // validation for constraint: string
        if (!is_null($reason_for_Assignment) && !is_string($reason_for_Assignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason_for_Assignment, true), gettype($reason_for_Assignment)), __LINE__);
        }
        $this->Reason_for_Assignment = $reason_for_Assignment;
        return $this;
    }
}
