<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Timesheet_Daily_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Timesheet Day details for a Timesheet for a Get_Timesheet operation.
 * @subpackage Structs
 */
class Timesheet_Daily_WWS_DataType extends AbstractStructBase
{
    /**
     * The Timesheet_Day_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of the time card line for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Timesheet_Day_Date;
    /**
     * The Time_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Time Code for the Time Card Line reference provided for Get_Timesheet operation's response.
     * - minOccurs: 0
     * @var \StructType\Time_Entry_CodeObjectType
     */
    public $Time_Code_Reference;
    /**
     * The Hours_Worked
     * Meta information extracted from the WSDL
     * - documentation: The amount of hours worked for the time card line specified for Get_Timesheet operation's response. | The total hours worked on this day.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Hours_Worked;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: If the time card line is set to billable for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: The comment field for the time card line for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags associated with time card line for Get_Timesheet operation's response. For Payroll Timesheet this is limited to Cost Center.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project associated with time card line for Get_Timesheet operation's response. Payroll timesheets will not have a value populated in this field.
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project task associated with time card line for Get_Timesheet operation's response. Payroll timesheets will not have a value populated in this field.
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TaskObjectType
     */
    public $Project_Task_Reference;
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Position selected when entering the Payroll Timesheet. Only applies if the Tenant Setup is configured for Multiple Jobs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PositionObjectType[]
     */
    public $Position_Reference;
    /**
     * The Percent_Complete_Proposed_for_Timesheet_Day
     * Meta information extracted from the WSDL
     * - documentation: Proposed Percent complete from the Timesheet Line in decimal format (0.5 for 50%, 1 for 100%)
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Complete_Proposed_for_Timesheet_Day;
    /**
     * The Time_In_Time_Out_Data
     * Meta information extracted from the WSDL
     * - documentation: Time In Time Out Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Time_In_Time_Out_WWS_DataType[]
     */
    public $Time_In_Time_Out_Data;
    /**
     * Constructor method for Timesheet_Daily_WWS_DataType
     * @uses Timesheet_Daily_WWS_DataType::setTimesheet_Day_Date()
     * @uses Timesheet_Daily_WWS_DataType::setTime_Code_Reference()
     * @uses Timesheet_Daily_WWS_DataType::setHours_Worked()
     * @uses Timesheet_Daily_WWS_DataType::setBillable()
     * @uses Timesheet_Daily_WWS_DataType::setMemo()
     * @uses Timesheet_Daily_WWS_DataType::setWorktags_Reference()
     * @uses Timesheet_Daily_WWS_DataType::setProject_Reference()
     * @uses Timesheet_Daily_WWS_DataType::setProject_Task_Reference()
     * @uses Timesheet_Daily_WWS_DataType::setPosition_Reference()
     * @uses Timesheet_Daily_WWS_DataType::setPercent_Complete_Proposed_for_Timesheet_Day()
     * @uses Timesheet_Daily_WWS_DataType::setTime_In_Time_Out_Data()
     * @param string $timesheet_Day_Date
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @param float $hours_Worked
     * @param bool $billable
     * @param string $memo
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Project_Plan_TaskObjectType $project_Task_Reference
     * @param \StructType\PositionObjectType[] $position_Reference
     * @param float $percent_Complete_Proposed_for_Timesheet_Day
     * @param \StructType\Time_In_Time_Out_WWS_DataType[] $time_In_Time_Out_Data
     */
    public function __construct($timesheet_Day_Date = null, \StructType\Time_Entry_CodeObjectType $time_Code_Reference = null, $hours_Worked = null, $billable = null, $memo = null, array $worktags_Reference = array(), \StructType\ProjectObjectType $project_Reference = null, \StructType\Project_Plan_TaskObjectType $project_Task_Reference = null, array $position_Reference = array(), $percent_Complete_Proposed_for_Timesheet_Day = null, array $time_In_Time_Out_Data = array())
    {
        $this
            ->setTimesheet_Day_Date($timesheet_Day_Date)
            ->setTime_Code_Reference($time_Code_Reference)
            ->setHours_Worked($hours_Worked)
            ->setBillable($billable)
            ->setMemo($memo)
            ->setWorktags_Reference($worktags_Reference)
            ->setProject_Reference($project_Reference)
            ->setProject_Task_Reference($project_Task_Reference)
            ->setPosition_Reference($position_Reference)
            ->setPercent_Complete_Proposed_for_Timesheet_Day($percent_Complete_Proposed_for_Timesheet_Day)
            ->setTime_In_Time_Out_Data($time_In_Time_Out_Data);
    }
    /**
     * Get Timesheet_Day_Date value
     * @return string|null
     */
    public function getTimesheet_Day_Date()
    {
        return $this->Timesheet_Day_Date;
    }
    /**
     * Set Timesheet_Day_Date value
     * @param string $timesheet_Day_Date
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setTimesheet_Day_Date($timesheet_Day_Date = null)
    {
        // validation for constraint: string
        if (!is_null($timesheet_Day_Date) && !is_string($timesheet_Day_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timesheet_Day_Date, true), gettype($timesheet_Day_Date)), __LINE__);
        }
        $this->Timesheet_Day_Date = $timesheet_Day_Date;
        return $this;
    }
    /**
     * Get Time_Code_Reference value
     * @return \StructType\Time_Entry_CodeObjectType|null
     */
    public function getTime_Code_Reference()
    {
        return $this->Time_Code_Reference;
    }
    /**
     * Set Time_Code_Reference value
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setTime_Code_Reference(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null)
    {
        $this->Time_Code_Reference = $time_Code_Reference;
        return $this;
    }
    /**
     * Get Hours_Worked value
     * @return float|null
     */
    public function getHours_Worked()
    {
        return $this->Hours_Worked;
    }
    /**
     * Set Hours_Worked value
     * @param float $hours_Worked
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setHours_Worked($hours_Worked = null)
    {
        // validation for constraint: float
        if (!is_null($hours_Worked) && !(is_float($hours_Worked) || is_numeric($hours_Worked))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hours_Worked, true), gettype($hours_Worked)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hours_Worked) && mb_strlen(mb_substr($hours_Worked, false !== mb_strpos($hours_Worked, '.') ? mb_strpos($hours_Worked, '.') + 1 : mb_strlen($hours_Worked))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hours_Worked, true), mb_strlen(mb_substr($hours_Worked, mb_strpos($hours_Worked, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($hours_Worked) && mb_strlen(preg_replace('/(\D)/', '', $hours_Worked)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($hours_Worked, true), mb_strlen(preg_replace('/(\D)/', '', $hours_Worked))), __LINE__);
        }
        $this->Hours_Worked = $hours_Worked;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timesheet_Daily_WWS_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$timesheet_Daily_WWS_DataTypeWorktags_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($timesheet_Daily_WWS_DataTypeWorktags_ReferenceItem) ? get_class($timesheet_Daily_WWS_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($timesheet_Daily_WWS_DataTypeWorktags_ReferenceItem), var_export($timesheet_Daily_WWS_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function addToWorktags_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Project_Task_Reference value
     * @return \StructType\Project_Plan_TaskObjectType|null
     */
    public function getProject_Task_Reference()
    {
        return $this->Project_Task_Reference;
    }
    /**
     * Set Project_Task_Reference value
     * @param \StructType\Project_Plan_TaskObjectType $project_Task_Reference
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setProject_Task_Reference(\StructType\Project_Plan_TaskObjectType $project_Task_Reference = null)
    {
        $this->Project_Task_Reference = $project_Task_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\PositionObjectType[]|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePosition_ReferenceForArrayConstraintsFromSetPosition_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timesheet_Daily_WWS_DataTypePosition_ReferenceItem) {
            // validation for constraint: itemType
            if (!$timesheet_Daily_WWS_DataTypePosition_ReferenceItem instanceof \StructType\PositionObjectType) {
                $invalidValues[] = is_object($timesheet_Daily_WWS_DataTypePosition_ReferenceItem) ? get_class($timesheet_Daily_WWS_DataTypePosition_ReferenceItem) : sprintf('%s(%s)', gettype($timesheet_Daily_WWS_DataTypePosition_ReferenceItem), var_export($timesheet_Daily_WWS_DataTypePosition_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position_Reference property can only contain items of type \StructType\PositionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\PositionObjectType[] $position_Reference
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setPosition_Reference(array $position_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($position_ReferenceArrayErrorMessage = self::validatePosition_ReferenceForArrayConstraintsFromSetPosition_Reference($position_Reference))) {
            throw new \InvalidArgumentException($position_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Add item to Position_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\PositionObjectType $item
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function addToPosition_Reference(\StructType\PositionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PositionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Position_Reference property can only contain items of type \StructType\PositionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Position_Reference[] = $item;
        return $this;
    }
    /**
     * Get Percent_Complete_Proposed_for_Timesheet_Day value
     * @return float|null
     */
    public function getPercent_Complete_Proposed_for_Timesheet_Day()
    {
        return $this->Percent_Complete_Proposed_for_Timesheet_Day;
    }
    /**
     * Set Percent_Complete_Proposed_for_Timesheet_Day value
     * @param float $percent_Complete_Proposed_for_Timesheet_Day
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setPercent_Complete_Proposed_for_Timesheet_Day($percent_Complete_Proposed_for_Timesheet_Day = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Complete_Proposed_for_Timesheet_Day) && !(is_float($percent_Complete_Proposed_for_Timesheet_Day) || is_numeric($percent_Complete_Proposed_for_Timesheet_Day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Complete_Proposed_for_Timesheet_Day, true), gettype($percent_Complete_Proposed_for_Timesheet_Day)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Complete_Proposed_for_Timesheet_Day) && mb_strlen(mb_substr($percent_Complete_Proposed_for_Timesheet_Day, false !== mb_strpos($percent_Complete_Proposed_for_Timesheet_Day, '.') ? mb_strpos($percent_Complete_Proposed_for_Timesheet_Day, '.') + 1 : mb_strlen($percent_Complete_Proposed_for_Timesheet_Day))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Complete_Proposed_for_Timesheet_Day, true), mb_strlen(mb_substr($percent_Complete_Proposed_for_Timesheet_Day, mb_strpos($percent_Complete_Proposed_for_Timesheet_Day, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Complete_Proposed_for_Timesheet_Day) && $percent_Complete_Proposed_for_Timesheet_Day < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Complete_Proposed_for_Timesheet_Day, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Complete_Proposed_for_Timesheet_Day) && mb_strlen(preg_replace('/(\D)/', '', $percent_Complete_Proposed_for_Timesheet_Day)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Complete_Proposed_for_Timesheet_Day, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Complete_Proposed_for_Timesheet_Day))), __LINE__);
        }
        $this->Percent_Complete_Proposed_for_Timesheet_Day = $percent_Complete_Proposed_for_Timesheet_Day;
        return $this;
    }
    /**
     * Get Time_In_Time_Out_Data value
     * @return \StructType\Time_In_Time_Out_WWS_DataType[]|null
     */
    public function getTime_In_Time_Out_Data()
    {
        return $this->Time_In_Time_Out_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTime_In_Time_Out_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTime_In_Time_Out_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTime_In_Time_Out_DataForArrayConstraintsFromSetTime_In_Time_Out_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timesheet_Daily_WWS_DataTypeTime_In_Time_Out_DataItem) {
            // validation for constraint: itemType
            if (!$timesheet_Daily_WWS_DataTypeTime_In_Time_Out_DataItem instanceof \StructType\Time_In_Time_Out_WWS_DataType) {
                $invalidValues[] = is_object($timesheet_Daily_WWS_DataTypeTime_In_Time_Out_DataItem) ? get_class($timesheet_Daily_WWS_DataTypeTime_In_Time_Out_DataItem) : sprintf('%s(%s)', gettype($timesheet_Daily_WWS_DataTypeTime_In_Time_Out_DataItem), var_export($timesheet_Daily_WWS_DataTypeTime_In_Time_Out_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Time_In_Time_Out_Data property can only contain items of type \StructType\Time_In_Time_Out_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Time_In_Time_Out_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_In_Time_Out_WWS_DataType[] $time_In_Time_Out_Data
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function setTime_In_Time_Out_Data(array $time_In_Time_Out_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($time_In_Time_Out_DataArrayErrorMessage = self::validateTime_In_Time_Out_DataForArrayConstraintsFromSetTime_In_Time_Out_Data($time_In_Time_Out_Data))) {
            throw new \InvalidArgumentException($time_In_Time_Out_DataArrayErrorMessage, __LINE__);
        }
        $this->Time_In_Time_Out_Data = $time_In_Time_Out_Data;
        return $this;
    }
    /**
     * Add item to Time_In_Time_Out_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Time_In_Time_Out_WWS_DataType $item
     * @return \StructType\Timesheet_Daily_WWS_DataType
     */
    public function addToTime_In_Time_Out_Data(\StructType\Time_In_Time_Out_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Time_In_Time_Out_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Time_In_Time_Out_Data property can only contain items of type \StructType\Time_In_Time_Out_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Time_In_Time_Out_Data[] = $item;
        return $this;
    }
}
