<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Invoice_Contract_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Submit Supplier Invoice Contract Response
 * @subpackage Structs
 */
class Submit_Supplier_Invoice_Contract_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Recurring Supplier Invoice Contract ID. This is the Recurring Supplier Invoice unique identifier. Supplier Invoice Contract was renamed to Recurring Supplier Invoice and refer to the same business object.
     * - minOccurs: 0
     * @var \StructType\Recurring_Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Contract_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Invoice_Contract_ResponseType
     * @uses Submit_Supplier_Invoice_Contract_ResponseType::setSupplier_Invoice_Contract_Reference()
     * @uses Submit_Supplier_Invoice_Contract_ResponseType::setVersion()
     * @param \StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference
     * @param string $version
     */
    public function __construct(\StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Contract_Reference($supplier_Invoice_Contract_Reference)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Contract_Reference value
     * @return \StructType\Recurring_Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Contract_Reference()
    {
        return $this->Supplier_Invoice_Contract_Reference;
    }
    /**
     * Set Supplier_Invoice_Contract_Reference value
     * @param \StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference
     * @return \StructType\Submit_Supplier_Invoice_Contract_ResponseType
     */
    public function setSupplier_Invoice_Contract_Reference(\StructType\Recurring_Supplier_InvoiceObjectType $supplier_Invoice_Contract_Reference = null)
    {
        $this->Supplier_Invoice_Contract_Reference = $supplier_Invoice_Contract_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Invoice_Contract_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
