<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data required to create a Shared Requisition Template
 * @subpackage Structs
 */
class Requisition_Template_DataType extends AbstractStructBase
{
    /**
     * The Requisition_Template_ID
     * Meta information extracted from the WSDL
     * - documentation: The ID for the requistion Template to update
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requisition_Template_ID;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requisition Template Company. This value will be used set the Company on Requisitions created via this Requisition Template
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Requisition_Template_Name
     * Meta information extracted from the WSDL
     * - documentation: Shared Template Name is used to provide a human friendly option for searching and finding Requisition Templates
     * - maxOccurs: 1
     * @var string
     */
    public $Requisition_Template_Name;
    /**
     * The Owned_By_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worker who owns the Shared Requisition Template.
     * @var \StructType\WorkerObjectType
     */
    public $Owned_By_Reference;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the Shared Requisition Document was created.
     * - maxOccurs: 1
     * @var string
     */
    public $Document_Date;
    /**
     * The Requisition_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Currency for the Requisition Template. This will be set on Requisitions created via this Template. This should be a currency that is valid for the Company. If no Currency is provided the default Currency for the Owner of The
     * Template will be used.
     * @var \StructType\CurrencyObjectType
     */
    public $Requisition_Currency_Reference;
    /**
     * The Job_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to New Hire Template for Job Profile
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType[]
     */
    public $Job_Profile_Reference;
    /**
     * The Public
     * Meta information extracted from the WSDL
     * - documentation: One of Four options for Sharing a Requisition Template. If this option is set to True then access level is Public.
     * - choice: Public | Security_Group_for_Template_Reference | User_Reference | Not_Shared
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Public;
    /**
     * The Security_Group_for_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: One of Four options for sharing a Requisition Template. This option allows you to select Security Groups that should be allowed to use the Template when creating Requisitions.
     * - choice: Public | Security_Group_for_Template_Reference | User_Reference | Not_Shared
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Security_GroupObjectType
     */
    public $Security_Group_for_Template_Reference;
    /**
     * The User_Reference
     * Meta information extracted from the WSDL
     * - documentation: One of Four options for sharing a Requisition Template. This option allows you to select Specific Users that should be allowed to use the Template when creating Requisitions.
     * - choice: Public | Security_Group_for_Template_Reference | User_Reference | Not_Shared
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\System_UserObjectType[]
     */
    public $User_Reference;
    /**
     * The Not_Shared
     * Meta information extracted from the WSDL
     * - documentation: One of Four options for sharing a Requisition Template. This option restricts access to the Requisition Template when creating Requisitions to everyone except the Owner of the Requisition Template.
     * - choice: Public | Security_Group_for_Template_Reference | User_Reference | Not_Shared
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Not_Shared;
    /**
     * The Requisition_Template_Goods_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing Requisition Template Goods Line data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_Template_Goods_Line_DataType[]
     */
    public $Requisition_Template_Goods_Line_Data;
    /**
     * The Requisition_Template_Service_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing Supplier Invoice Line data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_Template_Service_Line_DataType[]
     */
    public $Requisition_Template_Service_Line_Data;
    /**
     * Constructor method for Requisition_Template_DataType
     * @uses Requisition_Template_DataType::setRequisition_Template_ID()
     * @uses Requisition_Template_DataType::setCompany_Reference()
     * @uses Requisition_Template_DataType::setRequisition_Template_Name()
     * @uses Requisition_Template_DataType::setOwned_By_Reference()
     * @uses Requisition_Template_DataType::setDocument_Date()
     * @uses Requisition_Template_DataType::setRequisition_Currency_Reference()
     * @uses Requisition_Template_DataType::setJob_Profile_Reference()
     * @uses Requisition_Template_DataType::setPublic()
     * @uses Requisition_Template_DataType::setSecurity_Group_for_Template_Reference()
     * @uses Requisition_Template_DataType::setUser_Reference()
     * @uses Requisition_Template_DataType::setNot_Shared()
     * @uses Requisition_Template_DataType::setRequisition_Template_Goods_Line_Data()
     * @uses Requisition_Template_DataType::setRequisition_Template_Service_Line_Data()
     * @param string $requisition_Template_ID
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $requisition_Template_Name
     * @param \StructType\WorkerObjectType $owned_By_Reference
     * @param string $document_Date
     * @param \StructType\CurrencyObjectType $requisition_Currency_Reference
     * @param \StructType\Job_ProfileObjectType[] $job_Profile_Reference
     * @param bool $public
     * @param \StructType\Security_GroupObjectType $security_Group_for_Template_Reference
     * @param \StructType\System_UserObjectType[] $user_Reference
     * @param bool $not_Shared
     * @param \StructType\Requisition_Template_Goods_Line_DataType[] $requisition_Template_Goods_Line_Data
     * @param \StructType\Requisition_Template_Service_Line_DataType[] $requisition_Template_Service_Line_Data
     */
    public function __construct($requisition_Template_ID = null, \StructType\CompanyObjectType $company_Reference = null, $requisition_Template_Name = null, \StructType\WorkerObjectType $owned_By_Reference = null, $document_Date = null, \StructType\CurrencyObjectType $requisition_Currency_Reference = null, array $job_Profile_Reference = array(), $public = null, \StructType\Security_GroupObjectType $security_Group_for_Template_Reference = null, array $user_Reference = array(), $not_Shared = null, array $requisition_Template_Goods_Line_Data = array(), array $requisition_Template_Service_Line_Data = array())
    {
        $this
            ->setRequisition_Template_ID($requisition_Template_ID)
            ->setCompany_Reference($company_Reference)
            ->setRequisition_Template_Name($requisition_Template_Name)
            ->setOwned_By_Reference($owned_By_Reference)
            ->setDocument_Date($document_Date)
            ->setRequisition_Currency_Reference($requisition_Currency_Reference)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setPublic($public)
            ->setSecurity_Group_for_Template_Reference($security_Group_for_Template_Reference)
            ->setUser_Reference($user_Reference)
            ->setNot_Shared($not_Shared)
            ->setRequisition_Template_Goods_Line_Data($requisition_Template_Goods_Line_Data)
            ->setRequisition_Template_Service_Line_Data($requisition_Template_Service_Line_Data);
    }
    /**
     * Get Requisition_Template_ID value
     * @return string|null
     */
    public function getRequisition_Template_ID()
    {
        return $this->Requisition_Template_ID;
    }
    /**
     * Set Requisition_Template_ID value
     * @param string $requisition_Template_ID
     * @return \StructType\Requisition_Template_DataType
     */
    public function setRequisition_Template_ID($requisition_Template_ID = null)
    {
        // validation for constraint: string
        if (!is_null($requisition_Template_ID) && !is_string($requisition_Template_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requisition_Template_ID, true), gettype($requisition_Template_ID)), __LINE__);
        }
        $this->Requisition_Template_ID = $requisition_Template_ID;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Requisition_Template_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Requisition_Template_Name value
     * @return string|null
     */
    public function getRequisition_Template_Name()
    {
        return $this->Requisition_Template_Name;
    }
    /**
     * Set Requisition_Template_Name value
     * @param string $requisition_Template_Name
     * @return \StructType\Requisition_Template_DataType
     */
    public function setRequisition_Template_Name($requisition_Template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($requisition_Template_Name) && !is_string($requisition_Template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requisition_Template_Name, true), gettype($requisition_Template_Name)), __LINE__);
        }
        $this->Requisition_Template_Name = $requisition_Template_Name;
        return $this;
    }
    /**
     * Get Owned_By_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getOwned_By_Reference()
    {
        return $this->Owned_By_Reference;
    }
    /**
     * Set Owned_By_Reference value
     * @param \StructType\WorkerObjectType $owned_By_Reference
     * @return \StructType\Requisition_Template_DataType
     */
    public function setOwned_By_Reference(\StructType\WorkerObjectType $owned_By_Reference = null)
    {
        $this->Owned_By_Reference = $owned_By_Reference;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Requisition_Template_DataType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Requisition_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getRequisition_Currency_Reference()
    {
        return $this->Requisition_Currency_Reference;
    }
    /**
     * Set Requisition_Currency_Reference value
     * @param \StructType\CurrencyObjectType $requisition_Currency_Reference
     * @return \StructType\Requisition_Template_DataType
     */
    public function setRequisition_Currency_Reference(\StructType\CurrencyObjectType $requisition_Currency_Reference = null)
    {
        $this->Requisition_Currency_Reference = $requisition_Currency_Reference;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType[]|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setJob_Profile_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJob_Profile_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJob_Profile_ReferenceForArrayConstraintsFromSetJob_Profile_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_DataTypeJob_Profile_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_DataTypeJob_Profile_ReferenceItem instanceof \StructType\Job_ProfileObjectType) {
                $invalidValues[] = is_object($requisition_Template_DataTypeJob_Profile_ReferenceItem) ? get_class($requisition_Template_DataTypeJob_Profile_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Template_DataTypeJob_Profile_ReferenceItem), var_export($requisition_Template_DataTypeJob_Profile_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Job_Profile_Reference property can only contain items of type \StructType\Job_ProfileObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Job_Profile_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ProfileObjectType[] $job_Profile_Reference
     * @return \StructType\Requisition_Template_DataType
     */
    public function setJob_Profile_Reference(array $job_Profile_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($job_Profile_ReferenceArrayErrorMessage = self::validateJob_Profile_ReferenceForArrayConstraintsFromSetJob_Profile_Reference($job_Profile_Reference))) {
            throw new \InvalidArgumentException($job_Profile_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Add item to Job_Profile_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Job_ProfileObjectType $item
     * @return \StructType\Requisition_Template_DataType
     */
    public function addToJob_Profile_Reference(\StructType\Job_ProfileObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job_ProfileObjectType) {
            throw new \InvalidArgumentException(sprintf('The Job_Profile_Reference property can only contain items of type \StructType\Job_ProfileObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Job_Profile_Reference[] = $item;
        return $this;
    }
    /**
     * Get Public value
     * @return bool|null
     */
    public function getPublic()
    {
        return isset($this->Public) ? $this->Public : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPublic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPublic method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePublicForChoiceConstraintsFromSetPublic($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Security_Group_for_Template_Reference',
            'User_Reference',
            'Not_Shared',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Public can\'t be set as the property %s is already set. Only one property must be set among these properties: Public, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Public value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $public
     * @return \StructType\Requisition_Template_DataType
     */
    public function setPublic($public = null)
    {
        // validation for constraint: boolean
        if (!is_null($public) && !is_bool($public)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($public, true), gettype($public)), __LINE__);
        }
        // validation for constraint: choice(Public, Security_Group_for_Template_Reference, User_Reference, Not_Shared)
        if ('' !== ($publicChoiceErrorMessage = self::validatePublicForChoiceConstraintsFromSetPublic($public))) {
            throw new \InvalidArgumentException($publicChoiceErrorMessage, __LINE__);
        }
        if (is_null($public) || (is_array($public) && empty($public))) {
            unset($this->Public);
        } else {
            $this->Public = $public;
        }
        return $this;
    }
    /**
     * Get Security_Group_for_Template_Reference value
     * @return \StructType\Security_GroupObjectType|null
     */
    public function getSecurity_Group_for_Template_Reference()
    {
        return isset($this->Security_Group_for_Template_Reference) ? $this->Security_Group_for_Template_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSecurity_Group_for_Template_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecurity_Group_for_Template_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSecurity_Group_for_Template_ReferenceForChoiceConstraintsFromSetSecurity_Group_for_Template_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Public',
            'User_Reference',
            'Not_Shared',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Security_Group_for_Template_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Security_Group_for_Template_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Security_Group_for_Template_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Security_GroupObjectType $security_Group_for_Template_Reference
     * @return \StructType\Requisition_Template_DataType
     */
    public function setSecurity_Group_for_Template_Reference(\StructType\Security_GroupObjectType $security_Group_for_Template_Reference = null)
    {
        // validation for constraint: choice(Public, Security_Group_for_Template_Reference, User_Reference, Not_Shared)
        if ('' !== ($security_Group_for_Template_ReferenceChoiceErrorMessage = self::validateSecurity_Group_for_Template_ReferenceForChoiceConstraintsFromSetSecurity_Group_for_Template_Reference($security_Group_for_Template_Reference))) {
            throw new \InvalidArgumentException($security_Group_for_Template_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($security_Group_for_Template_Reference) || (is_array($security_Group_for_Template_Reference) && empty($security_Group_for_Template_Reference))) {
            unset($this->Security_Group_for_Template_Reference);
        } else {
            $this->Security_Group_for_Template_Reference = $security_Group_for_Template_Reference;
        }
        return $this;
    }
    /**
     * Get User_Reference value
     * @return \StructType\System_UserObjectType[]|null
     */
    public function getUser_Reference()
    {
        return isset($this->User_Reference) ? $this->User_Reference : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUser_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUser_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUser_ReferenceForArrayConstraintsFromSetUser_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_DataTypeUser_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_DataTypeUser_ReferenceItem instanceof \StructType\System_UserObjectType) {
                $invalidValues[] = is_object($requisition_Template_DataTypeUser_ReferenceItem) ? get_class($requisition_Template_DataTypeUser_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Template_DataTypeUser_ReferenceItem), var_export($requisition_Template_DataTypeUser_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The User_Reference property can only contain items of type \StructType\System_UserObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setUser_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUser_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUser_ReferenceForChoiceConstraintsFromSetUser_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Public',
            'Security_Group_for_Template_Reference',
            'Not_Shared',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property User_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: User_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set User_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\System_UserObjectType[] $user_Reference
     * @return \StructType\Requisition_Template_DataType
     */
    public function setUser_Reference(array $user_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($user_ReferenceArrayErrorMessage = self::validateUser_ReferenceForArrayConstraintsFromSetUser_Reference($user_Reference))) {
            throw new \InvalidArgumentException($user_ReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Public, Security_Group_for_Template_Reference, User_Reference, Not_Shared)
        if ('' !== ($user_ReferenceChoiceErrorMessage = self::validateUser_ReferenceForChoiceConstraintsFromSetUser_Reference($user_Reference))) {
            throw new \InvalidArgumentException($user_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($user_Reference) || (is_array($user_Reference) && empty($user_Reference))) {
            unset($this->User_Reference);
        } else {
            $this->User_Reference = $user_Reference;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToUser_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToUser_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToUser_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Public',
            'Security_Group_for_Template_Reference',
            'Not_Shared',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property User_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: User_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to User_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\System_UserObjectType $item
     * @return \StructType\Requisition_Template_DataType
     */
    public function addToUser_Reference(\StructType\System_UserObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\System_UserObjectType) {
            throw new \InvalidArgumentException(sprintf('The User_Reference property can only contain items of type \StructType\System_UserObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Public, Security_Group_for_Template_Reference, User_Reference, Not_Shared)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToUser_Reference($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->User_Reference[] = $item;
        return $this;
    }
    /**
     * Get Not_Shared value
     * @return bool|null
     */
    public function getNot_Shared()
    {
        return isset($this->Not_Shared) ? $this->Not_Shared : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNot_Shared method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNot_Shared method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNot_SharedForChoiceConstraintsFromSetNot_Shared($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Public',
            'Security_Group_for_Template_Reference',
            'User_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Not_Shared can\'t be set as the property %s is already set. Only one property must be set among these properties: Not_Shared, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Not_Shared value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $not_Shared
     * @return \StructType\Requisition_Template_DataType
     */
    public function setNot_Shared($not_Shared = null)
    {
        // validation for constraint: boolean
        if (!is_null($not_Shared) && !is_bool($not_Shared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($not_Shared, true), gettype($not_Shared)), __LINE__);
        }
        // validation for constraint: choice(Public, Security_Group_for_Template_Reference, User_Reference, Not_Shared)
        if ('' !== ($not_SharedChoiceErrorMessage = self::validateNot_SharedForChoiceConstraintsFromSetNot_Shared($not_Shared))) {
            throw new \InvalidArgumentException($not_SharedChoiceErrorMessage, __LINE__);
        }
        if (is_null($not_Shared) || (is_array($not_Shared) && empty($not_Shared))) {
            unset($this->Not_Shared);
        } else {
            $this->Not_Shared = $not_Shared;
        }
        return $this;
    }
    /**
     * Get Requisition_Template_Goods_Line_Data value
     * @return \StructType\Requisition_Template_Goods_Line_DataType[]|null
     */
    public function getRequisition_Template_Goods_Line_Data()
    {
        return $this->Requisition_Template_Goods_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Template_Goods_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Template_Goods_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Template_Goods_Line_DataForArrayConstraintsFromSetRequisition_Template_Goods_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_DataTypeRequisition_Template_Goods_Line_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_DataTypeRequisition_Template_Goods_Line_DataItem instanceof \StructType\Requisition_Template_Goods_Line_DataType) {
                $invalidValues[] = is_object($requisition_Template_DataTypeRequisition_Template_Goods_Line_DataItem) ? get_class($requisition_Template_DataTypeRequisition_Template_Goods_Line_DataItem) : sprintf('%s(%s)', gettype($requisition_Template_DataTypeRequisition_Template_Goods_Line_DataItem), var_export($requisition_Template_DataTypeRequisition_Template_Goods_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Template_Goods_Line_Data property can only contain items of type \StructType\Requisition_Template_Goods_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Template_Goods_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Template_Goods_Line_DataType[] $requisition_Template_Goods_Line_Data
     * @return \StructType\Requisition_Template_DataType
     */
    public function setRequisition_Template_Goods_Line_Data(array $requisition_Template_Goods_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Template_Goods_Line_DataArrayErrorMessage = self::validateRequisition_Template_Goods_Line_DataForArrayConstraintsFromSetRequisition_Template_Goods_Line_Data($requisition_Template_Goods_Line_Data))) {
            throw new \InvalidArgumentException($requisition_Template_Goods_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Template_Goods_Line_Data = $requisition_Template_Goods_Line_Data;
        return $this;
    }
    /**
     * Add item to Requisition_Template_Goods_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Template_Goods_Line_DataType $item
     * @return \StructType\Requisition_Template_DataType
     */
    public function addToRequisition_Template_Goods_Line_Data(\StructType\Requisition_Template_Goods_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_Template_Goods_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Template_Goods_Line_Data property can only contain items of type \StructType\Requisition_Template_Goods_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Template_Goods_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Template_Service_Line_Data value
     * @return \StructType\Requisition_Template_Service_Line_DataType[]|null
     */
    public function getRequisition_Template_Service_Line_Data()
    {
        return $this->Requisition_Template_Service_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Template_Service_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Template_Service_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Template_Service_Line_DataForArrayConstraintsFromSetRequisition_Template_Service_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_DataTypeRequisition_Template_Service_Line_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_DataTypeRequisition_Template_Service_Line_DataItem instanceof \StructType\Requisition_Template_Service_Line_DataType) {
                $invalidValues[] = is_object($requisition_Template_DataTypeRequisition_Template_Service_Line_DataItem) ? get_class($requisition_Template_DataTypeRequisition_Template_Service_Line_DataItem) : sprintf('%s(%s)', gettype($requisition_Template_DataTypeRequisition_Template_Service_Line_DataItem), var_export($requisition_Template_DataTypeRequisition_Template_Service_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Template_Service_Line_Data property can only contain items of type \StructType\Requisition_Template_Service_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Template_Service_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Template_Service_Line_DataType[] $requisition_Template_Service_Line_Data
     * @return \StructType\Requisition_Template_DataType
     */
    public function setRequisition_Template_Service_Line_Data(array $requisition_Template_Service_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Template_Service_Line_DataArrayErrorMessage = self::validateRequisition_Template_Service_Line_DataForArrayConstraintsFromSetRequisition_Template_Service_Line_Data($requisition_Template_Service_Line_Data))) {
            throw new \InvalidArgumentException($requisition_Template_Service_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Template_Service_Line_Data = $requisition_Template_Service_Line_Data;
        return $this;
    }
    /**
     * Add item to Requisition_Template_Service_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Template_Service_Line_DataType $item
     * @return \StructType\Requisition_Template_DataType
     */
    public function addToRequisition_Template_Service_Line_Data(\StructType\Requisition_Template_Service_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_Template_Service_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Template_Service_Line_Data property can only contain items of type \StructType\Requisition_Template_Service_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Template_Service_Line_Data[] = $item;
        return $this;
    }
}
