<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Catalog_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: "References" element allowing the specification of specific object instances to be returned based on ID values.
 * @subpackage Structs
 */
class Supplier_Catalog_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Supplier Catalogs.
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_CatalogObjectType[]
     */
    public $Supplier_Catalog_Reference;
    /**
     * Constructor method for Supplier_Catalog_Request_ReferencesType
     * @uses Supplier_Catalog_Request_ReferencesType::setSupplier_Catalog_Reference()
     * @param \StructType\Supplier_CatalogObjectType[] $supplier_Catalog_Reference
     */
    public function __construct(array $supplier_Catalog_Reference = array())
    {
        $this
            ->setSupplier_Catalog_Reference($supplier_Catalog_Reference);
    }
    /**
     * Get Supplier_Catalog_Reference value
     * @return \StructType\Supplier_CatalogObjectType[]|null
     */
    public function getSupplier_Catalog_Reference()
    {
        return $this->Supplier_Catalog_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Catalog_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Catalog_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Catalog_ReferenceForArrayConstraintsFromSetSupplier_Catalog_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Catalog_Request_ReferencesTypeSupplier_Catalog_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Catalog_Request_ReferencesTypeSupplier_Catalog_ReferenceItem instanceof \StructType\Supplier_CatalogObjectType) {
                $invalidValues[] = is_object($supplier_Catalog_Request_ReferencesTypeSupplier_Catalog_ReferenceItem) ? get_class($supplier_Catalog_Request_ReferencesTypeSupplier_Catalog_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Catalog_Request_ReferencesTypeSupplier_Catalog_ReferenceItem), var_export($supplier_Catalog_Request_ReferencesTypeSupplier_Catalog_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Catalog_Reference property can only contain items of type \StructType\Supplier_CatalogObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogObjectType[] $supplier_Catalog_Reference
     * @return \StructType\Supplier_Catalog_Request_ReferencesType
     */
    public function setSupplier_Catalog_Reference(array $supplier_Catalog_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Catalog_ReferenceArrayErrorMessage = self::validateSupplier_Catalog_ReferenceForArrayConstraintsFromSetSupplier_Catalog_Reference($supplier_Catalog_Reference))) {
            throw new \InvalidArgumentException($supplier_Catalog_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Catalog_Reference = $supplier_Catalog_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CatalogObjectType $item
     * @return \StructType\Supplier_Catalog_Request_ReferencesType
     */
    public function addToSupplier_Catalog_Reference(\StructType\Supplier_CatalogObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CatalogObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Catalog_Reference property can only contain items of type \StructType\Supplier_CatalogObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Catalog_Reference[] = $item;
        return $this;
    }
}
