<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Template_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the request criteria to identify the specific instance(s) of a project plan template.
 * @subpackage Structs
 */
class Project_Plan_Template_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Project_Plan_Template_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Plan_Template_Name;
    /**
     * Constructor method for Project_Plan_Template_Request_CriteriaType
     * @uses Project_Plan_Template_Request_CriteriaType::setProject_Plan_Template_Name()
     * @param string $project_Plan_Template_Name
     */
    public function __construct($project_Plan_Template_Name = null)
    {
        $this
            ->setProject_Plan_Template_Name($project_Plan_Template_Name);
    }
    /**
     * Get Project_Plan_Template_Name value
     * @return string|null
     */
    public function getProject_Plan_Template_Name()
    {
        return $this->Project_Plan_Template_Name;
    }
    /**
     * Set Project_Plan_Template_Name value
     * @param string $project_Plan_Template_Name
     * @return \StructType\Project_Plan_Template_Request_CriteriaType
     */
    public function setProject_Plan_Template_Name($project_Plan_Template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($project_Plan_Template_Name) && !is_string($project_Plan_Template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Plan_Template_Name, true), gettype($project_Plan_Template_Name)), __LINE__);
        }
        $this->Project_Plan_Template_Name = $project_Plan_Template_Name;
        return $this;
    }
}
