<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financials_Business_Process_ParametersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for business processing
 * @subpackage Structs
 */
class Financials_Business_Process_ParametersType extends AbstractStructBase
{
    /**
     * The Auto_Complete
     * Meta information extracted from the WSDL
     * - documentation: When set to "true" or "1", the business process is automatically processed. This means that all approvals will be automatically approved in the system, all reviews and to-do's will be automatically by-passed, and all notifications
     * will be automatically suppressed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Auto_Complete;
    /**
     * The Comment_Data
     * Meta information extracted from the WSDL
     * - documentation: Captures the Comment for the Business Process.
     * - minOccurs: 0
     * @var \StructType\Business_Process_Comment_DataType
     */
    public $Comment_Data;
    /**
     * Constructor method for Financials_Business_Process_ParametersType
     * @uses Financials_Business_Process_ParametersType::setAuto_Complete()
     * @uses Financials_Business_Process_ParametersType::setComment_Data()
     * @param bool $auto_Complete
     * @param \StructType\Business_Process_Comment_DataType $comment_Data
     */
    public function __construct($auto_Complete = null, \StructType\Business_Process_Comment_DataType $comment_Data = null)
    {
        $this
            ->setAuto_Complete($auto_Complete)
            ->setComment_Data($comment_Data);
    }
    /**
     * Get Auto_Complete value
     * @return bool|null
     */
    public function getAuto_Complete()
    {
        return $this->Auto_Complete;
    }
    /**
     * Set Auto_Complete value
     * @param bool $auto_Complete
     * @return \StructType\Financials_Business_Process_ParametersType
     */
    public function setAuto_Complete($auto_Complete = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_Complete) && !is_bool($auto_Complete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_Complete, true), gettype($auto_Complete)), __LINE__);
        }
        $this->Auto_Complete = $auto_Complete;
        return $this;
    }
    /**
     * Get Comment_Data value
     * @return \StructType\Business_Process_Comment_DataType|null
     */
    public function getComment_Data()
    {
        return $this->Comment_Data;
    }
    /**
     * Set Comment_Data value
     * @param \StructType\Business_Process_Comment_DataType $comment_Data
     * @return \StructType\Financials_Business_Process_ParametersType
     */
    public function setComment_Data(\StructType\Business_Process_Comment_DataType $comment_Data = null)
    {
        $this->Comment_Data = $comment_Data;
        return $this;
    }
}
