<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Request_Line_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Quantity is required for a Purchase Item. | Total of Extended Amount in Invoice Request line splits are not same as Extended Amount for Invoice Request Line | Total of Quantity in Invoice Request line splits are not same as Quantity
 * for Invoice Request Goods Line | Values for Quantity and Unit Cost are not allowed for Invoice Request Service Lines. | Service Lines cannot be split based on quantity. | Can not have any combination of Project, Project Phase or Project Task worktags
 * for the same line. | Only one worktag for each type is allowed for each document line. | Spend Category must match the Spend Category for the Purchase Item. | Element that captures Supplier Invoice Request Line information. A Supplier Invoice Request
 * may have multiple lines with or without splits.
 * @subpackage Structs
 */
class Supplier_Invoice_Request_Line_Data_InboundType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Request_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Invoice Request for the referenced Supplier Invoice Request Line must be equal to the Supplier Invoice Request in this request | Setting of Supplier Invoice Request Line Reference ID is not allowed for add-only service
     * requests | Supplier Invoice Request Line Reference ID. This is optional and will be auto-generated if left blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Request_Line_ID;
    /**
     * The Line_Order
     * Meta information extracted from the WSDL
     * - documentation: Optional line order. If specified, lines will be sorted by this value when displayed and when invoice is printed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Order;
    /**
     * The Quantity_Based_Line
     * Meta information extracted from the WSDL
     * - documentation: Boolean to determine if the supplier invoice request line is a goods line.
     * - choice: Quantity_Based_Line | Amount_Based_Line
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Quantity_Based_Line;
    /**
     * The Amount_Based_Line
     * Meta information extracted from the WSDL
     * - documentation: Boolean to determine if the supplier invoice request line is a service line.
     * - choice: Quantity_Based_Line | Amount_Based_Line
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Amount_Based_Line;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item. Purchase items are goods and services that are purchased from suppliers.
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Line_Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Item_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure for the Supplier Invoice Line to be imported.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags are not allowed when there are split lines. | Worktag Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Line_Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Supplier Invoice request line. This is free form text.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Memo;
    /**
     * The Internal_Memo
     * Meta information extracted from the WSDL
     * - documentation: Internal Memo on the Supplier Invoice Request Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Memo;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Invoice Request Line can't be marked as Billable if the selected Worktag is not for a Billable Project. | Billable Flag at Supplier Invoice Request Line Level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Supplier_Invoice_Request_Line_Splits_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures Supplier Invoice Request Line Splits information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType[]
     */
    public $Supplier_Invoice_Request_Line_Splits_Data;
    /**
     * Constructor method for Supplier_Invoice_Request_Line_Data_InboundType
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setSupplier_Invoice_Request_Line_ID()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setLine_Order()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setQuantity_Based_Line()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setAmount_Based_Line()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setPurchase_Item_Reference()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setLine_Item_Description()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setSpend_Category_Reference()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setQuantity()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setUnit_of_Measure_Reference()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setUnit_Cost()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setExtended_Amount()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setWorktags_Reference()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setLine_Memo()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setInternal_Memo()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setBillable()
     * @uses Supplier_Invoice_Request_Line_Data_InboundType::setSupplier_Invoice_Request_Line_Splits_Data()
     * @param string $supplier_Invoice_Request_Line_ID
     * @param string $line_Order
     * @param bool $quantity_Based_Line
     * @param bool $amount_Based_Line
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param string $line_Item_Description
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param string $line_Memo
     * @param string $internal_Memo
     * @param bool $billable
     * @param \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType[] $supplier_Invoice_Request_Line_Splits_Data
     */
    public function __construct($supplier_Invoice_Request_Line_ID = null, $line_Order = null, $quantity_Based_Line = null, $amount_Based_Line = null, \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, $line_Item_Description = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $extended_Amount = null, array $worktags_Reference = array(), $line_Memo = null, $internal_Memo = null, $billable = null, array $supplier_Invoice_Request_Line_Splits_Data = array())
    {
        $this
            ->setSupplier_Invoice_Request_Line_ID($supplier_Invoice_Request_Line_ID)
            ->setLine_Order($line_Order)
            ->setQuantity_Based_Line($quantity_Based_Line)
            ->setAmount_Based_Line($amount_Based_Line)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setLine_Item_Description($line_Item_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setWorktags_Reference($worktags_Reference)
            ->setLine_Memo($line_Memo)
            ->setInternal_Memo($internal_Memo)
            ->setBillable($billable)
            ->setSupplier_Invoice_Request_Line_Splits_Data($supplier_Invoice_Request_Line_Splits_Data);
    }
    /**
     * Get Supplier_Invoice_Request_Line_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_Request_Line_ID()
    {
        return $this->Supplier_Invoice_Request_Line_ID;
    }
    /**
     * Set Supplier_Invoice_Request_Line_ID value
     * @param string $supplier_Invoice_Request_Line_ID
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setSupplier_Invoice_Request_Line_ID($supplier_Invoice_Request_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Request_Line_ID) && !is_string($supplier_Invoice_Request_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Request_Line_ID, true), gettype($supplier_Invoice_Request_Line_ID)), __LINE__);
        }
        $this->Supplier_Invoice_Request_Line_ID = $supplier_Invoice_Request_Line_ID;
        return $this;
    }
    /**
     * Get Line_Order value
     * @return string|null
     */
    public function getLine_Order()
    {
        return $this->Line_Order;
    }
    /**
     * Set Line_Order value
     * @param string $line_Order
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setLine_Order($line_Order = null)
    {
        // validation for constraint: string
        if (!is_null($line_Order) && !is_string($line_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Order, true), gettype($line_Order)), __LINE__);
        }
        $this->Line_Order = $line_Order;
        return $this;
    }
    /**
     * Get Quantity_Based_Line value
     * @return bool|null
     */
    public function getQuantity_Based_Line()
    {
        return isset($this->Quantity_Based_Line) ? $this->Quantity_Based_Line : null;
    }
    /**
     * This method is responsible for validating the value passed to the setQuantity_Based_Line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQuantity_Based_Line method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateQuantity_Based_LineForChoiceConstraintsFromSetQuantity_Based_Line($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Amount_Based_Line',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Quantity_Based_Line can\'t be set as the property %s is already set. Only one property must be set among these properties: Quantity_Based_Line, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Quantity_Based_Line value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $quantity_Based_Line
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setQuantity_Based_Line($quantity_Based_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($quantity_Based_Line) && !is_bool($quantity_Based_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($quantity_Based_Line, true), gettype($quantity_Based_Line)), __LINE__);
        }
        // validation for constraint: choice(Quantity_Based_Line, Amount_Based_Line)
        if ('' !== ($quantity_Based_LineChoiceErrorMessage = self::validateQuantity_Based_LineForChoiceConstraintsFromSetQuantity_Based_Line($quantity_Based_Line))) {
            throw new \InvalidArgumentException($quantity_Based_LineChoiceErrorMessage, __LINE__);
        }
        if (is_null($quantity_Based_Line) || (is_array($quantity_Based_Line) && empty($quantity_Based_Line))) {
            unset($this->Quantity_Based_Line);
        } else {
            $this->Quantity_Based_Line = $quantity_Based_Line;
        }
        return $this;
    }
    /**
     * Get Amount_Based_Line value
     * @return bool|null
     */
    public function getAmount_Based_Line()
    {
        return isset($this->Amount_Based_Line) ? $this->Amount_Based_Line : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAmount_Based_Line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmount_Based_Line method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAmount_Based_LineForChoiceConstraintsFromSetAmount_Based_Line($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Quantity_Based_Line',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Amount_Based_Line can\'t be set as the property %s is already set. Only one property must be set among these properties: Amount_Based_Line, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Amount_Based_Line value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $amount_Based_Line
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setAmount_Based_Line($amount_Based_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($amount_Based_Line) && !is_bool($amount_Based_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($amount_Based_Line, true), gettype($amount_Based_Line)), __LINE__);
        }
        // validation for constraint: choice(Quantity_Based_Line, Amount_Based_Line)
        if ('' !== ($amount_Based_LineChoiceErrorMessage = self::validateAmount_Based_LineForChoiceConstraintsFromSetAmount_Based_Line($amount_Based_Line))) {
            throw new \InvalidArgumentException($amount_Based_LineChoiceErrorMessage, __LINE__);
        }
        if (is_null($amount_Based_Line) || (is_array($amount_Based_Line) && empty($amount_Based_Line))) {
            unset($this->Amount_Based_Line);
        } else {
            $this->Amount_Based_Line = $amount_Based_Line;
        }
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Line_Item_Description value
     * @return string|null
     */
    public function getLine_Item_Description()
    {
        return $this->Line_Item_Description;
    }
    /**
     * Set Line_Item_Description value
     * @param string $line_Item_Description
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setLine_Item_Description($line_Item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($line_Item_Description) && !is_string($line_Item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Item_Description, true), gettype($line_Item_Description)), __LINE__);
        }
        $this->Line_Item_Description = $line_Item_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Line_Data_InboundTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Line_Data_InboundTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Line_Data_InboundTypeWorktags_ReferenceItem) ? get_class($supplier_Invoice_Request_Line_Data_InboundTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Line_Data_InboundTypeWorktags_ReferenceItem), var_export($supplier_Invoice_Request_Line_Data_InboundTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Line_Memo value
     * @return string|null
     */
    public function getLine_Memo()
    {
        return $this->Line_Memo;
    }
    /**
     * Set Line_Memo value
     * @param string $line_Memo
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setLine_Memo($line_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($line_Memo) && !is_string($line_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Memo, true), gettype($line_Memo)), __LINE__);
        }
        $this->Line_Memo = $line_Memo;
        return $this;
    }
    /**
     * Get Internal_Memo value
     * @return string|null
     */
    public function getInternal_Memo()
    {
        return $this->Internal_Memo;
    }
    /**
     * Set Internal_Memo value
     * @param string $internal_Memo
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setInternal_Memo($internal_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Memo) && !is_string($internal_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Memo, true), gettype($internal_Memo)), __LINE__);
        }
        $this->Internal_Memo = $internal_Memo;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Request_Line_Splits_Data value
     * @return \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType[]|null
     */
    public function getSupplier_Invoice_Request_Line_Splits_Data()
    {
        return $this->Supplier_Invoice_Request_Line_Splits_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Request_Line_Splits_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Request_Line_Splits_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Request_Line_Splits_DataForArrayConstraintsFromSetSupplier_Invoice_Request_Line_Splits_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_Line_Data_InboundTypeSupplier_Invoice_Request_Line_Splits_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_Line_Data_InboundTypeSupplier_Invoice_Request_Line_Splits_DataItem instanceof \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_Line_Data_InboundTypeSupplier_Invoice_Request_Line_Splits_DataItem) ? get_class($supplier_Invoice_Request_Line_Data_InboundTypeSupplier_Invoice_Request_Line_Splits_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_Line_Data_InboundTypeSupplier_Invoice_Request_Line_Splits_DataItem), var_export($supplier_Invoice_Request_Line_Data_InboundTypeSupplier_Invoice_Request_Line_Splits_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Request_Line_Splits_Data property can only contain items of type \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Request_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType[] $supplier_Invoice_Request_Line_Splits_Data
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function setSupplier_Invoice_Request_Line_Splits_Data(array $supplier_Invoice_Request_Line_Splits_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Request_Line_Splits_DataArrayErrorMessage = self::validateSupplier_Invoice_Request_Line_Splits_DataForArrayConstraintsFromSetSupplier_Invoice_Request_Line_Splits_Data($supplier_Invoice_Request_Line_Splits_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Request_Line_Splits_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Request_Line_Splits_Data = $supplier_Invoice_Request_Line_Splits_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Request_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType $item
     * @return \StructType\Supplier_Invoice_Request_Line_Data_InboundType
     */
    public function addToSupplier_Invoice_Request_Line_Splits_Data(\StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Request_Line_Splits_Data property can only contain items of type \StructType\Supplier_Invoice_Request_Line_Splits_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Request_Line_Splits_Data[] = $item;
        return $this;
    }
}
