<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Group_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Supplier Group data
 * @subpackage Structs
 */
class Supplier_Group_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Group_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Group ID. This is the Supplier Group unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Group_ID;
    /**
     * The Supplier_Group_Name
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Group Name is already in use. | Free form text field for a meaningful Supplier Group Name
     * - maxOccurs: 1
     * @var string
     */
    public $Supplier_Group_Name;
    /**
     * Constructor method for Supplier_Group_DataType
     * @uses Supplier_Group_DataType::setSupplier_Group_ID()
     * @uses Supplier_Group_DataType::setSupplier_Group_Name()
     * @param string $supplier_Group_ID
     * @param string $supplier_Group_Name
     */
    public function __construct($supplier_Group_ID = null, $supplier_Group_Name = null)
    {
        $this
            ->setSupplier_Group_ID($supplier_Group_ID)
            ->setSupplier_Group_Name($supplier_Group_Name);
    }
    /**
     * Get Supplier_Group_ID value
     * @return string|null
     */
    public function getSupplier_Group_ID()
    {
        return $this->Supplier_Group_ID;
    }
    /**
     * Set Supplier_Group_ID value
     * @param string $supplier_Group_ID
     * @return \StructType\Supplier_Group_DataType
     */
    public function setSupplier_Group_ID($supplier_Group_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Group_ID) && !is_string($supplier_Group_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Group_ID, true), gettype($supplier_Group_ID)), __LINE__);
        }
        $this->Supplier_Group_ID = $supplier_Group_ID;
        return $this;
    }
    /**
     * Get Supplier_Group_Name value
     * @return string|null
     */
    public function getSupplier_Group_Name()
    {
        return $this->Supplier_Group_Name;
    }
    /**
     * Set Supplier_Group_Name value
     * @param string $supplier_Group_Name
     * @return \StructType\Supplier_Group_DataType
     */
    public function setSupplier_Group_Name($supplier_Group_Name = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Group_Name) && !is_string($supplier_Group_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Group_Name, true), gettype($supplier_Group_Name)), __LINE__);
        }
        $this->Supplier_Group_Name = $supplier_Group_Name;
        return $this;
    }
}
