<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Authorization_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element around a list of elements representing the amount of data that should be included in the Spend Authorization response. If this element is not included then ALL of the Response Groups are included in the response.
 * @subpackage Structs
 */
class Spend_Authorization_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Spend Authorization Reference data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Spend_Authorization_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Spend Authorization data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Spend_Authorization_Data;
    /**
     * The Include_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the attachment data within Spend Authorization Data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Attachment_Data;
    /**
     * Constructor method for Spend_Authorization_Response_GroupType
     * @uses Spend_Authorization_Response_GroupType::setInclude_Reference()
     * @uses Spend_Authorization_Response_GroupType::setInclude_Spend_Authorization_Data()
     * @uses Spend_Authorization_Response_GroupType::setInclude_Attachment_Data()
     * @param bool $include_Reference
     * @param bool $include_Spend_Authorization_Data
     * @param bool $include_Attachment_Data
     */
    public function __construct($include_Reference = null, $include_Spend_Authorization_Data = null, $include_Attachment_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Spend_Authorization_Data($include_Spend_Authorization_Data)
            ->setInclude_Attachment_Data($include_Attachment_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Spend_Authorization_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Spend_Authorization_Data value
     * @return bool|null
     */
    public function getInclude_Spend_Authorization_Data()
    {
        return $this->Include_Spend_Authorization_Data;
    }
    /**
     * Set Include_Spend_Authorization_Data value
     * @param bool $include_Spend_Authorization_Data
     * @return \StructType\Spend_Authorization_Response_GroupType
     */
    public function setInclude_Spend_Authorization_Data($include_Spend_Authorization_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Spend_Authorization_Data) && !is_bool($include_Spend_Authorization_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Spend_Authorization_Data, true), gettype($include_Spend_Authorization_Data)), __LINE__);
        }
        $this->Include_Spend_Authorization_Data = $include_Spend_Authorization_Data;
        return $this;
    }
    /**
     * Get Include_Attachment_Data value
     * @return bool|null
     */
    public function getInclude_Attachment_Data()
    {
        return $this->Include_Attachment_Data;
    }
    /**
     * Set Include_Attachment_Data value
     * @param bool $include_Attachment_Data
     * @return \StructType\Spend_Authorization_Response_GroupType
     */
    public function setInclude_Attachment_Data($include_Attachment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Attachment_Data) && !is_bool($include_Attachment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Attachment_Data, true), gettype($include_Attachment_Data)), __LINE__);
        }
        $this->Include_Attachment_Data = $include_Attachment_Data;
        return $this;
    }
}
