<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Authorization_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Spend Authorization Reference element contains the specific instance set containing the requested Spend Authorization.
 * @subpackage Structs
 */
class Spend_Authorization_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Spend_Authorization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Spend Authorization object.
     * - maxOccurs: unbounded
     * @var \StructType\Spend_AuthorizationObjectType[]
     */
    public $Spend_Authorization_Reference;
    /**
     * Constructor method for Spend_Authorization_Request_ReferencesType
     * @uses Spend_Authorization_Request_ReferencesType::setSpend_Authorization_Reference()
     * @param \StructType\Spend_AuthorizationObjectType[] $spend_Authorization_Reference
     */
    public function __construct(array $spend_Authorization_Reference = array())
    {
        $this
            ->setSpend_Authorization_Reference($spend_Authorization_Reference);
    }
    /**
     * Get Spend_Authorization_Reference value
     * @return \StructType\Spend_AuthorizationObjectType[]|null
     */
    public function getSpend_Authorization_Reference()
    {
        return $this->Spend_Authorization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Authorization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Authorization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Authorization_ReferenceForArrayConstraintsFromSetSpend_Authorization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_Request_ReferencesTypeSpend_Authorization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_Request_ReferencesTypeSpend_Authorization_ReferenceItem instanceof \StructType\Spend_AuthorizationObjectType) {
                $invalidValues[] = is_object($spend_Authorization_Request_ReferencesTypeSpend_Authorization_ReferenceItem) ? get_class($spend_Authorization_Request_ReferencesTypeSpend_Authorization_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Authorization_Request_ReferencesTypeSpend_Authorization_ReferenceItem), var_export($spend_Authorization_Request_ReferencesTypeSpend_Authorization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Authorization_Reference property can only contain items of type \StructType\Spend_AuthorizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Authorization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_AuthorizationObjectType[] $spend_Authorization_Reference
     * @return \StructType\Spend_Authorization_Request_ReferencesType
     */
    public function setSpend_Authorization_Reference(array $spend_Authorization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Authorization_ReferenceArrayErrorMessage = self::validateSpend_Authorization_ReferenceForArrayConstraintsFromSetSpend_Authorization_Reference($spend_Authorization_Reference))) {
            throw new \InvalidArgumentException($spend_Authorization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Authorization_Reference = $spend_Authorization_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Authorization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_AuthorizationObjectType $item
     * @return \StructType\Spend_Authorization_Request_ReferencesType
     */
    public function addToSpend_Authorization_Reference(\StructType\Spend_AuthorizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_AuthorizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Authorization_Reference property can only contain items of type \StructType\Spend_AuthorizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Authorization_Reference[] = $item;
        return $this;
    }
}
