<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remit-To_Supplier_Connection_Payee_Alternate_NameType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Payee Alternate Name used by Supplier Connection
 * @subpackage Structs
 */
class Remit_To_Supplier_Connection_Payee_Alternate_NameType extends AbstractStructBase
{
    /**
     * The Payee_Alternate_Name
     * Meta information extracted from the WSDL
     * - documentation: Payee Alternate Name
     * - maxOccurs: 1
     * @var string
     */
    public $Payee_Alternate_Name;
    /**
     * The Alternate_Name_Usage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payee Alternate Name Usage Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Name_UsageObjectType[]
     */
    public $Alternate_Name_Usage_Reference;
    /**
     * Constructor method for Remit-To_Supplier_Connection_Payee_Alternate_NameType
     * @uses Remit_To_Supplier_Connection_Payee_Alternate_NameType::setPayee_Alternate_Name()
     * @uses Remit_To_Supplier_Connection_Payee_Alternate_NameType::setAlternate_Name_Usage_Reference()
     * @param string $payee_Alternate_Name
     * @param \StructType\Alternate_Name_UsageObjectType[] $alternate_Name_Usage_Reference
     */
    public function __construct($payee_Alternate_Name = null, array $alternate_Name_Usage_Reference = array())
    {
        $this
            ->setPayee_Alternate_Name($payee_Alternate_Name)
            ->setAlternate_Name_Usage_Reference($alternate_Name_Usage_Reference);
    }
    /**
     * Get Payee_Alternate_Name value
     * @return string|null
     */
    public function getPayee_Alternate_Name()
    {
        return $this->Payee_Alternate_Name;
    }
    /**
     * Set Payee_Alternate_Name value
     * @param string $payee_Alternate_Name
     * @return \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType
     */
    public function setPayee_Alternate_Name($payee_Alternate_Name = null)
    {
        // validation for constraint: string
        if (!is_null($payee_Alternate_Name) && !is_string($payee_Alternate_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payee_Alternate_Name, true), gettype($payee_Alternate_Name)), __LINE__);
        }
        $this->Payee_Alternate_Name = $payee_Alternate_Name;
        return $this;
    }
    /**
     * Get Alternate_Name_Usage_Reference value
     * @return \StructType\Alternate_Name_UsageObjectType[]|null
     */
    public function getAlternate_Name_Usage_Reference()
    {
        return $this->Alternate_Name_Usage_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Name_Usage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Name_Usage_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Name_Usage_ReferenceForArrayConstraintsFromSetAlternate_Name_Usage_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $remit_To_Supplier_Connection_Payee_Alternate_NameTypeAlternate_Name_Usage_ReferenceItem) {
            // validation for constraint: itemType
            if (!$remit_To_Supplier_Connection_Payee_Alternate_NameTypeAlternate_Name_Usage_ReferenceItem instanceof \StructType\Alternate_Name_UsageObjectType) {
                $invalidValues[] = is_object($remit_To_Supplier_Connection_Payee_Alternate_NameTypeAlternate_Name_Usage_ReferenceItem) ? get_class($remit_To_Supplier_Connection_Payee_Alternate_NameTypeAlternate_Name_Usage_ReferenceItem) : sprintf('%s(%s)', gettype($remit_To_Supplier_Connection_Payee_Alternate_NameTypeAlternate_Name_Usage_ReferenceItem), var_export($remit_To_Supplier_Connection_Payee_Alternate_NameTypeAlternate_Name_Usage_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Name_Usage_Reference property can only contain items of type \StructType\Alternate_Name_UsageObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Name_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Name_UsageObjectType[] $alternate_Name_Usage_Reference
     * @return \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType
     */
    public function setAlternate_Name_Usage_Reference(array $alternate_Name_Usage_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Name_Usage_ReferenceArrayErrorMessage = self::validateAlternate_Name_Usage_ReferenceForArrayConstraintsFromSetAlternate_Name_Usage_Reference($alternate_Name_Usage_Reference))) {
            throw new \InvalidArgumentException($alternate_Name_Usage_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Name_Usage_Reference = $alternate_Name_Usage_Reference;
        return $this;
    }
    /**
     * Add item to Alternate_Name_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Name_UsageObjectType $item
     * @return \StructType\Remit_To_Supplier_Connection_Payee_Alternate_NameType
     */
    public function addToAlternate_Name_Usage_Reference(\StructType\Alternate_Name_UsageObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Name_UsageObjectType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Name_Usage_Reference property can only contain items of type \StructType\Alternate_Name_UsageObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Name_Usage_Reference[] = $item;
        return $this;
    }
}
