<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Award_Contract_Defaults_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures Contract Defaults at the time of creating a RFQ Award Document.
 * @subpackage Structs
 */
class RFQ_Award_Contract_Defaults_Data_InboundType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Type for RFQ Award Contract Defaults
     * @var \StructType\Supplier_Contract_TypeObjectType
     */
    public $Supplier_Contract_Type_Reference;
    /**
     * The Contract_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract Start Date for RFQ Award Contract Defaults
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Start_Date;
    /**
     * The Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date for RFQ Award Contract Defaults
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date;
    /**
     * The Contract_Name
     * Meta information extracted from the WSDL
     * - documentation: Contract Name for RFQ Award Contract Defaults
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Name;
    /**
     * The Contract_Specialist_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contract Specialist for RFQ Award Contract Defaults
     * @var \StructType\WorkerObjectType
     */
    public $Contract_Specialist_Reference;
    /**
     * The Ship_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Ship-to Contact for RFQ Award Contract Defaults
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Contact;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ship-to Address for RFQ Award Contract Defaults
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Bill_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Bill-to Contact for RFQ Award Contract Defaults
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_To_Contact;
    /**
     * The Bill_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bill-to Address for RFQ Award Contract Defaults
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Bill_To_Address_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Terms for RFQ Award Contract Defaults
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: PO Issue Option for RFQ Award Contract Defaults
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Issue_Option_Reference;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Buyer for RFQ Award Contract Defaults
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Buyer_Reference;
    /**
     * Constructor method for RFQ_Award_Contract_Defaults_Data_InboundType
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setSupplier_Contract_Type_Reference()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setContract_Start_Date()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setContract_End_Date()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setContract_Name()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setContract_Specialist_Reference()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setShip_To_Contact()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setShip_To_Address_Reference()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setBill_To_Contact()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setBill_To_Address_Reference()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setPayment_Terms_Reference()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setIssue_Option_Reference()
     * @uses RFQ_Award_Contract_Defaults_Data_InboundType::setBuyer_Reference()
     * @param \StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference
     * @param string $contract_Start_Date
     * @param string $contract_End_Date
     * @param string $contract_Name
     * @param \StructType\WorkerObjectType $contract_Specialist_Reference
     * @param string $ship_To_Contact
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param string $bill_To_Contact
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @param \StructType\WorkerObjectType $buyer_Reference
     */
    public function __construct(\StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference = null, $contract_Start_Date = null, $contract_End_Date = null, $contract_Name = null, \StructType\WorkerObjectType $contract_Specialist_Reference = null, $ship_To_Contact = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, $bill_To_Contact = null, \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null, \StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this
            ->setSupplier_Contract_Type_Reference($supplier_Contract_Type_Reference)
            ->setContract_Start_Date($contract_Start_Date)
            ->setContract_End_Date($contract_End_Date)
            ->setContract_Name($contract_Name)
            ->setContract_Specialist_Reference($contract_Specialist_Reference)
            ->setShip_To_Contact($ship_To_Contact)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setBill_To_Contact($bill_To_Contact)
            ->setBill_To_Address_Reference($bill_To_Address_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setIssue_Option_Reference($issue_Option_Reference)
            ->setBuyer_Reference($buyer_Reference);
    }
    /**
     * Get Supplier_Contract_Type_Reference value
     * @return \StructType\Supplier_Contract_TypeObjectType|null
     */
    public function getSupplier_Contract_Type_Reference()
    {
        return $this->Supplier_Contract_Type_Reference;
    }
    /**
     * Set Supplier_Contract_Type_Reference value
     * @param \StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setSupplier_Contract_Type_Reference(\StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference = null)
    {
        $this->Supplier_Contract_Type_Reference = $supplier_Contract_Type_Reference;
        return $this;
    }
    /**
     * Get Contract_Start_Date value
     * @return string|null
     */
    public function getContract_Start_Date()
    {
        return $this->Contract_Start_Date;
    }
    /**
     * Set Contract_Start_Date value
     * @param string $contract_Start_Date
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setContract_Start_Date($contract_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date) && !is_string($contract_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date, true), gettype($contract_Start_Date)), __LINE__);
        }
        $this->Contract_Start_Date = $contract_Start_Date;
        return $this;
    }
    /**
     * Get Contract_End_Date value
     * @return string|null
     */
    public function getContract_End_Date()
    {
        return $this->Contract_End_Date;
    }
    /**
     * Set Contract_End_Date value
     * @param string $contract_End_Date
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setContract_End_Date($contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date) && !is_string($contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date, true), gettype($contract_End_Date)), __LINE__);
        }
        $this->Contract_End_Date = $contract_End_Date;
        return $this;
    }
    /**
     * Get Contract_Name value
     * @return string|null
     */
    public function getContract_Name()
    {
        return $this->Contract_Name;
    }
    /**
     * Set Contract_Name value
     * @param string $contract_Name
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setContract_Name($contract_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Name) && !is_string($contract_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Name, true), gettype($contract_Name)), __LINE__);
        }
        $this->Contract_Name = $contract_Name;
        return $this;
    }
    /**
     * Get Contract_Specialist_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getContract_Specialist_Reference()
    {
        return $this->Contract_Specialist_Reference;
    }
    /**
     * Set Contract_Specialist_Reference value
     * @param \StructType\WorkerObjectType $contract_Specialist_Reference
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setContract_Specialist_Reference(\StructType\WorkerObjectType $contract_Specialist_Reference = null)
    {
        $this->Contract_Specialist_Reference = $contract_Specialist_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact value
     * @return string|null
     */
    public function getShip_To_Contact()
    {
        return $this->{'Ship-To_Contact'};
    }
    /**
     * Set Ship_To_Contact value
     * @param string $ship_To_Contact
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setShip_To_Contact($ship_To_Contact = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Contact) && !is_string($ship_To_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Contact, true), gettype($ship_To_Contact)), __LINE__);
        }
        $this->Ship_To_Contact = $this->{'Ship-To_Contact'} = $ship_To_Contact;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact value
     * @return string|null
     */
    public function getBill_To_Contact()
    {
        return $this->{'Bill-To_Contact'};
    }
    /**
     * Set Bill_To_Contact value
     * @param string $bill_To_Contact
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setBill_To_Contact($bill_To_Contact = null)
    {
        // validation for constraint: string
        if (!is_null($bill_To_Contact) && !is_string($bill_To_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_To_Contact, true), gettype($bill_To_Contact)), __LINE__);
        }
        $this->Bill_To_Contact = $this->{'Bill-To_Contact'} = $bill_To_Contact;
        return $this;
    }
    /**
     * Get Bill_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getBill_To_Address_Reference()
    {
        return $this->Bill_To_Address_Reference;
    }
    /**
     * Set Bill_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setBill_To_Address_Reference(\StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null)
    {
        $this->Bill_To_Address_Reference = $bill_To_Address_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getIssue_Option_Reference()
    {
        return $this->Issue_Option_Reference;
    }
    /**
     * Set Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setIssue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null)
    {
        $this->Issue_Option_Reference = $issue_Option_Reference;
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * Set Buyer_Reference value
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @return \StructType\RFQ_Award_Contract_Defaults_Data_InboundType
     */
    public function setBuyer_Reference(\StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
}
