<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project-Based_Order_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Requisition Line referenced is from a Requisition that is Closed or Pending Close. | Only one worktag for each type is allowed for each document line. | Element containing Project-Based Order Line data. A Purchase Order may have
 * multiple Project-Based order lines.
 * @subpackage Structs
 */
class Project_Based_Order_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Deliverables_Order_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliverables_Order_Line_ID;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company of the Purchase Order Line.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project.
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: An optional reference to an existing Supplier Contract Line in the Workday system. This is used to link the Project-Based Order Line with a Supplier Contract Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Receiving_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receiving Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Receiving_Status_Reference;
    /**
     * The Payment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_Payment_StatusObjectType
     */
    public $Payment_Status_Reference;
    /**
     * The Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Status_Reference;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: Prepaid flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Retention
     * Meta information extracted from the WSDL
     * - documentation: Retention flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retention;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on a purchase order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Purchase Order Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Requisition_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Requisition Line sourced to the Purchase Order Line. This field is READ ONLY.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_LineObjectType[]
     */
    public $Requisition_Line_Reference;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category.
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Project_Phase_Data
     * Meta information extracted from the WSDL
     * - documentation: Element Containing Project Plan Phase Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Phase_PO_DataType[]
     */
    public $Project_Phase_Data;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: This field is only enabled for Companies and Tenants which are Opted-In to Consolidate Requisition Lines by Supplier regardless of Supplier Contract.Use this field to assign a specific Supplier Contract to this Spend Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Deliverables_Purchase_Order_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Deliverables_Purchase_Order_Line_Split_Data;
    /**
     * The Close_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The status of a closed purchase order line. This field is read-only and ignored when you submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Close_Status_Reference;
    /**
     * The Close_Status_Information
     * Meta information extracted from the WSDL
     * - documentation: Additional information on the status of the closed purchase order (PO) line. Includes information such as the date the PO line was closed, who closed the line, and the reason it was closed. This field is read-only and ignored when
     * you submit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Close_Status_InformationType[]
     */
    public $Close_Status_Information;
    /**
     * Constructor method for Project-Based_Order_Line_Replacement_DataType
     * @uses Project_Based_Order_Line_Replacement_DataType::setDeliverables_Order_Line_ID()
     * @uses Project_Based_Order_Line_Replacement_DataType::setLine_Number()
     * @uses Project_Based_Order_Line_Replacement_DataType::setLine_Company_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setProject_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setSupplier_Contract_Line_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setReceiving_Status_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setPayment_Status_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setInvoice_Status_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setPrepaid()
     * @uses Project_Based_Order_Line_Replacement_DataType::setRetention()
     * @uses Project_Based_Order_Line_Replacement_DataType::setBudget_Date()
     * @uses Project_Based_Order_Line_Replacement_DataType::setMemo()
     * @uses Project_Based_Order_Line_Replacement_DataType::setRequisition_Line_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setResource_Category_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setProject_Phase_Data()
     * @uses Project_Based_Order_Line_Replacement_DataType::setExtended_Amount()
     * @uses Project_Based_Order_Line_Replacement_DataType::setWorktags_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setSupplier_Contract_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setDeliverables_Purchase_Order_Line_Split_Data()
     * @uses Project_Based_Order_Line_Replacement_DataType::setClose_Status_Reference()
     * @uses Project_Based_Order_Line_Replacement_DataType::setClose_Status_Information()
     * @param string $deliverables_Order_Line_ID
     * @param float $line_Number
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @param bool $prepaid
     * @param bool $retention
     * @param string $budget_Date
     * @param string $memo
     * @param \StructType\Requisition_LineObjectType[] $requisition_Line_Reference
     * @param \StructType\Accounting_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Project_Plan_Phase_PO_DataType[] $project_Phase_Data
     * @param float $extended_Amount
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Business_Document_Line_Split_DataType[] $deliverables_Purchase_Order_Line_Split_Data
     * @param \StructType\Document_StatusObjectType $close_Status_Reference
     * @param \StructType\Close_Status_InformationType[] $close_Status_Information
     */
    public function __construct($deliverables_Order_Line_ID = null, $line_Number = null, \StructType\CompanyObjectType $line_Company_Reference = null, \StructType\ProjectObjectType $project_Reference = null, \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null, \StructType\Document_StatusObjectType $receiving_Status_Reference = null, \StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null, \StructType\Document_StatusObjectType $invoice_Status_Reference = null, $prepaid = null, $retention = null, $budget_Date = null, $memo = null, array $requisition_Line_Reference = array(), \StructType\Accounting_CategoryObjectType $resource_Category_Reference = null, array $project_Phase_Data = array(), $extended_Amount = null, array $worktags_Reference = array(), \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $deliverables_Purchase_Order_Line_Split_Data = array(), \StructType\Document_StatusObjectType $close_Status_Reference = null, array $close_Status_Information = array())
    {
        $this
            ->setDeliverables_Order_Line_ID($deliverables_Order_Line_ID)
            ->setLine_Number($line_Number)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setProject_Reference($project_Reference)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setReceiving_Status_Reference($receiving_Status_Reference)
            ->setPayment_Status_Reference($payment_Status_Reference)
            ->setInvoice_Status_Reference($invoice_Status_Reference)
            ->setPrepaid($prepaid)
            ->setRetention($retention)
            ->setBudget_Date($budget_Date)
            ->setMemo($memo)
            ->setRequisition_Line_Reference($requisition_Line_Reference)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setProject_Phase_Data($project_Phase_Data)
            ->setExtended_Amount($extended_Amount)
            ->setWorktags_Reference($worktags_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setDeliverables_Purchase_Order_Line_Split_Data($deliverables_Purchase_Order_Line_Split_Data)
            ->setClose_Status_Reference($close_Status_Reference)
            ->setClose_Status_Information($close_Status_Information);
    }
    /**
     * Get Deliverables_Order_Line_ID value
     * @return string|null
     */
    public function getDeliverables_Order_Line_ID()
    {
        return $this->Deliverables_Order_Line_ID;
    }
    /**
     * Set Deliverables_Order_Line_ID value
     * @param string $deliverables_Order_Line_ID
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setDeliverables_Order_Line_ID($deliverables_Order_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($deliverables_Order_Line_ID) && !is_string($deliverables_Order_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverables_Order_Line_ID, true), gettype($deliverables_Order_Line_ID)), __LINE__);
        }
        $this->Deliverables_Order_Line_ID = $deliverables_Order_Line_ID;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Receiving_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getReceiving_Status_Reference()
    {
        return $this->Receiving_Status_Reference;
    }
    /**
     * Set Receiving_Status_Reference value
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setReceiving_Status_Reference(\StructType\Document_StatusObjectType $receiving_Status_Reference = null)
    {
        $this->Receiving_Status_Reference = $receiving_Status_Reference;
        return $this;
    }
    /**
     * Get Payment_Status_Reference value
     * @return \StructType\Document_Payment_StatusObjectType|null
     */
    public function getPayment_Status_Reference()
    {
        return $this->Payment_Status_Reference;
    }
    /**
     * Set Payment_Status_Reference value
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setPayment_Status_Reference(\StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null)
    {
        $this->Payment_Status_Reference = $payment_Status_Reference;
        return $this;
    }
    /**
     * Get Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Status_Reference()
    {
        return $this->Invoice_Status_Reference;
    }
    /**
     * Set Invoice_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setInvoice_Status_Reference(\StructType\Document_StatusObjectType $invoice_Status_Reference = null)
    {
        $this->Invoice_Status_Reference = $invoice_Status_Reference;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Retention value
     * @return bool|null
     */
    public function getRetention()
    {
        return $this->Retention;
    }
    /**
     * Set Retention value
     * @param bool $retention
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setRetention($retention = null)
    {
        // validation for constraint: boolean
        if (!is_null($retention) && !is_bool($retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retention, true), gettype($retention)), __LINE__);
        }
        $this->Retention = $retention;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Requisition_Line_Reference value
     * @return \StructType\Requisition_LineObjectType[]|null
     */
    public function getRequisition_Line_Reference()
    {
        return $this->Requisition_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Line_ReferenceForArrayConstraintsFromSetRequisition_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Order_Line_Replacement_DataTypeRequisition_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Based_Order_Line_Replacement_DataTypeRequisition_Line_ReferenceItem instanceof \StructType\Requisition_LineObjectType) {
                $invalidValues[] = is_object($project_Based_Order_Line_Replacement_DataTypeRequisition_Line_ReferenceItem) ? get_class($project_Based_Order_Line_Replacement_DataTypeRequisition_Line_ReferenceItem) : sprintf('%s(%s)', gettype($project_Based_Order_Line_Replacement_DataTypeRequisition_Line_ReferenceItem), var_export($project_Based_Order_Line_Replacement_DataTypeRequisition_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Line_Reference property can only contain items of type \StructType\Requisition_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_LineObjectType[] $requisition_Line_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setRequisition_Line_Reference(array $requisition_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Line_ReferenceArrayErrorMessage = self::validateRequisition_Line_ReferenceForArrayConstraintsFromSetRequisition_Line_Reference($requisition_Line_Reference))) {
            throw new \InvalidArgumentException($requisition_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Line_Reference = $requisition_Line_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_LineObjectType $item
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function addToRequisition_Line_Reference(\StructType\Requisition_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Line_Reference property can only contain items of type \StructType\Requisition_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Line_Reference[] = $item;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setResource_Category_Reference(\StructType\Accounting_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Project_Phase_Data value
     * @return \StructType\Project_Plan_Phase_PO_DataType[]|null
     */
    public function getProject_Phase_Data()
    {
        return $this->Project_Phase_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Phase_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Phase_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Phase_DataForArrayConstraintsFromSetProject_Phase_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Order_Line_Replacement_DataTypeProject_Phase_DataItem) {
            // validation for constraint: itemType
            if (!$project_Based_Order_Line_Replacement_DataTypeProject_Phase_DataItem instanceof \StructType\Project_Plan_Phase_PO_DataType) {
                $invalidValues[] = is_object($project_Based_Order_Line_Replacement_DataTypeProject_Phase_DataItem) ? get_class($project_Based_Order_Line_Replacement_DataTypeProject_Phase_DataItem) : sprintf('%s(%s)', gettype($project_Based_Order_Line_Replacement_DataTypeProject_Phase_DataItem), var_export($project_Based_Order_Line_Replacement_DataTypeProject_Phase_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Phase_Data property can only contain items of type \StructType\Project_Plan_Phase_PO_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_PO_DataType[] $project_Phase_Data
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setProject_Phase_Data(array $project_Phase_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Phase_DataArrayErrorMessage = self::validateProject_Phase_DataForArrayConstraintsFromSetProject_Phase_Data($project_Phase_Data))) {
            throw new \InvalidArgumentException($project_Phase_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Phase_Data = $project_Phase_Data;
        return $this;
    }
    /**
     * Add item to Project_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_PO_DataType $item
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function addToProject_Phase_Data(\StructType\Project_Plan_Phase_PO_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Phase_PO_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Phase_Data property can only contain items of type \StructType\Project_Plan_Phase_PO_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Phase_Data[] = $item;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Based_Order_Line_Replacement_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($project_Based_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) ? get_class($project_Based_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($project_Based_Order_Line_Replacement_DataTypeWorktags_ReferenceItem), var_export($project_Based_Order_Line_Replacement_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Deliverables_Purchase_Order_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getDeliverables_Purchase_Order_Line_Split_Data()
    {
        return $this->Deliverables_Purchase_Order_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliverables_Purchase_Order_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliverables_Purchase_Order_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliverables_Purchase_Order_Line_Split_DataForArrayConstraintsFromSetDeliverables_Purchase_Order_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Order_Line_Replacement_DataTypeDeliverables_Purchase_Order_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$project_Based_Order_Line_Replacement_DataTypeDeliverables_Purchase_Order_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($project_Based_Order_Line_Replacement_DataTypeDeliverables_Purchase_Order_Line_Split_DataItem) ? get_class($project_Based_Order_Line_Replacement_DataTypeDeliverables_Purchase_Order_Line_Split_DataItem) : sprintf('%s(%s)', gettype($project_Based_Order_Line_Replacement_DataTypeDeliverables_Purchase_Order_Line_Split_DataItem), var_export($project_Based_Order_Line_Replacement_DataTypeDeliverables_Purchase_Order_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deliverables_Purchase_Order_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deliverables_Purchase_Order_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $deliverables_Purchase_Order_Line_Split_Data
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setDeliverables_Purchase_Order_Line_Split_Data(array $deliverables_Purchase_Order_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($deliverables_Purchase_Order_Line_Split_DataArrayErrorMessage = self::validateDeliverables_Purchase_Order_Line_Split_DataForArrayConstraintsFromSetDeliverables_Purchase_Order_Line_Split_Data($deliverables_Purchase_Order_Line_Split_Data))) {
            throw new \InvalidArgumentException($deliverables_Purchase_Order_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Deliverables_Purchase_Order_Line_Split_Data = $deliverables_Purchase_Order_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Deliverables_Purchase_Order_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function addToDeliverables_Purchase_Order_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Deliverables_Purchase_Order_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Deliverables_Purchase_Order_Line_Split_Data[] = $item;
        return $this;
    }
    /**
     * Get Close_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getClose_Status_Reference()
    {
        return $this->Close_Status_Reference;
    }
    /**
     * Set Close_Status_Reference value
     * @param \StructType\Document_StatusObjectType $close_Status_Reference
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setClose_Status_Reference(\StructType\Document_StatusObjectType $close_Status_Reference = null)
    {
        $this->Close_Status_Reference = $close_Status_Reference;
        return $this;
    }
    /**
     * Get Close_Status_Information value
     * @return \StructType\Close_Status_InformationType[]|null
     */
    public function getClose_Status_Information()
    {
        return $this->Close_Status_Information;
    }
    /**
     * This method is responsible for validating the values passed to the setClose_Status_Information method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClose_Status_Information method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClose_Status_InformationForArrayConstraintsFromSetClose_Status_Information(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Order_Line_Replacement_DataTypeClose_Status_InformationItem) {
            // validation for constraint: itemType
            if (!$project_Based_Order_Line_Replacement_DataTypeClose_Status_InformationItem instanceof \StructType\Close_Status_InformationType) {
                $invalidValues[] = is_object($project_Based_Order_Line_Replacement_DataTypeClose_Status_InformationItem) ? get_class($project_Based_Order_Line_Replacement_DataTypeClose_Status_InformationItem) : sprintf('%s(%s)', gettype($project_Based_Order_Line_Replacement_DataTypeClose_Status_InformationItem), var_export($project_Based_Order_Line_Replacement_DataTypeClose_Status_InformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Close_Status_Information property can only contain items of type \StructType\Close_Status_InformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Close_Status_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Close_Status_InformationType[] $close_Status_Information
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function setClose_Status_Information(array $close_Status_Information = array())
    {
        // validation for constraint: array
        if ('' !== ($close_Status_InformationArrayErrorMessage = self::validateClose_Status_InformationForArrayConstraintsFromSetClose_Status_Information($close_Status_Information))) {
            throw new \InvalidArgumentException($close_Status_InformationArrayErrorMessage, __LINE__);
        }
        $this->Close_Status_Information = $close_Status_Information;
        return $this;
    }
    /**
     * Add item to Close_Status_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Close_Status_InformationType $item
     * @return \StructType\Project_Based_Order_Line_Replacement_DataType
     */
    public function addToClose_Status_Information(\StructType\Close_Status_InformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Close_Status_InformationType) {
            throw new \InvalidArgumentException(sprintf('The Close_Status_Information property can only contain items of type \StructType\Close_Status_InformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Close_Status_Information[] = $item;
        return $this;
    }
}
