<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airline_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Spend Data instances of the same Data Value and Attribute Type is not allowed. | Contains Airline Data
 * @subpackage Structs
 */
class Airline_DataType extends AbstractStructBase
{
    /**
     * The Spend_Data_ID
     * Meta information extracted from the WSDL
     * - documentation: Airline Reference ID. Uniquely identifies an Airline.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Data_ID;
    /**
     * The Airline_Value
     * Meta information extracted from the WSDL
     * - documentation: Airline Value. The text description (title) of an airline.
     * - maxOccurs: 1
     * @var string
     */
    public $Airline_Value;
    /**
     * The Merchant_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Each Merchant Code can only be assigned to one Merchant (Airline, Hotel, or Car Rental Agency). | A Merchant Code to map to this Airline. If a Merchant Code is specified, it will be used on Expense Credit Card Transactions to match
     * the specified Merchant Code to this Airline.
     * - minOccurs: 0
     * @var \StructType\Merchant_CodeObjectType
     */
    public $Merchant_Code_Reference;
    /**
     * The Alternate_Merchant_Name_Data
     * Meta information extracted from the WSDL
     * - documentation: Alternate Names for Merchant are entered here.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Merchant_Name_DataType[]
     */
    public $Alternate_Merchant_Name_Data;
    /**
     * Constructor method for Airline_DataType
     * @uses Airline_DataType::setSpend_Data_ID()
     * @uses Airline_DataType::setAirline_Value()
     * @uses Airline_DataType::setMerchant_Code_Reference()
     * @uses Airline_DataType::setAlternate_Merchant_Name_Data()
     * @param string $spend_Data_ID
     * @param string $airline_Value
     * @param \StructType\Merchant_CodeObjectType $merchant_Code_Reference
     * @param \StructType\Alternate_Merchant_Name_DataType[] $alternate_Merchant_Name_Data
     */
    public function __construct($spend_Data_ID = null, $airline_Value = null, \StructType\Merchant_CodeObjectType $merchant_Code_Reference = null, array $alternate_Merchant_Name_Data = array())
    {
        $this
            ->setSpend_Data_ID($spend_Data_ID)
            ->setAirline_Value($airline_Value)
            ->setMerchant_Code_Reference($merchant_Code_Reference)
            ->setAlternate_Merchant_Name_Data($alternate_Merchant_Name_Data);
    }
    /**
     * Get Spend_Data_ID value
     * @return string|null
     */
    public function getSpend_Data_ID()
    {
        return $this->Spend_Data_ID;
    }
    /**
     * Set Spend_Data_ID value
     * @param string $spend_Data_ID
     * @return \StructType\Airline_DataType
     */
    public function setSpend_Data_ID($spend_Data_ID = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Data_ID) && !is_string($spend_Data_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Data_ID, true), gettype($spend_Data_ID)), __LINE__);
        }
        $this->Spend_Data_ID = $spend_Data_ID;
        return $this;
    }
    /**
     * Get Airline_Value value
     * @return string|null
     */
    public function getAirline_Value()
    {
        return $this->Airline_Value;
    }
    /**
     * Set Airline_Value value
     * @param string $airline_Value
     * @return \StructType\Airline_DataType
     */
    public function setAirline_Value($airline_Value = null)
    {
        // validation for constraint: string
        if (!is_null($airline_Value) && !is_string($airline_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airline_Value, true), gettype($airline_Value)), __LINE__);
        }
        $this->Airline_Value = $airline_Value;
        return $this;
    }
    /**
     * Get Merchant_Code_Reference value
     * @return \StructType\Merchant_CodeObjectType|null
     */
    public function getMerchant_Code_Reference()
    {
        return $this->Merchant_Code_Reference;
    }
    /**
     * Set Merchant_Code_Reference value
     * @param \StructType\Merchant_CodeObjectType $merchant_Code_Reference
     * @return \StructType\Airline_DataType
     */
    public function setMerchant_Code_Reference(\StructType\Merchant_CodeObjectType $merchant_Code_Reference = null)
    {
        $this->Merchant_Code_Reference = $merchant_Code_Reference;
        return $this;
    }
    /**
     * Get Alternate_Merchant_Name_Data value
     * @return \StructType\Alternate_Merchant_Name_DataType[]|null
     */
    public function getAlternate_Merchant_Name_Data()
    {
        return $this->Alternate_Merchant_Name_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Merchant_Name_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Merchant_Name_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Merchant_Name_DataForArrayConstraintsFromSetAlternate_Merchant_Name_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airline_DataTypeAlternate_Merchant_Name_DataItem) {
            // validation for constraint: itemType
            if (!$airline_DataTypeAlternate_Merchant_Name_DataItem instanceof \StructType\Alternate_Merchant_Name_DataType) {
                $invalidValues[] = is_object($airline_DataTypeAlternate_Merchant_Name_DataItem) ? get_class($airline_DataTypeAlternate_Merchant_Name_DataItem) : sprintf('%s(%s)', gettype($airline_DataTypeAlternate_Merchant_Name_DataItem), var_export($airline_DataTypeAlternate_Merchant_Name_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Merchant_Name_Data property can only contain items of type \StructType\Alternate_Merchant_Name_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Merchant_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Merchant_Name_DataType[] $alternate_Merchant_Name_Data
     * @return \StructType\Airline_DataType
     */
    public function setAlternate_Merchant_Name_Data(array $alternate_Merchant_Name_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Merchant_Name_DataArrayErrorMessage = self::validateAlternate_Merchant_Name_DataForArrayConstraintsFromSetAlternate_Merchant_Name_Data($alternate_Merchant_Name_Data))) {
            throw new \InvalidArgumentException($alternate_Merchant_Name_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Merchant_Name_Data = $alternate_Merchant_Name_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Merchant_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Merchant_Name_DataType $item
     * @return \StructType\Airline_DataType
     */
    public function addToAlternate_Merchant_Name_Data(\StructType\Alternate_Merchant_Name_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Merchant_Name_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Merchant_Name_Data property can only contain items of type \StructType\Alternate_Merchant_Name_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Merchant_Name_Data[] = $item;
        return $this;
    }
}
