<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_City_Alternate_Name_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to specify alternate names.
 * @subpackage Structs
 */
class Travel_City_Alternate_Name_DataType extends AbstractStructBase
{
    /**
     * The Spend_Data_Alternate_Name_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Alternate Name of Travel City.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Spend_Data_Alternate_Name_Reference;
    /**
     * The Alternate_Name
     * Meta information extracted from the WSDL
     * - documentation: Travel city alternate name.
     * - maxOccurs: 1
     * @var string
     */
    public $Alternate_Name;
    /**
     * Constructor method for Travel_City_Alternate_Name_DataType
     * @uses Travel_City_Alternate_Name_DataType::setSpend_Data_Alternate_Name_Reference()
     * @uses Travel_City_Alternate_Name_DataType::setAlternate_Name()
     * @param \StructType\Unique_IdentifierObjectType $spend_Data_Alternate_Name_Reference
     * @param string $alternate_Name
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $spend_Data_Alternate_Name_Reference = null, $alternate_Name = null)
    {
        $this
            ->setSpend_Data_Alternate_Name_Reference($spend_Data_Alternate_Name_Reference)
            ->setAlternate_Name($alternate_Name);
    }
    /**
     * Get Spend_Data_Alternate_Name_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getSpend_Data_Alternate_Name_Reference()
    {
        return $this->Spend_Data_Alternate_Name_Reference;
    }
    /**
     * Set Spend_Data_Alternate_Name_Reference value
     * @param \StructType\Unique_IdentifierObjectType $spend_Data_Alternate_Name_Reference
     * @return \StructType\Travel_City_Alternate_Name_DataType
     */
    public function setSpend_Data_Alternate_Name_Reference(\StructType\Unique_IdentifierObjectType $spend_Data_Alternate_Name_Reference = null)
    {
        $this->Spend_Data_Alternate_Name_Reference = $spend_Data_Alternate_Name_Reference;
        return $this;
    }
    /**
     * Get Alternate_Name value
     * @return string|null
     */
    public function getAlternate_Name()
    {
        return $this->Alternate_Name;
    }
    /**
     * Set Alternate_Name value
     * @param string $alternate_Name
     * @return \StructType\Travel_City_Alternate_Name_DataType
     */
    public function setAlternate_Name($alternate_Name = null)
    {
        // validation for constraint: string
        if (!is_null($alternate_Name) && !is_string($alternate_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternate_Name, true), gettype($alternate_Name)), __LINE__);
        }
        $this->Alternate_Name = $alternate_Name;
        return $this;
    }
}
