<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Budget_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Budget Template Data Details
 * @subpackage Structs
 */
class Project_Budget_Template_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The Project Budget Template being processed
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Enter a unique Project Budget Template name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Plan_Structure_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Plan Structure that this Project Budget Template is based on. This will determine which budget dimensions may be used.
     * - minOccurs: 0
     * @var \StructType\Budget_StructureObjectType
     */
    public $Plan_Structure_Reference;
    /**
     * The Override_Template_with_Related_Worktags_from_Project
     * Meta information extracted from the WSDL
     * - documentation: Select to override the values in the template with project-related worktags when you create plan lines.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Override_Template_with_Related_Worktags_from_Project;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Set to True to inactivate this Project Budget Template
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Project_Budget_Template_Lines
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Budget_Template_Line_DataType[]
     */
    public $Project_Budget_Template_Lines;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: Selecting this will cause all existing lines for this Project Budget Template to be replaced with the lines defined here.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Project_Budget_Template_DataType
     * @uses Project_Budget_Template_DataType::setID()
     * @uses Project_Budget_Template_DataType::setName()
     * @uses Project_Budget_Template_DataType::setPlan_Structure_Reference()
     * @uses Project_Budget_Template_DataType::setOverride_Template_with_Related_Worktags_from_Project()
     * @uses Project_Budget_Template_DataType::setInactive()
     * @uses Project_Budget_Template_DataType::setProject_Budget_Template_Lines()
     * @uses Project_Budget_Template_DataType::setReplace_All()
     * @param string $iD
     * @param string $name
     * @param \StructType\Budget_StructureObjectType $plan_Structure_Reference
     * @param bool $override_Template_with_Related_Worktags_from_Project
     * @param bool $inactive
     * @param \StructType\Project_Budget_Template_Line_DataType[] $project_Budget_Template_Lines
     * @param bool $replace_All
     */
    public function __construct($iD = null, $name = null, \StructType\Budget_StructureObjectType $plan_Structure_Reference = null, $override_Template_with_Related_Worktags_from_Project = null, $inactive = null, array $project_Budget_Template_Lines = array(), $replace_All = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setPlan_Structure_Reference($plan_Structure_Reference)
            ->setOverride_Template_with_Related_Worktags_from_Project($override_Template_with_Related_Worktags_from_Project)
            ->setInactive($inactive)
            ->setProject_Budget_Template_Lines($project_Budget_Template_Lines)
            ->setReplace_All($replace_All);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Plan_Structure_Reference value
     * @return \StructType\Budget_StructureObjectType|null
     */
    public function getPlan_Structure_Reference()
    {
        return $this->Plan_Structure_Reference;
    }
    /**
     * Set Plan_Structure_Reference value
     * @param \StructType\Budget_StructureObjectType $plan_Structure_Reference
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function setPlan_Structure_Reference(\StructType\Budget_StructureObjectType $plan_Structure_Reference = null)
    {
        $this->Plan_Structure_Reference = $plan_Structure_Reference;
        return $this;
    }
    /**
     * Get Override_Template_with_Related_Worktags_from_Project value
     * @return bool|null
     */
    public function getOverride_Template_with_Related_Worktags_from_Project()
    {
        return $this->Override_Template_with_Related_Worktags_from_Project;
    }
    /**
     * Set Override_Template_with_Related_Worktags_from_Project value
     * @param bool $override_Template_with_Related_Worktags_from_Project
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function setOverride_Template_with_Related_Worktags_from_Project($override_Template_with_Related_Worktags_from_Project = null)
    {
        // validation for constraint: boolean
        if (!is_null($override_Template_with_Related_Worktags_from_Project) && !is_bool($override_Template_with_Related_Worktags_from_Project)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($override_Template_with_Related_Worktags_from_Project, true), gettype($override_Template_with_Related_Worktags_from_Project)), __LINE__);
        }
        $this->Override_Template_with_Related_Worktags_from_Project = $override_Template_with_Related_Worktags_from_Project;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Project_Budget_Template_Lines value
     * @return \StructType\Project_Budget_Template_Line_DataType[]|null
     */
    public function getProject_Budget_Template_Lines()
    {
        return $this->Project_Budget_Template_Lines;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Budget_Template_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Budget_Template_Lines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Budget_Template_LinesForArrayConstraintsFromSetProject_Budget_Template_Lines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Budget_Template_DataTypeProject_Budget_Template_LinesItem) {
            // validation for constraint: itemType
            if (!$project_Budget_Template_DataTypeProject_Budget_Template_LinesItem instanceof \StructType\Project_Budget_Template_Line_DataType) {
                $invalidValues[] = is_object($project_Budget_Template_DataTypeProject_Budget_Template_LinesItem) ? get_class($project_Budget_Template_DataTypeProject_Budget_Template_LinesItem) : sprintf('%s(%s)', gettype($project_Budget_Template_DataTypeProject_Budget_Template_LinesItem), var_export($project_Budget_Template_DataTypeProject_Budget_Template_LinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Budget_Template_Lines property can only contain items of type \StructType\Project_Budget_Template_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Budget_Template_Lines value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Budget_Template_Line_DataType[] $project_Budget_Template_Lines
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function setProject_Budget_Template_Lines(array $project_Budget_Template_Lines = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Budget_Template_LinesArrayErrorMessage = self::validateProject_Budget_Template_LinesForArrayConstraintsFromSetProject_Budget_Template_Lines($project_Budget_Template_Lines))) {
            throw new \InvalidArgumentException($project_Budget_Template_LinesArrayErrorMessage, __LINE__);
        }
        $this->Project_Budget_Template_Lines = $project_Budget_Template_Lines;
        return $this;
    }
    /**
     * Add item to Project_Budget_Template_Lines value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Budget_Template_Line_DataType $item
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function addToProject_Budget_Template_Lines(\StructType\Project_Budget_Template_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Budget_Template_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Budget_Template_Lines property can only contain items of type \StructType\Project_Budget_Template_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Budget_Template_Lines[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Project_Budget_Template_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
