<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Car_Rental_AgencyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Car Rental Agency Reference and Car Rental Agency Data
 * @subpackage Structs
 */
class Car_Rental_AgencyType extends AbstractStructBase
{
    /**
     * The Car_Rental_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Car Rental Agency Reference
     * - minOccurs: 0
     * @var \StructType\Car_Rental_AgencyObjectType
     */
    public $Car_Rental_Agency_Reference;
    /**
     * The Car_Rental_Agency_Data
     * Meta information extracted from the WSDL
     * - documentation: Car Rental Agency Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Car_Rental_Agency_DataType[]
     */
    public $Car_Rental_Agency_Data;
    /**
     * Constructor method for Car_Rental_AgencyType
     * @uses Car_Rental_AgencyType::setCar_Rental_Agency_Reference()
     * @uses Car_Rental_AgencyType::setCar_Rental_Agency_Data()
     * @param \StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference
     * @param \StructType\Car_Rental_Agency_DataType[] $car_Rental_Agency_Data
     */
    public function __construct(\StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference = null, array $car_Rental_Agency_Data = array())
    {
        $this
            ->setCar_Rental_Agency_Reference($car_Rental_Agency_Reference)
            ->setCar_Rental_Agency_Data($car_Rental_Agency_Data);
    }
    /**
     * Get Car_Rental_Agency_Reference value
     * @return \StructType\Car_Rental_AgencyObjectType|null
     */
    public function getCar_Rental_Agency_Reference()
    {
        return $this->Car_Rental_Agency_Reference;
    }
    /**
     * Set Car_Rental_Agency_Reference value
     * @param \StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference
     * @return \StructType\Car_Rental_AgencyType
     */
    public function setCar_Rental_Agency_Reference(\StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference = null)
    {
        $this->Car_Rental_Agency_Reference = $car_Rental_Agency_Reference;
        return $this;
    }
    /**
     * Get Car_Rental_Agency_Data value
     * @return \StructType\Car_Rental_Agency_DataType[]|null
     */
    public function getCar_Rental_Agency_Data()
    {
        return $this->Car_Rental_Agency_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCar_Rental_Agency_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCar_Rental_Agency_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCar_Rental_Agency_DataForArrayConstraintsFromSetCar_Rental_Agency_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $car_Rental_AgencyTypeCar_Rental_Agency_DataItem) {
            // validation for constraint: itemType
            if (!$car_Rental_AgencyTypeCar_Rental_Agency_DataItem instanceof \StructType\Car_Rental_Agency_DataType) {
                $invalidValues[] = is_object($car_Rental_AgencyTypeCar_Rental_Agency_DataItem) ? get_class($car_Rental_AgencyTypeCar_Rental_Agency_DataItem) : sprintf('%s(%s)', gettype($car_Rental_AgencyTypeCar_Rental_Agency_DataItem), var_export($car_Rental_AgencyTypeCar_Rental_Agency_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Car_Rental_Agency_Data property can only contain items of type \StructType\Car_Rental_Agency_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Car_Rental_Agency_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_Agency_DataType[] $car_Rental_Agency_Data
     * @return \StructType\Car_Rental_AgencyType
     */
    public function setCar_Rental_Agency_Data(array $car_Rental_Agency_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($car_Rental_Agency_DataArrayErrorMessage = self::validateCar_Rental_Agency_DataForArrayConstraintsFromSetCar_Rental_Agency_Data($car_Rental_Agency_Data))) {
            throw new \InvalidArgumentException($car_Rental_Agency_DataArrayErrorMessage, __LINE__);
        }
        $this->Car_Rental_Agency_Data = $car_Rental_Agency_Data;
        return $this;
    }
    /**
     * Add item to Car_Rental_Agency_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_Agency_DataType $item
     * @return \StructType\Car_Rental_AgencyType
     */
    public function addToCar_Rental_Agency_Data(\StructType\Car_Rental_Agency_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Car_Rental_Agency_DataType) {
            throw new \InvalidArgumentException(sprintf('The Car_Rental_Agency_Data property can only contain items of type \StructType\Car_Rental_Agency_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Car_Rental_Agency_Data[] = $item;
        return $this;
    }
}
