<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Topmost element that captures a reference to a RFQ Award document along with its content
 * @subpackage Structs
 */
class Request_for_Quote_Award_Response_DataType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Award
     * Meta information extracted from the WSDL
     * - documentation: Element that holds RFQ Award Reference and and Request for Quote Award Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Award_OutboundType[]
     */
    public $Request_for_Quote_Award;
    /**
     * Constructor method for Request_for_Quote_Award_Response_DataType
     * @uses Request_for_Quote_Award_Response_DataType::setRequest_for_Quote_Award()
     * @param \StructType\Request_for_Quote_Award_OutboundType[] $request_for_Quote_Award
     */
    public function __construct(array $request_for_Quote_Award = array())
    {
        $this
            ->setRequest_for_Quote_Award($request_for_Quote_Award);
    }
    /**
     * Get Request_for_Quote_Award value
     * @return \StructType\Request_for_Quote_Award_OutboundType[]|null
     */
    public function getRequest_for_Quote_Award()
    {
        return $this->Request_for_Quote_Award;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Award method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Award method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_AwardForArrayConstraintsFromSetRequest_for_Quote_Award(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Response_DataTypeRequest_for_Quote_AwardItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Response_DataTypeRequest_for_Quote_AwardItem instanceof \StructType\Request_for_Quote_Award_OutboundType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Response_DataTypeRequest_for_Quote_AwardItem) ? get_class($request_for_Quote_Award_Response_DataTypeRequest_for_Quote_AwardItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Response_DataTypeRequest_for_Quote_AwardItem), var_export($request_for_Quote_Award_Response_DataTypeRequest_for_Quote_AwardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Award property can only contain items of type \StructType\Request_for_Quote_Award_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_OutboundType[] $request_for_Quote_Award
     * @return \StructType\Request_for_Quote_Award_Response_DataType
     */
    public function setRequest_for_Quote_Award(array $request_for_Quote_Award = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_AwardArrayErrorMessage = self::validateRequest_for_Quote_AwardForArrayConstraintsFromSetRequest_for_Quote_Award($request_for_Quote_Award))) {
            throw new \InvalidArgumentException($request_for_Quote_AwardArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Award = $request_for_Quote_Award;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Award_OutboundType $item
     * @return \StructType\Request_for_Quote_Award_Response_DataType
     */
    public function addToRequest_for_Quote_Award(\StructType\Request_for_Quote_Award_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Award_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Award property can only contain items of type \StructType\Request_for_Quote_Award_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Award[] = $item;
        return $this;
    }
}
