<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Group_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Purchase Item Group Instance and Data
 * @subpackage Structs
 */
class Purchase_Item_Group_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Group
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_GroupType[]
     */
    public $Purchase_Item_Group;
    /**
     * Constructor method for Purchase_Item_Group_Response_DataType
     * @uses Purchase_Item_Group_Response_DataType::setPurchase_Item_Group()
     * @param \StructType\Purchase_Item_GroupType[] $purchase_Item_Group
     */
    public function __construct(array $purchase_Item_Group = array())
    {
        $this
            ->setPurchase_Item_Group($purchase_Item_Group);
    }
    /**
     * Get Purchase_Item_Group value
     * @return \StructType\Purchase_Item_GroupType[]|null
     */
    public function getPurchase_Item_Group()
    {
        return $this->Purchase_Item_Group;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Group method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_GroupForArrayConstraintsFromSetPurchase_Item_Group(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Group_Response_DataTypePurchase_Item_GroupItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Group_Response_DataTypePurchase_Item_GroupItem instanceof \StructType\Purchase_Item_GroupType) {
                $invalidValues[] = is_object($purchase_Item_Group_Response_DataTypePurchase_Item_GroupItem) ? get_class($purchase_Item_Group_Response_DataTypePurchase_Item_GroupItem) : sprintf('%s(%s)', gettype($purchase_Item_Group_Response_DataTypePurchase_Item_GroupItem), var_export($purchase_Item_Group_Response_DataTypePurchase_Item_GroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Group property can only contain items of type \StructType\Purchase_Item_GroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_GroupType[] $purchase_Item_Group
     * @return \StructType\Purchase_Item_Group_Response_DataType
     */
    public function setPurchase_Item_Group(array $purchase_Item_Group = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_GroupArrayErrorMessage = self::validatePurchase_Item_GroupForArrayConstraintsFromSetPurchase_Item_Group($purchase_Item_Group))) {
            throw new \InvalidArgumentException($purchase_Item_GroupArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Group = $purchase_Item_Group;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_GroupType $item
     * @return \StructType\Purchase_Item_Group_Response_DataType
     */
    public function addToPurchase_Item_Group(\StructType\Purchase_Item_GroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_GroupType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Group property can only contain items of type \StructType\Purchase_Item_GroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Group[] = $item;
        return $this;
    }
}
