<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Issue_Purchase_Order_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing outbound Purchase Order Data
 * @subpackage Structs
 */
class Issue_Purchase_Order_OutboundType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order.
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Order_Version
     * Meta information extracted from the WSDL
     * - documentation: Order VersioncXML Notes:Request/OrderRequest/OrderRequestHeader@orderVersionPurchase Order Version + 1. E.g. a Purchase Order without a Change Order will be sent as orderVersion =1. A Purchase Order with a Change Order version 1 will
     * be sent as orderVersion = 2. | Change Order Version
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Order_Version;
    /**
     * The Requestor
     * Meta information extracted from the WSDL
     * - documentation: RequestercXML Notes:Purchase Order Requester's Name is in this element.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Requestor;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - documentation: CompanycXML Notes:Request/OrderRequest/OrderRequestHeader/ShipTo/NameandRequest/OrderRequest/OrderRequestHeader/BillTo/NameandRequest/OrderRequest/OrderRequestHeader/Contact/NameThis is the Company for the Purchase Order Requisition,
     * or if that is missing, then the shopping cart's Company, or if that is missing, then the Workers primary Job position Company.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Company;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order DatecXML Notes:Request/OrderRequest/OrderRequestHeader@orderDate
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - documentation: Timestamp
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Timestamp;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Comments to the SuppliercXML Notes:Request/OrderRequest/OrderRequestHeader/Comments
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Total_Cost
     * Meta information extracted from the WSDL
     * - documentation: Total Purchase Order AmountcXML Notes:Request/OrderRequest/OrderRequestHeader/Total/MoneyThis is the Sum of the Extended Amount of all of the Purchase Order Lines. | Total cost of the asset component. | READ ONLY: Total cost of the
     * business asset.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Cost;
    /**
     * The PO_Number
     * Meta information extracted from the WSDL
     * - documentation: PO NumbercXML Notes:Request/OrderRequest/OrderRequestHeader@orderID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_Number;
    /**
     * The Phone_Number
     * Meta information extracted from the WSDL
     * - documentation: Phone NumbercXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Phone/TelephoneNumber/NumberandRequest/OrderRequest/OrderRequestHeader/BillTo/Phone/TelephoneNumber/NumberandRequest/OrderRequest/OrderRequestHeader/Contact/Phone/TelephoneNumber/NumberPhone Data
     * comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Number;
    /**
     * The Phone_Area_Code
     * Meta information extracted from the WSDL
     * - documentation: Phone Area CodecXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Phone/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/BillTo/Phone/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/Contact/Phone/TelephoneNumber/A
     * reaOrCityCodePhone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Phone Area Code | Ship-To Phone Area Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Phone_Area_Code;
    /**
     * The Phone_Country_Code
     * Meta information extracted from the WSDL
     * - documentation: Phone Country CodecXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Phone/TelephoneNumber/CountryCode andRequest/OrderRequest/OrderRequestHeader/BillTo/Phone/TelephoneNumber/CountryCode
     * andRequest/OrderRequest/OrderRequestHeader/Contact/Phone/TelephoneNumber/CountryCode Phone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Phone
     * Country Code | Ship-To Phone Country Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Phone_Country_Code;
    /**
     * The Phone_Country_Code_Alpha_2
     * Meta information extracted from the WSDL
     * - documentation: Phone Country Code Alpha-2cXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Phone/TelephoneNumber/CountryCode@isoCountryCodeandRequest/OrderRequest/OrderRequestHeader/BillTo/Phone/TelephoneNumber/CountryCode@isoCountryCode
     * andRequest/OrderRequest/OrderRequestHeader/Contact/Phone/TelephoneNumber/CountryCode@isoCountryCode Phone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone_Country_Code_Alpha_2;
    /**
     * The Fax_Number
     * Meta information extracted from the WSDL
     * - documentation: Fax NumbercXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Fax/TelephoneNumber/NumberandRequest/OrderRequest/OrderRequestHeader/BillTo/Fax/TelephoneNumber/NumberandRequest/OrderRequest/OrderRequestHeader/Contact/Fax/TelephoneNumber/NumberPhone Data comes
     * from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax_Number;
    /**
     * The Fax_Area_Code
     * Meta information extracted from the WSDL
     * - documentation: Fax Area CodecXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Fax/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/BillTo/Fax/TelephoneNumber/AreaOrCityCodeandRequest/OrderRequest/OrderRequestHeader/Contact/Fax/TelephoneNumber/AreaOrC
     * ityCodePhone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Fax Area Code | Ship-To Fax Area Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Fax_Area_Code;
    /**
     * The Fax_Country_Code
     * Meta information extracted from the WSDL
     * - documentation: Fax Country CodecXML Notes:Punchout Order MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Fax/TelephoneNumber/CountryCode andRequest/OrderRequest/OrderRequestHeader/BillTo/Fax/TelephoneNumber/CountryCode
     * andRequest/OrderRequest/OrderRequestHeader/Contact/Fax/TelephoneNumber/CountryCode Phone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone. | Bill-To Fax
     * Country Code | Ship-To Fax Country Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Fax_Country_Code;
    /**
     * The Fax_Country_Code_Alpha_2
     * Meta information extracted from the WSDL
     * - documentation: Fax Country Code Alpha-2cXML Notes:Punchout Order
     * MessageRequest/OrderRequest/OrderRequestHeader/ShipTo/Fax/TelephoneNumber/CountryCode@isoCountryCodeandRequest/OrderRequest/OrderRequestHeader/BillTo/Fax/TelephoneNumber/CountryCode@isoCountryCode
     * andRequest/OrderRequest/OrderRequestHeader/Contact/Fax/TelephoneNumber/CountryCode@isoCountryCode Phone Data comes from the Primary home phone data for the Purchase Order Requester, or if missing the Purchase Order Company Primary business phone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax_Country_Code_Alpha_2;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: EmailcXML Notes:Request/OrderRequest/OrderRequestHeader/ShipTo/EmailandRequest/OrderRequest/OrderRequestHeader/BillTo/EmailandRequest/OrderRequest/OrderRequestHeader/Contact/EmailPurchase Order's Requisition Requester's email. If
     * there is no requester, it will return the Purchase Order Company's email.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Payment_Method
     * Meta information extracted from the WSDL
     * - documentation: When using a credit card on the Purchase Order, this will be defaulted to "creditCard"
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payment_Method;
    /**
     * The Cardholder_Name
     * Meta information extracted from the WSDL
     * - documentation: When using a credit card on the Purchase Order, this will be the Cardholder's Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cardholder_Name;
    /**
     * The Credit_Card_Token
     * Meta information extracted from the WSDL
     * - documentation: When using a credit card on the Purchase Order, this will be the credit card's token.cXML Notes:Request/OrderRequest/OrderRequestHeader/Payments/PCard@number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Token;
    /**
     * The Credit_Card_Number
     * Meta information extracted from the WSDL
     * - documentation: When using a credit card on the Purchase Order, this will be the credit card's number, but it will be blank as the tenant's data does not contain full credit card numbers.
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Number;
    /**
     * The Credit_Card_Expiration_Date
     * Meta information extracted from the WSDL
     * - documentation: When using a credit card on the Purchase Order, this will be the credit card's expiration date.cXML Notes:Request/OrderRequest/OrderRequestHeader/Payments/PCard@expiration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Expiration_Date;
    /**
     * The Credit_Card_Type_ID
     * Meta information extracted from the WSDL
     * - documentation: When using a credit card on the Purchase Order, this will be the credit card's type id (e.g. AMEX.)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Type_ID;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency ReferencecXML Notes:Request/OrderRequest/OrderRequestHeader/Total/Money@currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Tax Code for the Purchase Order
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Shipping_Terms
     * Meta information extracted from the WSDL
     * - documentation: Shipping Terms
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping_Terms;
    /**
     * The Shipping_Method
     * Meta information extracted from the WSDL
     * - documentation: Shippint Method
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping_Method;
    /**
     * The Shipping_Instruction
     * Meta information extracted from the WSDL
     * - documentation: Shipping Instruction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping_Instruction;
    /**
     * The Bill_To
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Bill To Address datacXML Notes:Request/OrderRequest/OrderRequestHeader/BillTo
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Bill_To;
    /**
     * The Bill_To_Location_Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: The Location Customer Account Number representation of the Billing Address for this Purchase Order
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_To_Location_Customer_Account_Number;
    /**
     * The Bill_To_Contact
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Bill To Contact Data (Email, Phone, Fax)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Bill_To_Contact;
    /**
     * The Ship_To
     * Meta information extracted from the WSDL
     * - documentation: Ship TocXML Notes:Request/OrderRequest/OrderRequestHeader/ShipToandRequest/OrderRequest/OrderRequestHeader/ContactAll Address fields inside come from the Primary Public Work Shipping Address of the Punchout User or, if no Public Work
     * Shipping address exists, the Location for the Punchout User's Primary Job Position.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Ship_To;
    /**
     * The Ship_To_Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Ship_To_Contact;
    /**
     * The Supplier_Reference_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Supplier_Reference_Data;
    /**
     * The Unique_Name_Info_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $Unique_Name_Info_Data;
    /**
     * The PO_Line
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOutThis contains the list of items in the cart from the punchout Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $PO_Line;
    /**
     * The DO_Line
     * Meta information extracted from the WSDL
     * - documentation: DO Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $DO_Line;
    /**
     * The RO_Line
     * Meta information extracted from the WSDL
     * - documentation: RO Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]
     */
    public $RO_Line;
    /**
     * The Service_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Service Lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Service_Lines_DataType[]
     */
    public $Service_Line_Data;
    /**
     * The Tax_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: The tax amounts by tax code, applicability and rate.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Taxable_Code_Application_NO_INPUT_DataType[]
     */
    public $Tax_Code_Data;
    /**
     * The PO_Attachments
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order attachments marked as external.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachments_for_PO_IssueType[]
     */
    public $PO_Attachments;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Issue_Purchase_Order_OutboundType
     * @uses Issue_Purchase_Order_OutboundType::setPurchase_Order_Reference()
     * @uses Issue_Purchase_Order_OutboundType::setOrder_Version()
     * @uses Issue_Purchase_Order_OutboundType::setRequestor()
     * @uses Issue_Purchase_Order_OutboundType::setCompany()
     * @uses Issue_Purchase_Order_OutboundType::setDocument_Date()
     * @uses Issue_Purchase_Order_OutboundType::setTimestamp()
     * @uses Issue_Purchase_Order_OutboundType::setMemo()
     * @uses Issue_Purchase_Order_OutboundType::setTotal_Cost()
     * @uses Issue_Purchase_Order_OutboundType::setPO_Number()
     * @uses Issue_Purchase_Order_OutboundType::setPhone_Number()
     * @uses Issue_Purchase_Order_OutboundType::setPhone_Area_Code()
     * @uses Issue_Purchase_Order_OutboundType::setPhone_Country_Code()
     * @uses Issue_Purchase_Order_OutboundType::setPhone_Country_Code_Alpha_2()
     * @uses Issue_Purchase_Order_OutboundType::setFax_Number()
     * @uses Issue_Purchase_Order_OutboundType::setFax_Area_Code()
     * @uses Issue_Purchase_Order_OutboundType::setFax_Country_Code()
     * @uses Issue_Purchase_Order_OutboundType::setFax_Country_Code_Alpha_2()
     * @uses Issue_Purchase_Order_OutboundType::setEmail()
     * @uses Issue_Purchase_Order_OutboundType::setPayment_Method()
     * @uses Issue_Purchase_Order_OutboundType::setCardholder_Name()
     * @uses Issue_Purchase_Order_OutboundType::setCredit_Card_Token()
     * @uses Issue_Purchase_Order_OutboundType::setCredit_Card_Number()
     * @uses Issue_Purchase_Order_OutboundType::setCredit_Card_Expiration_Date()
     * @uses Issue_Purchase_Order_OutboundType::setCredit_Card_Type_ID()
     * @uses Issue_Purchase_Order_OutboundType::setSupplier_Reference()
     * @uses Issue_Purchase_Order_OutboundType::setCurrency_Reference()
     * @uses Issue_Purchase_Order_OutboundType::setTax_Code_Reference()
     * @uses Issue_Purchase_Order_OutboundType::setShipping_Terms()
     * @uses Issue_Purchase_Order_OutboundType::setShipping_Method()
     * @uses Issue_Purchase_Order_OutboundType::setShipping_Instruction()
     * @uses Issue_Purchase_Order_OutboundType::setBill_To()
     * @uses Issue_Purchase_Order_OutboundType::setBill_To_Location_Customer_Account_Number()
     * @uses Issue_Purchase_Order_OutboundType::setBill_To_Contact()
     * @uses Issue_Purchase_Order_OutboundType::setShip_To()
     * @uses Issue_Purchase_Order_OutboundType::setShip_To_Contact()
     * @uses Issue_Purchase_Order_OutboundType::setSupplier_Reference_Data()
     * @uses Issue_Purchase_Order_OutboundType::setUnique_Name_Info_Data()
     * @uses Issue_Purchase_Order_OutboundType::setPO_Line()
     * @uses Issue_Purchase_Order_OutboundType::setDO_Line()
     * @uses Issue_Purchase_Order_OutboundType::setRO_Line()
     * @uses Issue_Purchase_Order_OutboundType::setService_Line_Data()
     * @uses Issue_Purchase_Order_OutboundType::setTax_Code_Data()
     * @uses Issue_Purchase_Order_OutboundType::setPO_Attachments()
     * @uses Issue_Purchase_Order_OutboundType::setVersion()
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param float $order_Version
     * @param \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $requestor
     * @param \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $company
     * @param string $document_Date
     * @param string $timestamp
     * @param string $memo
     * @param float $total_Cost
     * @param string $pO_Number
     * @param string $phone_Number
     * @param float $phone_Area_Code
     * @param float $phone_Country_Code
     * @param string $phone_Country_Code_Alpha_2
     * @param string $fax_Number
     * @param float $fax_Area_Code
     * @param float $fax_Country_Code
     * @param string $fax_Country_Code_Alpha_2
     * @param string $email
     * @param string $payment_Method
     * @param string $cardholder_Name
     * @param string $credit_Card_Token
     * @param string $credit_Card_Number
     * @param string $credit_Card_Expiration_Date
     * @param string $credit_Card_Type_ID
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param string $shipping_Terms
     * @param string $shipping_Method
     * @param string $shipping_Instruction
     * @param \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $bill_To
     * @param string $bill_To_Location_Customer_Account_Number
     * @param \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $bill_To_Contact
     * @param \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $ship_To
     * @param \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $ship_To_Contact
     * @param \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $supplier_Reference_Data
     * @param \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $unique_Name_Info_Data
     * @param \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $pO_Line
     * @param \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $dO_Line
     * @param \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $rO_Line
     * @param \StructType\Purchase_Order_Service_Lines_DataType[] $service_Line_Data
     * @param \StructType\Taxable_Code_Application_NO_INPUT_DataType[] $tax_Code_Data
     * @param \StructType\Business_Document_Attachments_for_PO_IssueType[] $pO_Attachments
     * @param string $version
     */
    public function __construct(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $order_Version = null, array $requestor = array(), array $company = array(), $document_Date = null, $timestamp = null, $memo = null, $total_Cost = null, $pO_Number = null, $phone_Number = null, $phone_Area_Code = null, $phone_Country_Code = null, $phone_Country_Code_Alpha_2 = null, $fax_Number = null, $fax_Area_Code = null, $fax_Country_Code = null, $fax_Country_Code_Alpha_2 = null, $email = null, $payment_Method = null, $cardholder_Name = null, $credit_Card_Token = null, $credit_Card_Number = null, $credit_Card_Expiration_Date = null, $credit_Card_Type_ID = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, $shipping_Terms = null, $shipping_Method = null, $shipping_Instruction = null, array $bill_To = array(), $bill_To_Location_Customer_Account_Number = null, array $bill_To_Contact = array(), array $ship_To = array(), array $ship_To_Contact = array(), array $supplier_Reference_Data = array(), array $unique_Name_Info_Data = array(), array $pO_Line = array(), array $dO_Line = array(), array $rO_Line = array(), array $service_Line_Data = array(), array $tax_Code_Data = array(), array $pO_Attachments = array(), $version = null)
    {
        $this
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setOrder_Version($order_Version)
            ->setRequestor($requestor)
            ->setCompany($company)
            ->setDocument_Date($document_Date)
            ->setTimestamp($timestamp)
            ->setMemo($memo)
            ->setTotal_Cost($total_Cost)
            ->setPO_Number($pO_Number)
            ->setPhone_Number($phone_Number)
            ->setPhone_Area_Code($phone_Area_Code)
            ->setPhone_Country_Code($phone_Country_Code)
            ->setPhone_Country_Code_Alpha_2($phone_Country_Code_Alpha_2)
            ->setFax_Number($fax_Number)
            ->setFax_Area_Code($fax_Area_Code)
            ->setFax_Country_Code($fax_Country_Code)
            ->setFax_Country_Code_Alpha_2($fax_Country_Code_Alpha_2)
            ->setEmail($email)
            ->setPayment_Method($payment_Method)
            ->setCardholder_Name($cardholder_Name)
            ->setCredit_Card_Token($credit_Card_Token)
            ->setCredit_Card_Number($credit_Card_Number)
            ->setCredit_Card_Expiration_Date($credit_Card_Expiration_Date)
            ->setCredit_Card_Type_ID($credit_Card_Type_ID)
            ->setSupplier_Reference($supplier_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setShipping_Terms($shipping_Terms)
            ->setShipping_Method($shipping_Method)
            ->setShipping_Instruction($shipping_Instruction)
            ->setBill_To($bill_To)
            ->setBill_To_Location_Customer_Account_Number($bill_To_Location_Customer_Account_Number)
            ->setBill_To_Contact($bill_To_Contact)
            ->setShip_To($ship_To)
            ->setShip_To_Contact($ship_To_Contact)
            ->setSupplier_Reference_Data($supplier_Reference_Data)
            ->setUnique_Name_Info_Data($unique_Name_Info_Data)
            ->setPO_Line($pO_Line)
            ->setDO_Line($dO_Line)
            ->setRO_Line($rO_Line)
            ->setService_Line_Data($service_Line_Data)
            ->setTax_Code_Data($tax_Code_Data)
            ->setPO_Attachments($pO_Attachments)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Order_Version value
     * @return float|null
     */
    public function getOrder_Version()
    {
        return $this->Order_Version;
    }
    /**
     * Set Order_Version value
     * @param float $order_Version
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setOrder_Version($order_Version = null)
    {
        // validation for constraint: float
        if (!is_null($order_Version) && !(is_float($order_Version) || is_numeric($order_Version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($order_Version, true), gettype($order_Version)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($order_Version) && mb_strlen(mb_substr($order_Version, false !== mb_strpos($order_Version, '.') ? mb_strpos($order_Version, '.') + 1 : mb_strlen($order_Version))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($order_Version, true), mb_strlen(mb_substr($order_Version, mb_strpos($order_Version, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($order_Version) && $order_Version < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($order_Version, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($order_Version) && mb_strlen(preg_replace('/(\D)/', '', $order_Version)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($order_Version, true), mb_strlen(preg_replace('/(\D)/', '', $order_Version))), __LINE__);
        }
        $this->Order_Version = $order_Version;
        return $this;
    }
    /**
     * Get Requestor value
     * @return \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getRequestor()
    {
        return $this->Requestor;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestorForArrayConstraintsFromSetRequestor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeRequestorItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeRequestorItem instanceof \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeRequestorItem) ? get_class($issue_Purchase_Order_OutboundTypeRequestorItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeRequestorItem), var_export($issue_Purchase_Order_OutboundTypeRequestorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requestor property can only contain items of type \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requestor value
     * @throws \InvalidArgumentException
     * @param \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $requestor
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setRequestor(array $requestor = array())
    {
        // validation for constraint: array
        if ('' !== ($requestorArrayErrorMessage = self::validateRequestorForArrayConstraintsFromSetRequestor($requestor))) {
            throw new \InvalidArgumentException($requestorArrayErrorMessage, __LINE__);
        }
        $this->Requestor = $requestor;
        return $this;
    }
    /**
     * Add item to Requestor value
     * @throws \InvalidArgumentException
     * @param \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToRequestor(\StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Requestor property can only contain items of type \StructType\Requestor_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requestor[] = $item;
        return $this;
    }
    /**
     * Get Company value
     * @return \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyForArrayConstraintsFromSetCompany(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeCompanyItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeCompanyItem instanceof \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeCompanyItem) ? get_class($issue_Purchase_Order_OutboundTypeCompanyItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeCompanyItem), var_export($issue_Purchase_Order_OutboundTypeCompanyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company property can only contain items of type \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $company
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setCompany(array $company = array())
    {
        // validation for constraint: array
        if ('' !== ($companyArrayErrorMessage = self::validateCompanyForArrayConstraintsFromSetCompany($company))) {
            throw new \InvalidArgumentException($companyArrayErrorMessage, __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Add item to Company value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToCompany(\StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Company property can only contain items of type \StructType\Company_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company[] = $item;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Total_Cost value
     * @return float|null
     */
    public function getTotal_Cost()
    {
        return $this->Total_Cost;
    }
    /**
     * Set Total_Cost value
     * @param float $total_Cost
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setTotal_Cost($total_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($total_Cost) && !(is_float($total_Cost) || is_numeric($total_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Cost, true), gettype($total_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Cost) && mb_strlen(mb_substr($total_Cost, false !== mb_strpos($total_Cost, '.') ? mb_strpos($total_Cost, '.') + 1 : mb_strlen($total_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Cost, true), mb_strlen(mb_substr($total_Cost, mb_strpos($total_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Cost) && mb_strlen(preg_replace('/(\D)/', '', $total_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $total_Cost))), __LINE__);
        }
        $this->Total_Cost = $total_Cost;
        return $this;
    }
    /**
     * Get PO_Number value
     * @return string|null
     */
    public function getPO_Number()
    {
        return $this->PO_Number;
    }
    /**
     * Set PO_Number value
     * @param string $pO_Number
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPO_Number($pO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($pO_Number) && !is_string($pO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_Number, true), gettype($pO_Number)), __LINE__);
        }
        $this->PO_Number = $pO_Number;
        return $this;
    }
    /**
     * Get Phone_Number value
     * @return string|null
     */
    public function getPhone_Number()
    {
        return $this->Phone_Number;
    }
    /**
     * Set Phone_Number value
     * @param string $phone_Number
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPhone_Number($phone_Number = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Number) && !is_string($phone_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Number, true), gettype($phone_Number)), __LINE__);
        }
        $this->Phone_Number = $phone_Number;
        return $this;
    }
    /**
     * Get Phone_Area_Code value
     * @return float|null
     */
    public function getPhone_Area_Code()
    {
        return $this->Phone_Area_Code;
    }
    /**
     * Set Phone_Area_Code value
     * @param float $phone_Area_Code
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPhone_Area_Code($phone_Area_Code = null)
    {
        // validation for constraint: float
        if (!is_null($phone_Area_Code) && !(is_float($phone_Area_Code) || is_numeric($phone_Area_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($phone_Area_Code, true), gettype($phone_Area_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($phone_Area_Code) && mb_strlen(mb_substr($phone_Area_Code, false !== mb_strpos($phone_Area_Code, '.') ? mb_strpos($phone_Area_Code, '.') + 1 : mb_strlen($phone_Area_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($phone_Area_Code, true), mb_strlen(mb_substr($phone_Area_Code, mb_strpos($phone_Area_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($phone_Area_Code) && $phone_Area_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($phone_Area_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($phone_Area_Code) && mb_strlen(preg_replace('/(\D)/', '', $phone_Area_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($phone_Area_Code, true), mb_strlen(preg_replace('/(\D)/', '', $phone_Area_Code))), __LINE__);
        }
        $this->Phone_Area_Code = $phone_Area_Code;
        return $this;
    }
    /**
     * Get Phone_Country_Code value
     * @return float|null
     */
    public function getPhone_Country_Code()
    {
        return $this->Phone_Country_Code;
    }
    /**
     * Set Phone_Country_Code value
     * @param float $phone_Country_Code
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPhone_Country_Code($phone_Country_Code = null)
    {
        // validation for constraint: float
        if (!is_null($phone_Country_Code) && !(is_float($phone_Country_Code) || is_numeric($phone_Country_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($phone_Country_Code, true), gettype($phone_Country_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($phone_Country_Code) && mb_strlen(mb_substr($phone_Country_Code, false !== mb_strpos($phone_Country_Code, '.') ? mb_strpos($phone_Country_Code, '.') + 1 : mb_strlen($phone_Country_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($phone_Country_Code, true), mb_strlen(mb_substr($phone_Country_Code, mb_strpos($phone_Country_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($phone_Country_Code) && $phone_Country_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($phone_Country_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($phone_Country_Code) && mb_strlen(preg_replace('/(\D)/', '', $phone_Country_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($phone_Country_Code, true), mb_strlen(preg_replace('/(\D)/', '', $phone_Country_Code))), __LINE__);
        }
        $this->Phone_Country_Code = $phone_Country_Code;
        return $this;
    }
    /**
     * Get phone_Country_Code_Alpha value
     * @return phone_Country_Code_Alpha
     */
    public function getPhone_Country_Code_Alpha_2()
    {
        return $this->{'Phone_Country_Code_Alpha-2'};
    }
    /**
     * Set phone_Country_Code_Alpha value
     * @param phone_Country_Code_Alpha $phone_Country_Code_Alpha
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPhone_Country_Code_Alpha_2($phone_Country_Code_Alpha_2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone_Country_Code_Alpha_2) && !is_string($phone_Country_Code_Alpha_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone_Country_Code_Alpha_2, true), gettype($phone_Country_Code_Alpha_2)), __LINE__);
        }
        $this->Phone_Country_Code_Alpha_2 = $this->{'Phone_Country_Code_Alpha-2'} = $phone_Country_Code_Alpha_2;
        return $this;
    }
    /**
     * Get Fax_Number value
     * @return string|null
     */
    public function getFax_Number()
    {
        return $this->Fax_Number;
    }
    /**
     * Set Fax_Number value
     * @param string $fax_Number
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setFax_Number($fax_Number = null)
    {
        // validation for constraint: string
        if (!is_null($fax_Number) && !is_string($fax_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_Number, true), gettype($fax_Number)), __LINE__);
        }
        $this->Fax_Number = $fax_Number;
        return $this;
    }
    /**
     * Get Fax_Area_Code value
     * @return float|null
     */
    public function getFax_Area_Code()
    {
        return $this->Fax_Area_Code;
    }
    /**
     * Set Fax_Area_Code value
     * @param float $fax_Area_Code
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setFax_Area_Code($fax_Area_Code = null)
    {
        // validation for constraint: float
        if (!is_null($fax_Area_Code) && !(is_float($fax_Area_Code) || is_numeric($fax_Area_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fax_Area_Code, true), gettype($fax_Area_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($fax_Area_Code) && mb_strlen(mb_substr($fax_Area_Code, false !== mb_strpos($fax_Area_Code, '.') ? mb_strpos($fax_Area_Code, '.') + 1 : mb_strlen($fax_Area_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($fax_Area_Code, true), mb_strlen(mb_substr($fax_Area_Code, mb_strpos($fax_Area_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fax_Area_Code) && $fax_Area_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fax_Area_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($fax_Area_Code) && mb_strlen(preg_replace('/(\D)/', '', $fax_Area_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($fax_Area_Code, true), mb_strlen(preg_replace('/(\D)/', '', $fax_Area_Code))), __LINE__);
        }
        $this->Fax_Area_Code = $fax_Area_Code;
        return $this;
    }
    /**
     * Get Fax_Country_Code value
     * @return float|null
     */
    public function getFax_Country_Code()
    {
        return $this->Fax_Country_Code;
    }
    /**
     * Set Fax_Country_Code value
     * @param float $fax_Country_Code
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setFax_Country_Code($fax_Country_Code = null)
    {
        // validation for constraint: float
        if (!is_null($fax_Country_Code) && !(is_float($fax_Country_Code) || is_numeric($fax_Country_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fax_Country_Code, true), gettype($fax_Country_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($fax_Country_Code) && mb_strlen(mb_substr($fax_Country_Code, false !== mb_strpos($fax_Country_Code, '.') ? mb_strpos($fax_Country_Code, '.') + 1 : mb_strlen($fax_Country_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($fax_Country_Code, true), mb_strlen(mb_substr($fax_Country_Code, mb_strpos($fax_Country_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fax_Country_Code) && $fax_Country_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fax_Country_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($fax_Country_Code) && mb_strlen(preg_replace('/(\D)/', '', $fax_Country_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($fax_Country_Code, true), mb_strlen(preg_replace('/(\D)/', '', $fax_Country_Code))), __LINE__);
        }
        $this->Fax_Country_Code = $fax_Country_Code;
        return $this;
    }
    /**
     * Get fax_Country_Code_Alpha value
     * @return fax_Country_Code_Alpha
     */
    public function getFax_Country_Code_Alpha_2()
    {
        return $this->{'Fax_Country_Code_Alpha-2'};
    }
    /**
     * Set fax_Country_Code_Alpha value
     * @param fax_Country_Code_Alpha $fax_Country_Code_Alpha
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setFax_Country_Code_Alpha_2($fax_Country_Code_Alpha_2 = null)
    {
        // validation for constraint: string
        if (!is_null($fax_Country_Code_Alpha_2) && !is_string($fax_Country_Code_Alpha_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax_Country_Code_Alpha_2, true), gettype($fax_Country_Code_Alpha_2)), __LINE__);
        }
        $this->Fax_Country_Code_Alpha_2 = $this->{'Fax_Country_Code_Alpha-2'} = $fax_Country_Code_Alpha_2;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Payment_Method value
     * @return string|null
     */
    public function getPayment_Method()
    {
        return $this->Payment_Method;
    }
    /**
     * Set Payment_Method value
     * @param string $payment_Method
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPayment_Method($payment_Method = null)
    {
        // validation for constraint: string
        if (!is_null($payment_Method) && !is_string($payment_Method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payment_Method, true), gettype($payment_Method)), __LINE__);
        }
        $this->Payment_Method = $payment_Method;
        return $this;
    }
    /**
     * Get Cardholder_Name value
     * @return string|null
     */
    public function getCardholder_Name()
    {
        return $this->Cardholder_Name;
    }
    /**
     * Set Cardholder_Name value
     * @param string $cardholder_Name
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setCardholder_Name($cardholder_Name = null)
    {
        // validation for constraint: string
        if (!is_null($cardholder_Name) && !is_string($cardholder_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardholder_Name, true), gettype($cardholder_Name)), __LINE__);
        }
        $this->Cardholder_Name = $cardholder_Name;
        return $this;
    }
    /**
     * Get Credit_Card_Token value
     * @return string|null
     */
    public function getCredit_Card_Token()
    {
        return $this->Credit_Card_Token;
    }
    /**
     * Set Credit_Card_Token value
     * @param string $credit_Card_Token
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setCredit_Card_Token($credit_Card_Token = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Token) && !is_string($credit_Card_Token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Token, true), gettype($credit_Card_Token)), __LINE__);
        }
        $this->Credit_Card_Token = $credit_Card_Token;
        return $this;
    }
    /**
     * Get Credit_Card_Number value
     * @return string|null
     */
    public function getCredit_Card_Number()
    {
        return $this->Credit_Card_Number;
    }
    /**
     * Set Credit_Card_Number value
     * @param string $credit_Card_Number
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setCredit_Card_Number($credit_Card_Number = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Number) && !is_string($credit_Card_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Number, true), gettype($credit_Card_Number)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($credit_Card_Number) && mb_strlen($credit_Card_Number) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($credit_Card_Number)), __LINE__);
        }
        $this->Credit_Card_Number = $credit_Card_Number;
        return $this;
    }
    /**
     * Get Credit_Card_Expiration_Date value
     * @return string|null
     */
    public function getCredit_Card_Expiration_Date()
    {
        return $this->Credit_Card_Expiration_Date;
    }
    /**
     * Set Credit_Card_Expiration_Date value
     * @param string $credit_Card_Expiration_Date
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setCredit_Card_Expiration_Date($credit_Card_Expiration_Date = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Expiration_Date) && !is_string($credit_Card_Expiration_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Expiration_Date, true), gettype($credit_Card_Expiration_Date)), __LINE__);
        }
        $this->Credit_Card_Expiration_Date = $credit_Card_Expiration_Date;
        return $this;
    }
    /**
     * Get Credit_Card_Type_ID value
     * @return string|null
     */
    public function getCredit_Card_Type_ID()
    {
        return $this->Credit_Card_Type_ID;
    }
    /**
     * Set Credit_Card_Type_ID value
     * @param string $credit_Card_Type_ID
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setCredit_Card_Type_ID($credit_Card_Type_ID = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Type_ID) && !is_string($credit_Card_Type_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Type_ID, true), gettype($credit_Card_Type_ID)), __LINE__);
        }
        $this->Credit_Card_Type_ID = $credit_Card_Type_ID;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Shipping_Terms value
     * @return string|null
     */
    public function getShipping_Terms()
    {
        return $this->Shipping_Terms;
    }
    /**
     * Set Shipping_Terms value
     * @param string $shipping_Terms
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setShipping_Terms($shipping_Terms = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_Terms) && !is_string($shipping_Terms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_Terms, true), gettype($shipping_Terms)), __LINE__);
        }
        $this->Shipping_Terms = $shipping_Terms;
        return $this;
    }
    /**
     * Get Shipping_Method value
     * @return string|null
     */
    public function getShipping_Method()
    {
        return $this->Shipping_Method;
    }
    /**
     * Set Shipping_Method value
     * @param string $shipping_Method
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setShipping_Method($shipping_Method = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_Method) && !is_string($shipping_Method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_Method, true), gettype($shipping_Method)), __LINE__);
        }
        $this->Shipping_Method = $shipping_Method;
        return $this;
    }
    /**
     * Get Shipping_Instruction value
     * @return string|null
     */
    public function getShipping_Instruction()
    {
        return $this->Shipping_Instruction;
    }
    /**
     * Set Shipping_Instruction value
     * @param string $shipping_Instruction
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setShipping_Instruction($shipping_Instruction = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_Instruction) && !is_string($shipping_Instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_Instruction, true), gettype($shipping_Instruction)), __LINE__);
        }
        $this->Shipping_Instruction = $shipping_Instruction;
        return $this;
    }
    /**
     * Get Bill_To value
     * @return \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getBill_To()
    {
        return $this->Bill_To;
    }
    /**
     * This method is responsible for validating the values passed to the setBill_To method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBill_To method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBill_ToForArrayConstraintsFromSetBill_To(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeBill_ToItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeBill_ToItem instanceof \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeBill_ToItem) ? get_class($issue_Purchase_Order_OutboundTypeBill_ToItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeBill_ToItem), var_export($issue_Purchase_Order_OutboundTypeBill_ToItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bill_To property can only contain items of type \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bill_To value
     * @throws \InvalidArgumentException
     * @param \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $bill_To
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setBill_To(array $bill_To = array())
    {
        // validation for constraint: array
        if ('' !== ($bill_ToArrayErrorMessage = self::validateBill_ToForArrayConstraintsFromSetBill_To($bill_To))) {
            throw new \InvalidArgumentException($bill_ToArrayErrorMessage, __LINE__);
        }
        $this->Bill_To = $bill_To;
        return $this;
    }
    /**
     * Add item to Bill_To value
     * @throws \InvalidArgumentException
     * @param \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToBill_To(\StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Bill_To property can only contain items of type \StructType\Bill_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bill_To[] = $item;
        return $this;
    }
    /**
     * Get Bill_To_Location_Customer_Account_Number value
     * @return string|null
     */
    public function getBill_To_Location_Customer_Account_Number()
    {
        return $this->Bill_To_Location_Customer_Account_Number;
    }
    /**
     * Set Bill_To_Location_Customer_Account_Number value
     * @param string $bill_To_Location_Customer_Account_Number
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setBill_To_Location_Customer_Account_Number($bill_To_Location_Customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($bill_To_Location_Customer_Account_Number) && !is_string($bill_To_Location_Customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_To_Location_Customer_Account_Number, true), gettype($bill_To_Location_Customer_Account_Number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($bill_To_Location_Customer_Account_Number) && mb_strlen($bill_To_Location_Customer_Account_Number) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($bill_To_Location_Customer_Account_Number)), __LINE__);
        }
        $this->Bill_To_Location_Customer_Account_Number = $bill_To_Location_Customer_Account_Number;
        return $this;
    }
    /**
     * Get Bill_To_Contact value
     * @return \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getBill_To_Contact()
    {
        return $this->Bill_To_Contact;
    }
    /**
     * This method is responsible for validating the values passed to the setBill_To_Contact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBill_To_Contact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBill_To_ContactForArrayConstraintsFromSetBill_To_Contact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeBill_To_ContactItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeBill_To_ContactItem instanceof \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeBill_To_ContactItem) ? get_class($issue_Purchase_Order_OutboundTypeBill_To_ContactItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeBill_To_ContactItem), var_export($issue_Purchase_Order_OutboundTypeBill_To_ContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Bill_To_Contact property can only contain items of type \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Bill_To_Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $bill_To_Contact
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setBill_To_Contact(array $bill_To_Contact = array())
    {
        // validation for constraint: array
        if ('' !== ($bill_To_ContactArrayErrorMessage = self::validateBill_To_ContactForArrayConstraintsFromSetBill_To_Contact($bill_To_Contact))) {
            throw new \InvalidArgumentException($bill_To_ContactArrayErrorMessage, __LINE__);
        }
        $this->Bill_To_Contact = $bill_To_Contact;
        return $this;
    }
    /**
     * Add item to Bill_To_Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToBill_To_Contact(\StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Bill_To_Contact property can only contain items of type \StructType\Bill_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Bill_To_Contact[] = $item;
        return $this;
    }
    /**
     * Get Ship_To value
     * @return \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getShip_To()
    {
        return $this->Ship_To;
    }
    /**
     * This method is responsible for validating the values passed to the setShip_To method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShip_ToForArrayConstraintsFromSetShip_To(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeShip_ToItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeShip_ToItem instanceof \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeShip_ToItem) ? get_class($issue_Purchase_Order_OutboundTypeShip_ToItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeShip_ToItem), var_export($issue_Purchase_Order_OutboundTypeShip_ToItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ship_To property can only contain items of type \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ship_To value
     * @throws \InvalidArgumentException
     * @param \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $ship_To
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setShip_To(array $ship_To = array())
    {
        // validation for constraint: array
        if ('' !== ($ship_ToArrayErrorMessage = self::validateShip_ToForArrayConstraintsFromSetShip_To($ship_To))) {
            throw new \InvalidArgumentException($ship_ToArrayErrorMessage, __LINE__);
        }
        $this->Ship_To = $ship_To;
        return $this;
    }
    /**
     * Add item to Ship_To value
     * @throws \InvalidArgumentException
     * @param \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToShip_To(\StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Ship_To property can only contain items of type \StructType\Ship_To_Address_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ship_To[] = $item;
        return $this;
    }
    /**
     * Get Ship_To_Contact value
     * @return \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getShip_To_Contact()
    {
        return $this->Ship_To_Contact;
    }
    /**
     * This method is responsible for validating the values passed to the setShip_To_Contact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Contact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShip_To_ContactForArrayConstraintsFromSetShip_To_Contact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeShip_To_ContactItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeShip_To_ContactItem instanceof \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeShip_To_ContactItem) ? get_class($issue_Purchase_Order_OutboundTypeShip_To_ContactItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeShip_To_ContactItem), var_export($issue_Purchase_Order_OutboundTypeShip_To_ContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ship_To_Contact property can only contain items of type \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ship_To_Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $ship_To_Contact
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setShip_To_Contact(array $ship_To_Contact = array())
    {
        // validation for constraint: array
        if ('' !== ($ship_To_ContactArrayErrorMessage = self::validateShip_To_ContactForArrayConstraintsFromSetShip_To_Contact($ship_To_Contact))) {
            throw new \InvalidArgumentException($ship_To_ContactArrayErrorMessage, __LINE__);
        }
        $this->Ship_To_Contact = $ship_To_Contact;
        return $this;
    }
    /**
     * Add item to Ship_To_Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToShip_To_Contact(\StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Ship_To_Contact property can only contain items of type \StructType\Ship_To_Contact_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ship_To_Contact[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference_Data value
     * @return \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getSupplier_Reference_Data()
    {
        return $this->Supplier_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Reference_DataForArrayConstraintsFromSetSupplier_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeSupplier_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeSupplier_Reference_DataItem instanceof \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeSupplier_Reference_DataItem) ? get_class($issue_Purchase_Order_OutboundTypeSupplier_Reference_DataItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeSupplier_Reference_DataItem), var_export($issue_Purchase_Order_OutboundTypeSupplier_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference_Data property can only contain items of type \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $supplier_Reference_Data
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setSupplier_Reference_Data(array $supplier_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Reference_DataArrayErrorMessage = self::validateSupplier_Reference_DataForArrayConstraintsFromSetSupplier_Reference_Data($supplier_Reference_Data))) {
            throw new \InvalidArgumentException($supplier_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference_Data = $supplier_Reference_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToSupplier_Reference_Data(\StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference_Data property can only contain items of type \StructType\Supplier_Reference_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Unique_Name_Info_Data value
     * @return \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getUnique_Name_Info_Data()
    {
        return $this->Unique_Name_Info_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setUnique_Name_Info_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnique_Name_Info_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnique_Name_Info_DataForArrayConstraintsFromSetUnique_Name_Info_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeUnique_Name_Info_DataItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeUnique_Name_Info_DataItem instanceof \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeUnique_Name_Info_DataItem) ? get_class($issue_Purchase_Order_OutboundTypeUnique_Name_Info_DataItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeUnique_Name_Info_DataItem), var_export($issue_Purchase_Order_OutboundTypeUnique_Name_Info_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Unique_Name_Info_Data property can only contain items of type \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Unique_Name_Info_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $unique_Name_Info_Data
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setUnique_Name_Info_Data(array $unique_Name_Info_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($unique_Name_Info_DataArrayErrorMessage = self::validateUnique_Name_Info_DataForArrayConstraintsFromSetUnique_Name_Info_Data($unique_Name_Info_Data))) {
            throw new \InvalidArgumentException($unique_Name_Info_DataArrayErrorMessage, __LINE__);
        }
        $this->Unique_Name_Info_Data = $unique_Name_Info_Data;
        return $this;
    }
    /**
     * Add item to Unique_Name_Info_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToUnique_Name_Info_Data(\StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The Unique_Name_Info_Data property can only contain items of type \StructType\Unique_Name_Info_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Unique_Name_Info_Data[] = $item;
        return $this;
    }
    /**
     * Get PO_Line value
     * @return \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getPO_Line()
    {
        return $this->PO_Line;
    }
    /**
     * This method is responsible for validating the values passed to the setPO_Line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPO_Line method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePO_LineForArrayConstraintsFromSetPO_Line(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypePO_LineItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypePO_LineItem instanceof \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypePO_LineItem) ? get_class($issue_Purchase_Order_OutboundTypePO_LineItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypePO_LineItem), var_export($issue_Purchase_Order_OutboundTypePO_LineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PO_Line property can only contain items of type \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PO_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $pO_Line
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPO_Line(array $pO_Line = array())
    {
        // validation for constraint: array
        if ('' !== ($pO_LineArrayErrorMessage = self::validatePO_LineForArrayConstraintsFromSetPO_Line($pO_Line))) {
            throw new \InvalidArgumentException($pO_LineArrayErrorMessage, __LINE__);
        }
        $this->PO_Line = $pO_Line;
        return $this;
    }
    /**
     * Add item to PO_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToPO_Line(\StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The PO_Line property can only contain items of type \StructType\Purchase_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PO_Line[] = $item;
        return $this;
    }
    /**
     * Get DO_Line value
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getDO_Line()
    {
        return $this->DO_Line;
    }
    /**
     * This method is responsible for validating the values passed to the setDO_Line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDO_Line method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDO_LineForArrayConstraintsFromSetDO_Line(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeDO_LineItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeDO_LineItem instanceof \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeDO_LineItem) ? get_class($issue_Purchase_Order_OutboundTypeDO_LineItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeDO_LineItem), var_export($issue_Purchase_Order_OutboundTypeDO_LineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DO_Line property can only contain items of type \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DO_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $dO_Line
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setDO_Line(array $dO_Line = array())
    {
        // validation for constraint: array
        if ('' !== ($dO_LineArrayErrorMessage = self::validateDO_LineForArrayConstraintsFromSetDO_Line($dO_Line))) {
            throw new \InvalidArgumentException($dO_LineArrayErrorMessage, __LINE__);
        }
        $this->DO_Line = $dO_Line;
        return $this;
    }
    /**
     * Add item to DO_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToDO_Line(\StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The DO_Line property can only contain items of type \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DO_Line[] = $item;
        return $this;
    }
    /**
     * Get RO_Line value
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[]|null
     */
    public function getRO_Line()
    {
        return $this->RO_Line;
    }
    /**
     * This method is responsible for validating the values passed to the setRO_Line method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRO_Line method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRO_LineForArrayConstraintsFromSetRO_Line(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeRO_LineItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeRO_LineItem instanceof \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeRO_LineItem) ? get_class($issue_Purchase_Order_OutboundTypeRO_LineItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeRO_LineItem), var_export($issue_Purchase_Order_OutboundTypeRO_LineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RO_Line property can only contain items of type \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RO_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType[] $rO_Line
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setRO_Line(array $rO_Line = array())
    {
        // validation for constraint: array
        if ('' !== ($rO_LineArrayErrorMessage = self::validateRO_LineForArrayConstraintsFromSetRO_Line($rO_Line))) {
            throw new \InvalidArgumentException($rO_LineArrayErrorMessage, __LINE__);
        }
        $this->RO_Line = $rO_Line;
        return $this;
    }
    /**
     * Add item to RO_Line value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToRO_Line(\StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType) {
            throw new \InvalidArgumentException(sprintf('The RO_Line property can only contain items of type \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RO_Line[] = $item;
        return $this;
    }
    /**
     * Get Service_Line_Data value
     * @return \StructType\Purchase_Order_Service_Lines_DataType[]|null
     */
    public function getService_Line_Data()
    {
        return $this->Service_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setService_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateService_Line_DataForArrayConstraintsFromSetService_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeService_Line_DataItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeService_Line_DataItem instanceof \StructType\Purchase_Order_Service_Lines_DataType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeService_Line_DataItem) ? get_class($issue_Purchase_Order_OutboundTypeService_Line_DataItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeService_Line_DataItem), var_export($issue_Purchase_Order_OutboundTypeService_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service_Line_Data property can only contain items of type \StructType\Purchase_Order_Service_Lines_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Service_Lines_DataType[] $service_Line_Data
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setService_Line_Data(array $service_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($service_Line_DataArrayErrorMessage = self::validateService_Line_DataForArrayConstraintsFromSetService_Line_Data($service_Line_Data))) {
            throw new \InvalidArgumentException($service_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Service_Line_Data = $service_Line_Data;
        return $this;
    }
    /**
     * Add item to Service_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Service_Lines_DataType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToService_Line_Data(\StructType\Purchase_Order_Service_Lines_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Service_Lines_DataType) {
            throw new \InvalidArgumentException(sprintf('The Service_Line_Data property can only contain items of type \StructType\Purchase_Order_Service_Lines_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Tax_Code_Data value
     * @return \StructType\Taxable_Code_Application_NO_INPUT_DataType[]|null
     */
    public function getTax_Code_Data()
    {
        return $this->Tax_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Code_DataForArrayConstraintsFromSetTax_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypeTax_Code_DataItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypeTax_Code_DataItem instanceof \StructType\Taxable_Code_Application_NO_INPUT_DataType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypeTax_Code_DataItem) ? get_class($issue_Purchase_Order_OutboundTypeTax_Code_DataItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypeTax_Code_DataItem), var_export($issue_Purchase_Order_OutboundTypeTax_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_NO_INPUT_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_NO_INPUT_DataType[] $tax_Code_Data
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setTax_Code_Data(array $tax_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Code_DataArrayErrorMessage = self::validateTax_Code_DataForArrayConstraintsFromSetTax_Code_Data($tax_Code_Data))) {
            throw new \InvalidArgumentException($tax_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Tax_Code_Data = $tax_Code_Data;
        return $this;
    }
    /**
     * Add item to Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_NO_INPUT_DataType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToTax_Code_Data(\StructType\Taxable_Code_Application_NO_INPUT_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Taxable_Code_Application_NO_INPUT_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_NO_INPUT_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Code_Data[] = $item;
        return $this;
    }
    /**
     * Get PO_Attachments value
     * @return \StructType\Business_Document_Attachments_for_PO_IssueType[]|null
     */
    public function getPO_Attachments()
    {
        return $this->PO_Attachments;
    }
    /**
     * This method is responsible for validating the values passed to the setPO_Attachments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPO_Attachments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePO_AttachmentsForArrayConstraintsFromSetPO_Attachments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $issue_Purchase_Order_OutboundTypePO_AttachmentsItem) {
            // validation for constraint: itemType
            if (!$issue_Purchase_Order_OutboundTypePO_AttachmentsItem instanceof \StructType\Business_Document_Attachments_for_PO_IssueType) {
                $invalidValues[] = is_object($issue_Purchase_Order_OutboundTypePO_AttachmentsItem) ? get_class($issue_Purchase_Order_OutboundTypePO_AttachmentsItem) : sprintf('%s(%s)', gettype($issue_Purchase_Order_OutboundTypePO_AttachmentsItem), var_export($issue_Purchase_Order_OutboundTypePO_AttachmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PO_Attachments property can only contain items of type \StructType\Business_Document_Attachments_for_PO_IssueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PO_Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachments_for_PO_IssueType[] $pO_Attachments
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setPO_Attachments(array $pO_Attachments = array())
    {
        // validation for constraint: array
        if ('' !== ($pO_AttachmentsArrayErrorMessage = self::validatePO_AttachmentsForArrayConstraintsFromSetPO_Attachments($pO_Attachments))) {
            throw new \InvalidArgumentException($pO_AttachmentsArrayErrorMessage, __LINE__);
        }
        $this->PO_Attachments = $pO_Attachments;
        return $this;
    }
    /**
     * Add item to PO_Attachments value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachments_for_PO_IssueType $item
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function addToPO_Attachments(\StructType\Business_Document_Attachments_for_PO_IssueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachments_for_PO_IssueType) {
            throw new \InvalidArgumentException(sprintf('The PO_Attachments property can only contain items of type \StructType\Business_Document_Attachments_for_PO_IssueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PO_Attachments[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Issue_Purchase_Order_OutboundType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
