<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_Template_Criteria_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to request certain Worktag Split Templates
 * @subpackage Structs
 */
class Worktag_Split_Template_Criteria_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Template_Restriction_Name
     * Meta information extracted from the WSDL
     * - documentation: Name for Worktag Split Template Criteria
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Template_Restriction_Name;
    /**
     * The Restricted_By_Companies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Restrict by Companies and Company Hierarchies for Worktag Split Template Criteria
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Restricted_By_Companies_Reference;
    /**
     * Constructor method for Worktag_Split_Template_Criteria_Request_CriteriaType
     * @uses Worktag_Split_Template_Criteria_Request_CriteriaType::setTemplate_Restriction_Name()
     * @uses Worktag_Split_Template_Criteria_Request_CriteriaType::setRestricted_By_Companies_Reference()
     * @param string $template_Restriction_Name
     * @param \StructType\OrganizationObjectType[] $restricted_By_Companies_Reference
     */
    public function __construct($template_Restriction_Name = null, array $restricted_By_Companies_Reference = array())
    {
        $this
            ->setTemplate_Restriction_Name($template_Restriction_Name)
            ->setRestricted_By_Companies_Reference($restricted_By_Companies_Reference);
    }
    /**
     * Get Template_Restriction_Name value
     * @return string|null
     */
    public function getTemplate_Restriction_Name()
    {
        return $this->Template_Restriction_Name;
    }
    /**
     * Set Template_Restriction_Name value
     * @param string $template_Restriction_Name
     * @return \StructType\Worktag_Split_Template_Criteria_Request_CriteriaType
     */
    public function setTemplate_Restriction_Name($template_Restriction_Name = null)
    {
        // validation for constraint: string
        if (!is_null($template_Restriction_Name) && !is_string($template_Restriction_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_Restriction_Name, true), gettype($template_Restriction_Name)), __LINE__);
        }
        $this->Template_Restriction_Name = $template_Restriction_Name;
        return $this;
    }
    /**
     * Get Restricted_By_Companies_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getRestricted_By_Companies_Reference()
    {
        return $this->Restricted_By_Companies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_By_Companies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_By_Companies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_By_Companies_ReferenceForArrayConstraintsFromSetRestricted_By_Companies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_Template_Criteria_Request_CriteriaTypeRestricted_By_Companies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_Template_Criteria_Request_CriteriaTypeRestricted_By_Companies_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($worktag_Split_Template_Criteria_Request_CriteriaTypeRestricted_By_Companies_ReferenceItem) ? get_class($worktag_Split_Template_Criteria_Request_CriteriaTypeRestricted_By_Companies_ReferenceItem) : sprintf('%s(%s)', gettype($worktag_Split_Template_Criteria_Request_CriteriaTypeRestricted_By_Companies_ReferenceItem), var_export($worktag_Split_Template_Criteria_Request_CriteriaTypeRestricted_By_Companies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_By_Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_By_Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $restricted_By_Companies_Reference
     * @return \StructType\Worktag_Split_Template_Criteria_Request_CriteriaType
     */
    public function setRestricted_By_Companies_Reference(array $restricted_By_Companies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_By_Companies_ReferenceArrayErrorMessage = self::validateRestricted_By_Companies_ReferenceForArrayConstraintsFromSetRestricted_By_Companies_Reference($restricted_By_Companies_Reference))) {
            throw new \InvalidArgumentException($restricted_By_Companies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_By_Companies_Reference = $restricted_By_Companies_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_By_Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Worktag_Split_Template_Criteria_Request_CriteriaType
     */
    public function addToRestricted_By_Companies_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_By_Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_By_Companies_Reference[] = $item;
        return $this;
    }
}
