<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receipt Adjustment Date On or After must be earlier than Receipt Adjustment Date On or Before. | Element containing search criteria to find receipt adjustments in the Workday system.
 * @subpackage Structs
 */
class Receipt_Adjustment_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Filter Receipt Adjustments by Company
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Filter Receipt Adjustments by Purchase Order
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Filter Receipt Adjustments by Supplier
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Receipt_Reference
     * Meta information extracted from the WSDL
     * - documentation: Filter Receipt Adjustments by Receipt Adjusted
     * - minOccurs: 0
     * @var \StructType\ReceiptObjectType
     */
    public $Receipt_Reference;
    /**
     * The Created_by_Person_Reference
     * Meta information extracted from the WSDL
     * - documentation: Filter Receipt Adjustments by Created by Person
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Created_by_Person_Reference;
    /**
     * The Receipt_Adjustment_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Receipt Adjustment Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Adjustment_Date_On_or_After;
    /**
     * The Receipt_Adjustment_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Receipt Adjustment Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Adjustment_Date_On_or_Before;
    /**
     * Constructor method for Receipt_Adjustment_Request_CriteriaType
     * @uses Receipt_Adjustment_Request_CriteriaType::setCompany_Reference()
     * @uses Receipt_Adjustment_Request_CriteriaType::setPurchase_Order_Reference()
     * @uses Receipt_Adjustment_Request_CriteriaType::setSupplier_Reference()
     * @uses Receipt_Adjustment_Request_CriteriaType::setReceipt_Reference()
     * @uses Receipt_Adjustment_Request_CriteriaType::setCreated_by_Person_Reference()
     * @uses Receipt_Adjustment_Request_CriteriaType::setReceipt_Adjustment_Date_On_or_After()
     * @uses Receipt_Adjustment_Request_CriteriaType::setReceipt_Adjustment_Date_On_or_Before()
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @param \StructType\Unique_IdentifierObjectType $created_by_Person_Reference
     * @param string $receipt_Adjustment_Date_On_or_After
     * @param string $receipt_Adjustment_Date_On_or_Before
     */
    public function __construct(\StructType\CompanyObjectType $company_Reference = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\ReceiptObjectType $receipt_Reference = null, \StructType\Unique_IdentifierObjectType $created_by_Person_Reference = null, $receipt_Adjustment_Date_On_or_After = null, $receipt_Adjustment_Date_On_or_Before = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setReceipt_Reference($receipt_Reference)
            ->setCreated_by_Person_Reference($created_by_Person_Reference)
            ->setReceipt_Adjustment_Date_On_or_After($receipt_Adjustment_Date_On_or_After)
            ->setReceipt_Adjustment_Date_On_or_Before($receipt_Adjustment_Date_On_or_Before);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Receipt_Adjustment_Request_CriteriaType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Receipt_Adjustment_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Receipt_Adjustment_Request_CriteriaType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Receipt_Reference value
     * @return \StructType\ReceiptObjectType|null
     */
    public function getReceipt_Reference()
    {
        return $this->Receipt_Reference;
    }
    /**
     * Set Receipt_Reference value
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @return \StructType\Receipt_Adjustment_Request_CriteriaType
     */
    public function setReceipt_Reference(\StructType\ReceiptObjectType $receipt_Reference = null)
    {
        $this->Receipt_Reference = $receipt_Reference;
        return $this;
    }
    /**
     * Get Created_by_Person_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getCreated_by_Person_Reference()
    {
        return $this->Created_by_Person_Reference;
    }
    /**
     * Set Created_by_Person_Reference value
     * @param \StructType\Unique_IdentifierObjectType $created_by_Person_Reference
     * @return \StructType\Receipt_Adjustment_Request_CriteriaType
     */
    public function setCreated_by_Person_Reference(\StructType\Unique_IdentifierObjectType $created_by_Person_Reference = null)
    {
        $this->Created_by_Person_Reference = $created_by_Person_Reference;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Date_On_or_After value
     * @return string|null
     */
    public function getReceipt_Adjustment_Date_On_or_After()
    {
        return $this->Receipt_Adjustment_Date_On_or_After;
    }
    /**
     * Set Receipt_Adjustment_Date_On_or_After value
     * @param string $receipt_Adjustment_Date_On_or_After
     * @return \StructType\Receipt_Adjustment_Request_CriteriaType
     */
    public function setReceipt_Adjustment_Date_On_or_After($receipt_Adjustment_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Adjustment_Date_On_or_After) && !is_string($receipt_Adjustment_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Adjustment_Date_On_or_After, true), gettype($receipt_Adjustment_Date_On_or_After)), __LINE__);
        }
        $this->Receipt_Adjustment_Date_On_or_After = $receipt_Adjustment_Date_On_or_After;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Date_On_or_Before value
     * @return string|null
     */
    public function getReceipt_Adjustment_Date_On_or_Before()
    {
        return $this->Receipt_Adjustment_Date_On_or_Before;
    }
    /**
     * Set Receipt_Adjustment_Date_On_or_Before value
     * @param string $receipt_Adjustment_Date_On_or_Before
     * @return \StructType\Receipt_Adjustment_Request_CriteriaType
     */
    public function setReceipt_Adjustment_Date_On_or_Before($receipt_Adjustment_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Adjustment_Date_On_or_Before) && !is_string($receipt_Adjustment_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Adjustment_Date_On_or_Before, true), gettype($receipt_Adjustment_Date_On_or_Before)), __LINE__);
        }
        $this->Receipt_Adjustment_Date_On_or_Before = $receipt_Adjustment_Date_On_or_Before;
        return $this;
    }
}
