<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_Item_LineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all editable fields for Receipt Adjustment Item Line
 * @subpackage Structs
 */
class Receipt_Adjustment_Item_LineType extends AbstractStructBase
{
    /**
     * The Receipt_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receipt Line Reference to be adjusted
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Receipt_Line_Reference;
    /**
     * The Actual_Quantity_Received
     * Meta information extracted from the WSDL
     * - documentation: The Actual Quantity Received for this Line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Actual_Quantity_Received;
    /**
     * The Receipt_Adjustment_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Adjustment Reason for this Receipt Adjustment Line
     * - minOccurs: 0
     * @var \StructType\Reason_CodeObjectType
     */
    public $Receipt_Adjustment_Reason_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Receipt Adjustment Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Receipt_Line_Lot_Data
     * Meta information extracted from the WSDL
     * - documentation: Receipt Line Item Lot Quantity Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Adjustment_Item_Line_LotType[]
     */
    public $Receipt_Line_Lot_Data;
    /**
     * Constructor method for Receipt_Adjustment_Item_LineType
     * @uses Receipt_Adjustment_Item_LineType::setReceipt_Line_Reference()
     * @uses Receipt_Adjustment_Item_LineType::setActual_Quantity_Received()
     * @uses Receipt_Adjustment_Item_LineType::setReceipt_Adjustment_Reason_Reference()
     * @uses Receipt_Adjustment_Item_LineType::setMemo()
     * @uses Receipt_Adjustment_Item_LineType::setReceipt_Line_Lot_Data()
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @param float $actual_Quantity_Received
     * @param \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference
     * @param string $memo
     * @param \StructType\Receipt_Adjustment_Item_Line_LotType[] $receipt_Line_Lot_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null, $actual_Quantity_Received = null, \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference = null, $memo = null, array $receipt_Line_Lot_Data = array())
    {
        $this
            ->setReceipt_Line_Reference($receipt_Line_Reference)
            ->setActual_Quantity_Received($actual_Quantity_Received)
            ->setReceipt_Adjustment_Reason_Reference($receipt_Adjustment_Reason_Reference)
            ->setMemo($memo)
            ->setReceipt_Line_Lot_Data($receipt_Line_Lot_Data);
    }
    /**
     * Get Receipt_Line_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReceipt_Line_Reference()
    {
        return $this->Receipt_Line_Reference;
    }
    /**
     * Set Receipt_Line_Reference value
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @return \StructType\Receipt_Adjustment_Item_LineType
     */
    public function setReceipt_Line_Reference(\StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null)
    {
        $this->Receipt_Line_Reference = $receipt_Line_Reference;
        return $this;
    }
    /**
     * Get Actual_Quantity_Received value
     * @return float|null
     */
    public function getActual_Quantity_Received()
    {
        return $this->Actual_Quantity_Received;
    }
    /**
     * Set Actual_Quantity_Received value
     * @param float $actual_Quantity_Received
     * @return \StructType\Receipt_Adjustment_Item_LineType
     */
    public function setActual_Quantity_Received($actual_Quantity_Received = null)
    {
        // validation for constraint: float
        if (!is_null($actual_Quantity_Received) && !(is_float($actual_Quantity_Received) || is_numeric($actual_Quantity_Received))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actual_Quantity_Received, true), gettype($actual_Quantity_Received)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($actual_Quantity_Received) && mb_strlen(mb_substr($actual_Quantity_Received, false !== mb_strpos($actual_Quantity_Received, '.') ? mb_strpos($actual_Quantity_Received, '.') + 1 : mb_strlen($actual_Quantity_Received))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($actual_Quantity_Received, true), mb_strlen(mb_substr($actual_Quantity_Received, mb_strpos($actual_Quantity_Received, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($actual_Quantity_Received) && mb_strlen(preg_replace('/(\D)/', '', $actual_Quantity_Received)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($actual_Quantity_Received, true), mb_strlen(preg_replace('/(\D)/', '', $actual_Quantity_Received))), __LINE__);
        }
        $this->Actual_Quantity_Received = $actual_Quantity_Received;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Reason_Reference value
     * @return \StructType\Reason_CodeObjectType|null
     */
    public function getReceipt_Adjustment_Reason_Reference()
    {
        return $this->Receipt_Adjustment_Reason_Reference;
    }
    /**
     * Set Receipt_Adjustment_Reason_Reference value
     * @param \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference
     * @return \StructType\Receipt_Adjustment_Item_LineType
     */
    public function setReceipt_Adjustment_Reason_Reference(\StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference = null)
    {
        $this->Receipt_Adjustment_Reason_Reference = $receipt_Adjustment_Reason_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receipt_Adjustment_Item_LineType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Receipt_Line_Lot_Data value
     * @return \StructType\Receipt_Adjustment_Item_Line_LotType[]|null
     */
    public function getReceipt_Line_Lot_Data()
    {
        return $this->Receipt_Line_Lot_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Line_Lot_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Line_Lot_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Line_Lot_DataForArrayConstraintsFromSetReceipt_Line_Lot_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Item_LineTypeReceipt_Line_Lot_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Item_LineTypeReceipt_Line_Lot_DataItem instanceof \StructType\Receipt_Adjustment_Item_Line_LotType) {
                $invalidValues[] = is_object($receipt_Adjustment_Item_LineTypeReceipt_Line_Lot_DataItem) ? get_class($receipt_Adjustment_Item_LineTypeReceipt_Line_Lot_DataItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Item_LineTypeReceipt_Line_Lot_DataItem), var_export($receipt_Adjustment_Item_LineTypeReceipt_Line_Lot_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Line_Lot_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_Line_LotType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Line_Lot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_Line_LotType[] $receipt_Line_Lot_Data
     * @return \StructType\Receipt_Adjustment_Item_LineType
     */
    public function setReceipt_Line_Lot_Data(array $receipt_Line_Lot_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Line_Lot_DataArrayErrorMessage = self::validateReceipt_Line_Lot_DataForArrayConstraintsFromSetReceipt_Line_Lot_Data($receipt_Line_Lot_Data))) {
            throw new \InvalidArgumentException($receipt_Line_Lot_DataArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Line_Lot_Data = $receipt_Line_Lot_Data;
        return $this;
    }
    /**
     * Add item to Receipt_Line_Lot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_Line_LotType $item
     * @return \StructType\Receipt_Adjustment_Item_LineType
     */
    public function addToReceipt_Line_Lot_Data(\StructType\Receipt_Adjustment_Item_Line_LotType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Adjustment_Item_Line_LotType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Line_Lot_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_Line_LotType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Line_Lot_Data[] = $item;
        return $this;
    }
}
