<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prepaid_Spend_Amortization_Installment_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data representing one installment for the Prepaid Spend Amortization Schedule. An installment can be made up of many installment lines.
 * @subpackage Structs
 */
class Prepaid_Spend_Amortization_Installment_DataType extends AbstractStructBase
{
    /**
     * The Prepaid_Spend_Amortization_Installment_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to the installment that is being updated.
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_InstallmentObjectType
     */
    public $Prepaid_Spend_Amortization_Installment_Reference;
    /**
     * The Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: The date that accounting will use. This must match the start date.
     * - maxOccurs: 1
     * @var string
     */
    public $Accounting_Date;
    /**
     * The Prepaid_Spend_Amortization_Installment_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: A set of lines that make up this installment
     * - maxOccurs: unbounded
     * @var \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType[]
     */
    public $Prepaid_Spend_Amortization_Installment_Line_Data;
    /**
     * Constructor method for Prepaid_Spend_Amortization_Installment_DataType
     * @uses Prepaid_Spend_Amortization_Installment_DataType::setPrepaid_Spend_Amortization_Installment_Reference()
     * @uses Prepaid_Spend_Amortization_Installment_DataType::setAccounting_Date()
     * @uses Prepaid_Spend_Amortization_Installment_DataType::setPrepaid_Spend_Amortization_Installment_Line_Data()
     * @param \StructType\Prepaid_Spend_Amortization_InstallmentObjectType $prepaid_Spend_Amortization_Installment_Reference
     * @param string $accounting_Date
     * @param \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType[] $prepaid_Spend_Amortization_Installment_Line_Data
     */
    public function __construct(\StructType\Prepaid_Spend_Amortization_InstallmentObjectType $prepaid_Spend_Amortization_Installment_Reference = null, $accounting_Date = null, array $prepaid_Spend_Amortization_Installment_Line_Data = array())
    {
        $this
            ->setPrepaid_Spend_Amortization_Installment_Reference($prepaid_Spend_Amortization_Installment_Reference)
            ->setAccounting_Date($accounting_Date)
            ->setPrepaid_Spend_Amortization_Installment_Line_Data($prepaid_Spend_Amortization_Installment_Line_Data);
    }
    /**
     * Get Prepaid_Spend_Amortization_Installment_Reference value
     * @return \StructType\Prepaid_Spend_Amortization_InstallmentObjectType|null
     */
    public function getPrepaid_Spend_Amortization_Installment_Reference()
    {
        return $this->Prepaid_Spend_Amortization_Installment_Reference;
    }
    /**
     * Set Prepaid_Spend_Amortization_Installment_Reference value
     * @param \StructType\Prepaid_Spend_Amortization_InstallmentObjectType $prepaid_Spend_Amortization_Installment_Reference
     * @return \StructType\Prepaid_Spend_Amortization_Installment_DataType
     */
    public function setPrepaid_Spend_Amortization_Installment_Reference(\StructType\Prepaid_Spend_Amortization_InstallmentObjectType $prepaid_Spend_Amortization_Installment_Reference = null)
    {
        $this->Prepaid_Spend_Amortization_Installment_Reference = $prepaid_Spend_Amortization_Installment_Reference;
        return $this;
    }
    /**
     * Get Accounting_Date value
     * @return string|null
     */
    public function getAccounting_Date()
    {
        return $this->Accounting_Date;
    }
    /**
     * Set Accounting_Date value
     * @param string $accounting_Date
     * @return \StructType\Prepaid_Spend_Amortization_Installment_DataType
     */
    public function setAccounting_Date($accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Date) && !is_string($accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Date, true), gettype($accounting_Date)), __LINE__);
        }
        $this->Accounting_Date = $accounting_Date;
        return $this;
    }
    /**
     * Get Prepaid_Spend_Amortization_Installment_Line_Data value
     * @return \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType[]|null
     */
    public function getPrepaid_Spend_Amortization_Installment_Line_Data()
    {
        return $this->Prepaid_Spend_Amortization_Installment_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPrepaid_Spend_Amortization_Installment_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Spend_Amortization_Installment_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrepaid_Spend_Amortization_Installment_Line_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Installment_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $prepaid_Spend_Amortization_Installment_DataTypePrepaid_Spend_Amortization_Installment_Line_DataItem) {
            // validation for constraint: itemType
            if (!$prepaid_Spend_Amortization_Installment_DataTypePrepaid_Spend_Amortization_Installment_Line_DataItem instanceof \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType) {
                $invalidValues[] = is_object($prepaid_Spend_Amortization_Installment_DataTypePrepaid_Spend_Amortization_Installment_Line_DataItem) ? get_class($prepaid_Spend_Amortization_Installment_DataTypePrepaid_Spend_Amortization_Installment_Line_DataItem) : sprintf('%s(%s)', gettype($prepaid_Spend_Amortization_Installment_DataTypePrepaid_Spend_Amortization_Installment_Line_DataItem), var_export($prepaid_Spend_Amortization_Installment_DataTypePrepaid_Spend_Amortization_Installment_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prepaid_Spend_Amortization_Installment_Line_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Prepaid_Spend_Amortization_Installment_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType[] $prepaid_Spend_Amortization_Installment_Line_Data
     * @return \StructType\Prepaid_Spend_Amortization_Installment_DataType
     */
    public function setPrepaid_Spend_Amortization_Installment_Line_Data(array $prepaid_Spend_Amortization_Installment_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($prepaid_Spend_Amortization_Installment_Line_DataArrayErrorMessage = self::validatePrepaid_Spend_Amortization_Installment_Line_DataForArrayConstraintsFromSetPrepaid_Spend_Amortization_Installment_Line_Data($prepaid_Spend_Amortization_Installment_Line_Data))) {
            throw new \InvalidArgumentException($prepaid_Spend_Amortization_Installment_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Installment_Line_Data = $prepaid_Spend_Amortization_Installment_Line_Data;
        return $this;
    }
    /**
     * Add item to Prepaid_Spend_Amortization_Installment_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType $item
     * @return \StructType\Prepaid_Spend_Amortization_Installment_DataType
     */
    public function addToPrepaid_Spend_Amortization_Installment_Line_Data(\StructType\Prepaid_Spend_Amortization_Installment_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Prepaid_Spend_Amortization_Installment_Line_Data property can only contain items of type \StructType\Prepaid_Spend_Amortization_Installment_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Installment_Line_Data[] = $item;
        return $this;
    }
}
