<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company_Asset_Book_Restriction_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Response data for the company asset book restriction operation
 * @subpackage Structs
 */
class Company_Asset_Book_Restriction_Response_DataType extends AbstractStructBase
{
    /**
     * The Company_Asset_Book_Restriction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Company_Asset_Book_RestrictionType[]
     */
    public $Company_Asset_Book_Restriction;
    /**
     * Constructor method for Company_Asset_Book_Restriction_Response_DataType
     * @uses Company_Asset_Book_Restriction_Response_DataType::setCompany_Asset_Book_Restriction()
     * @param \StructType\Company_Asset_Book_RestrictionType[] $company_Asset_Book_Restriction
     */
    public function __construct(array $company_Asset_Book_Restriction = array())
    {
        $this
            ->setCompany_Asset_Book_Restriction($company_Asset_Book_Restriction);
    }
    /**
     * Get Company_Asset_Book_Restriction value
     * @return \StructType\Company_Asset_Book_RestrictionType[]|null
     */
    public function getCompany_Asset_Book_Restriction()
    {
        return $this->Company_Asset_Book_Restriction;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Asset_Book_Restriction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Asset_Book_Restriction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_Asset_Book_RestrictionForArrayConstraintsFromSetCompany_Asset_Book_Restriction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restriction_Response_DataTypeCompany_Asset_Book_RestrictionItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restriction_Response_DataTypeCompany_Asset_Book_RestrictionItem instanceof \StructType\Company_Asset_Book_RestrictionType) {
                $invalidValues[] = is_object($company_Asset_Book_Restriction_Response_DataTypeCompany_Asset_Book_RestrictionItem) ? get_class($company_Asset_Book_Restriction_Response_DataTypeCompany_Asset_Book_RestrictionItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restriction_Response_DataTypeCompany_Asset_Book_RestrictionItem), var_export($company_Asset_Book_Restriction_Response_DataTypeCompany_Asset_Book_RestrictionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Asset_Book_Restriction property can only contain items of type \StructType\Company_Asset_Book_RestrictionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Asset_Book_Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Asset_Book_RestrictionType[] $company_Asset_Book_Restriction
     * @return \StructType\Company_Asset_Book_Restriction_Response_DataType
     */
    public function setCompany_Asset_Book_Restriction(array $company_Asset_Book_Restriction = array())
    {
        // validation for constraint: array
        if ('' !== ($company_Asset_Book_RestrictionArrayErrorMessage = self::validateCompany_Asset_Book_RestrictionForArrayConstraintsFromSetCompany_Asset_Book_Restriction($company_Asset_Book_Restriction))) {
            throw new \InvalidArgumentException($company_Asset_Book_RestrictionArrayErrorMessage, __LINE__);
        }
        $this->Company_Asset_Book_Restriction = $company_Asset_Book_Restriction;
        return $this;
    }
    /**
     * Add item to Company_Asset_Book_Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Company_Asset_Book_RestrictionType $item
     * @return \StructType\Company_Asset_Book_Restriction_Response_DataType
     */
    public function addToCompany_Asset_Book_Restriction(\StructType\Company_Asset_Book_RestrictionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Company_Asset_Book_RestrictionType) {
            throw new \InvalidArgumentException(sprintf('The Company_Asset_Book_Restriction property can only contain items of type \StructType\Company_Asset_Book_RestrictionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Asset_Book_Restriction[] = $item;
        return $this;
    }
}
