<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adjust_Asset_Cost_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Quantity adjustments apply to all asset books. | You must enter either Adjustment Amount, Adjustment Quantity, or Residual Value Adjustment. | Element contains Business Process Parameters, Business Asset Reference for asset to
 * adjust, and asset cost adjustment details
 * @subpackage Structs
 */
class Adjust_Asset_Cost_RequestType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: You cannot adjust the cost of this asset due to a problem with its depreciation start date not aligning with the first period in the depreciation schedule. Please contact Support for assistance. | Cannot adjust cost of an asset
     * loaded into Workday as fully depreciated or transferred from a different company as fully depreciated | Cannot adjust the cost of this asset since it is out of service | Cannot adjust the cost of this asset since it is either disposed or pending
     * disposal | Cannot adjust the cost of this asset since accounting information has not been assigned yet | Cannot adjust the cost of expense assets | There is a pending event for the asset that should be completed before this asset transaction can be
     * processed. | Reference to the Business Asset which cost need to be adjusted
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Business_Asset_Cost_Adjustment_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Asset Cost Adjustment Data
     * @var \StructType\Business_Asset_Cost_Adjustment_DataType
     */
    public $Business_Asset_Cost_Adjustment_Data;
    /**
     * Constructor method for Adjust_Asset_Cost_RequestType
     * @uses Adjust_Asset_Cost_RequestType::setBusiness_Asset_Reference()
     * @uses Adjust_Asset_Cost_RequestType::setBusiness_Process_Parameters()
     * @uses Adjust_Asset_Cost_RequestType::setBusiness_Asset_Cost_Adjustment_Data()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Business_Asset_Cost_Adjustment_DataType $business_Asset_Cost_Adjustment_Data
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Business_Asset_Cost_Adjustment_DataType $business_Asset_Cost_Adjustment_Data = null)
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setBusiness_Asset_Cost_Adjustment_Data($business_Asset_Cost_Adjustment_Data);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Adjust_Asset_Cost_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Adjust_Asset_Cost_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Business_Asset_Cost_Adjustment_Data value
     * @return \StructType\Business_Asset_Cost_Adjustment_DataType|null
     */
    public function getBusiness_Asset_Cost_Adjustment_Data()
    {
        return $this->Business_Asset_Cost_Adjustment_Data;
    }
    /**
     * Set Business_Asset_Cost_Adjustment_Data value
     * @param \StructType\Business_Asset_Cost_Adjustment_DataType $business_Asset_Cost_Adjustment_Data
     * @return \StructType\Adjust_Asset_Cost_RequestType
     */
    public function setBusiness_Asset_Cost_Adjustment_Data(\StructType\Business_Asset_Cost_Adjustment_DataType $business_Asset_Cost_Adjustment_Data = null)
    {
        $this->Business_Asset_Cost_Adjustment_Data = $business_Asset_Cost_Adjustment_Data;
        return $this;
    }
}
