<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Work_Queue_Tag_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Invoice Work Queue Tag Response Data
 * @subpackage Structs
 */
class Supplier_Invoice_Work_Queue_Tag_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Work_Queue_Tag
     * Meta information extracted from the WSDL
     * - documentation: Wrapper Element that includes Supplier Invoice Work Queue Tag Instance and Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_TagType[]
     */
    public $Supplier_Invoice_Work_Queue_Tag;
    /**
     * Constructor method for Supplier_Invoice_Work_Queue_Tag_Response_DataType
     * @uses Supplier_Invoice_Work_Queue_Tag_Response_DataType::setSupplier_Invoice_Work_Queue_Tag()
     * @param \StructType\Supplier_Invoice_Work_Queue_TagType[] $supplier_Invoice_Work_Queue_Tag
     */
    public function __construct(array $supplier_Invoice_Work_Queue_Tag = array())
    {
        $this
            ->setSupplier_Invoice_Work_Queue_Tag($supplier_Invoice_Work_Queue_Tag);
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag value
     * @return \StructType\Supplier_Invoice_Work_Queue_TagType[]|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Work_Queue_Tag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Work_Queue_Tag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Work_Queue_TagForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Response_DataTypeSupplier_Invoice_Work_Queue_TagItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Response_DataTypeSupplier_Invoice_Work_Queue_TagItem instanceof \StructType\Supplier_Invoice_Work_Queue_TagType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Response_DataTypeSupplier_Invoice_Work_Queue_TagItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Response_DataTypeSupplier_Invoice_Work_Queue_TagItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Response_DataTypeSupplier_Invoice_Work_Queue_TagItem), var_export($supplier_Invoice_Work_Queue_Tag_Response_DataTypeSupplier_Invoice_Work_Queue_TagItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Work_Queue_Tag property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagType[] $supplier_Invoice_Work_Queue_Tag
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Response_DataType
     */
    public function setSupplier_Invoice_Work_Queue_Tag(array $supplier_Invoice_Work_Queue_Tag = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Work_Queue_TagArrayErrorMessage = self::validateSupplier_Invoice_Work_Queue_TagForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag($supplier_Invoice_Work_Queue_Tag))) {
            throw new \InvalidArgumentException($supplier_Invoice_Work_Queue_TagArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag = $supplier_Invoice_Work_Queue_Tag;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Work_Queue_Tag value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Response_DataType
     */
    public function addToSupplier_Invoice_Work_Queue_Tag(\StructType\Supplier_Invoice_Work_Queue_TagType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_TagType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Work_Queue_Tag property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag[] = $item;
        return $this;
    }
}
