<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Catalog_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This Supplier Catalog is currently in use by one or more Supplier Contracts. You may not modify the Currency or Supplier for a Supplier Catalog that is in use. | There is already a Catalog with that Name and Supplier. Please change
 * the Name or the Supplier before proceeding. | Element containing Supplier Catalog data.
 * @subpackage Structs
 */
class Supplier_Catalog_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Catalog_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Catalog Reference ID. This is the Supplier Catalog unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Catalog_Reference_ID;
    /**
     * The Catalog_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Catalog Name.
     * - maxOccurs: 1
     * @var string
     */
    public $Catalog_Name;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier. Note that this cannot be an Internal Service Provider.
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * Constructor method for Supplier_Catalog_DataType
     * @uses Supplier_Catalog_DataType::setSupplier_Catalog_Reference_ID()
     * @uses Supplier_Catalog_DataType::setCatalog_Name()
     * @uses Supplier_Catalog_DataType::setSupplier_Reference()
     * @uses Supplier_Catalog_DataType::setCurrency_Reference()
     * @param string $supplier_Catalog_Reference_ID
     * @param string $catalog_Name
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     */
    public function __construct($supplier_Catalog_Reference_ID = null, $catalog_Name = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this
            ->setSupplier_Catalog_Reference_ID($supplier_Catalog_Reference_ID)
            ->setCatalog_Name($catalog_Name)
            ->setSupplier_Reference($supplier_Reference)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Supplier_Catalog_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Catalog_Reference_ID()
    {
        return $this->Supplier_Catalog_Reference_ID;
    }
    /**
     * Set Supplier_Catalog_Reference_ID value
     * @param string $supplier_Catalog_Reference_ID
     * @return \StructType\Supplier_Catalog_DataType
     */
    public function setSupplier_Catalog_Reference_ID($supplier_Catalog_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Catalog_Reference_ID) && !is_string($supplier_Catalog_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Catalog_Reference_ID, true), gettype($supplier_Catalog_Reference_ID)), __LINE__);
        }
        $this->Supplier_Catalog_Reference_ID = $supplier_Catalog_Reference_ID;
        return $this;
    }
    /**
     * Get Catalog_Name value
     * @return string|null
     */
    public function getCatalog_Name()
    {
        return $this->Catalog_Name;
    }
    /**
     * Set Catalog_Name value
     * @param string $catalog_Name
     * @return \StructType\Supplier_Catalog_DataType
     */
    public function setCatalog_Name($catalog_Name = null)
    {
        // validation for constraint: string
        if (!is_null($catalog_Name) && !is_string($catalog_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalog_Name, true), gettype($catalog_Name)), __LINE__);
        }
        $this->Catalog_Name = $catalog_Name;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Supplier_Catalog_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Catalog_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
}
