<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Settlement_Bank_Account_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Routing Transit or Institution Number is required for this country. | Financial Account Number is required for this country. | IBAN is required for this country. | Settlement Account information including Bank Account Type, Currency,
 * Routing Transit Number, etc.Bank Account Type becomes required when using v30.1 of the web service.
 * @subpackage Structs
 */
class Settlement_Bank_Account_WWS_DataType extends AbstractStructBase
{
    /**
     * The Settlement_Bank_Account_ID
     * Meta information extracted from the WSDL
     * - documentation: Settlement Bank Account ID is a unique ID to the Settlement Bank Account
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Settlement_Bank_Account_ID;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Country Reference is a unique reference to a Country
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference is a unique reference to a Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Bank_Account_Nickname
     * Meta information extracted from the WSDL
     * - documentation: Bank Account Nickname
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bank_Account_Nickname;
    /**
     * The Bank_Account_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bank Account Type Reference is a unique reference to a Bank Account
     * - minOccurs: 0
     * @var \StructType\Bank_Account_TypeObjectType
     */
    public $Bank_Account_Type_Reference;
    /**
     * The Bank_Name
     * Meta information extracted from the WSDL
     * - documentation: Bank Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bank_Name;
    /**
     * The Routing_Transit_Number
     * Meta information extracted from the WSDL
     * - documentation: Routing Transit Number must adhere to bank routing account standards.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Routing_Transit_Number;
    /**
     * The Branch_ID
     * Meta information extracted from the WSDL
     * - documentation: Branch ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Branch_ID;
    /**
     * The Branch_Name
     * Meta information extracted from the WSDL
     * - documentation: Branch Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Branch_Name;
    /**
     * The Bank_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Bank Account Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bank_Account_Number;
    /**
     * The Check_Digit
     * Meta information extracted from the WSDL
     * - documentation: Collects the check digit when it is not part of the bank id number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Check_Digit;
    /**
     * The Bank_Account_Name
     * Meta information extracted from the WSDL
     * - documentation: Collects the bank account name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bank_Account_Name;
    /**
     * The Roll_Number
     * Meta information extracted from the WSDL
     * - documentation: Collects the Roll number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Roll_Number;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - documentation: International Bank Account Number (IBAN)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IBAN;
    /**
     * The SWIFT_Bank_Identification_Code
     * Meta information extracted from the WSDL
     * - documentation: Society for Worldwide Interbank Financial Telecommunication (SWIFT) Bank Identification Code (BIC)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SWIFT_Bank_Identification_Code;
    /**
     * The Accepts_Payment_Types_Reference
     * Meta information extracted from the WSDL
     * - documentation: Accepts Payment Types Reference is a reference to accepts payment types for a supplier.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType[]
     */
    public $Accepts_Payment_Types_Reference;
    /**
     * The Payment_Types_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Types can only be specified for Settlement Bank Accounts for Suppliers. | Only applicable for Suppliers. Reference to the Payment Types this Settlement Bank Account is intended for. Leave blank to designate this Settlement
     * Bank Account as the default for all Payment Types.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType[]
     */
    public $Payment_Types_Reference;
    /**
     * The For_Supplier_Connections_Only
     * Meta information extracted from the WSDL
     * - documentation: Designates this Settlement Bank Account to be used for Supplier Connections only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $For_Supplier_Connections_Only;
    /**
     * The Requires_Prenote
     * Meta information extracted from the WSDL
     * - documentation: Requires Prenote Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Requires_Prenote;
    /**
     * The Payment_Type_Prenote_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Type Prenote Reference
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Prenote_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Settlement Bank Account is inactive or active. A true value indicates the account is Inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Bank_Instructions
     * Meta information extracted from the WSDL
     * - documentation: Bank Instructions for FFC (For Further Credit).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bank_Instructions;
    /**
     * The Address_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address_Information_DataType[]
     */
    public $Address_Data;
    /**
     * The Intermediary_Bank_Widget_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Intermediary_Bank_Account_Widget_DataType
     */
    public $Intermediary_Bank_Widget_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to true if you wish to Delete the corresponding Settlement Bank Account only.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Settlement_Bank_Account_WWS_DataType
     * @uses Settlement_Bank_Account_WWS_DataType::setSettlement_Bank_Account_ID()
     * @uses Settlement_Bank_Account_WWS_DataType::setCountry_Reference()
     * @uses Settlement_Bank_Account_WWS_DataType::setCurrency_Reference()
     * @uses Settlement_Bank_Account_WWS_DataType::setBank_Account_Nickname()
     * @uses Settlement_Bank_Account_WWS_DataType::setBank_Account_Type_Reference()
     * @uses Settlement_Bank_Account_WWS_DataType::setBank_Name()
     * @uses Settlement_Bank_Account_WWS_DataType::setRouting_Transit_Number()
     * @uses Settlement_Bank_Account_WWS_DataType::setBranch_ID()
     * @uses Settlement_Bank_Account_WWS_DataType::setBranch_Name()
     * @uses Settlement_Bank_Account_WWS_DataType::setBank_Account_Number()
     * @uses Settlement_Bank_Account_WWS_DataType::setCheck_Digit()
     * @uses Settlement_Bank_Account_WWS_DataType::setBank_Account_Name()
     * @uses Settlement_Bank_Account_WWS_DataType::setRoll_Number()
     * @uses Settlement_Bank_Account_WWS_DataType::setIBAN()
     * @uses Settlement_Bank_Account_WWS_DataType::setSWIFT_Bank_Identification_Code()
     * @uses Settlement_Bank_Account_WWS_DataType::setAccepts_Payment_Types_Reference()
     * @uses Settlement_Bank_Account_WWS_DataType::setPayment_Types_Reference()
     * @uses Settlement_Bank_Account_WWS_DataType::setFor_Supplier_Connections_Only()
     * @uses Settlement_Bank_Account_WWS_DataType::setRequires_Prenote()
     * @uses Settlement_Bank_Account_WWS_DataType::setPayment_Type_Prenote_Reference()
     * @uses Settlement_Bank_Account_WWS_DataType::setInactive()
     * @uses Settlement_Bank_Account_WWS_DataType::setBank_Instructions()
     * @uses Settlement_Bank_Account_WWS_DataType::setAddress_Data()
     * @uses Settlement_Bank_Account_WWS_DataType::setIntermediary_Bank_Widget_Data()
     * @uses Settlement_Bank_Account_WWS_DataType::setDelete()
     * @param string $settlement_Bank_Account_ID
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $bank_Account_Nickname
     * @param \StructType\Bank_Account_TypeObjectType $bank_Account_Type_Reference
     * @param string $bank_Name
     * @param string $routing_Transit_Number
     * @param string $branch_ID
     * @param string $branch_Name
     * @param string $bank_Account_Number
     * @param string $check_Digit
     * @param string $bank_Account_Name
     * @param string $roll_Number
     * @param string $iBAN
     * @param string $sWIFT_Bank_Identification_Code
     * @param \StructType\Payment_TypeObjectType[] $accepts_Payment_Types_Reference
     * @param \StructType\Payment_TypeObjectType[] $payment_Types_Reference
     * @param bool $for_Supplier_Connections_Only
     * @param bool $requires_Prenote
     * @param \StructType\Payment_TypeObjectType $payment_Type_Prenote_Reference
     * @param bool $inactive
     * @param string $bank_Instructions
     * @param \StructType\Address_Information_DataType[] $address_Data
     * @param \StructType\Intermediary_Bank_Account_Widget_DataType $intermediary_Bank_Widget_Data
     * @param bool $delete
     */
    public function __construct($settlement_Bank_Account_ID = null, \StructType\CountryObjectType $country_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $bank_Account_Nickname = null, \StructType\Bank_Account_TypeObjectType $bank_Account_Type_Reference = null, $bank_Name = null, $routing_Transit_Number = null, $branch_ID = null, $branch_Name = null, $bank_Account_Number = null, $check_Digit = null, $bank_Account_Name = null, $roll_Number = null, $iBAN = null, $sWIFT_Bank_Identification_Code = null, array $accepts_Payment_Types_Reference = array(), array $payment_Types_Reference = array(), $for_Supplier_Connections_Only = null, $requires_Prenote = null, \StructType\Payment_TypeObjectType $payment_Type_Prenote_Reference = null, $inactive = null, $bank_Instructions = null, array $address_Data = array(), \StructType\Intermediary_Bank_Account_Widget_DataType $intermediary_Bank_Widget_Data = null, $delete = null)
    {
        $this
            ->setSettlement_Bank_Account_ID($settlement_Bank_Account_ID)
            ->setCountry_Reference($country_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setBank_Account_Nickname($bank_Account_Nickname)
            ->setBank_Account_Type_Reference($bank_Account_Type_Reference)
            ->setBank_Name($bank_Name)
            ->setRouting_Transit_Number($routing_Transit_Number)
            ->setBranch_ID($branch_ID)
            ->setBranch_Name($branch_Name)
            ->setBank_Account_Number($bank_Account_Number)
            ->setCheck_Digit($check_Digit)
            ->setBank_Account_Name($bank_Account_Name)
            ->setRoll_Number($roll_Number)
            ->setIBAN($iBAN)
            ->setSWIFT_Bank_Identification_Code($sWIFT_Bank_Identification_Code)
            ->setAccepts_Payment_Types_Reference($accepts_Payment_Types_Reference)
            ->setPayment_Types_Reference($payment_Types_Reference)
            ->setFor_Supplier_Connections_Only($for_Supplier_Connections_Only)
            ->setRequires_Prenote($requires_Prenote)
            ->setPayment_Type_Prenote_Reference($payment_Type_Prenote_Reference)
            ->setInactive($inactive)
            ->setBank_Instructions($bank_Instructions)
            ->setAddress_Data($address_Data)
            ->setIntermediary_Bank_Widget_Data($intermediary_Bank_Widget_Data)
            ->setDelete($delete);
    }
    /**
     * Get Settlement_Bank_Account_ID value
     * @return string|null
     */
    public function getSettlement_Bank_Account_ID()
    {
        return $this->Settlement_Bank_Account_ID;
    }
    /**
     * Set Settlement_Bank_Account_ID value
     * @param string $settlement_Bank_Account_ID
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setSettlement_Bank_Account_ID($settlement_Bank_Account_ID = null)
    {
        // validation for constraint: string
        if (!is_null($settlement_Bank_Account_ID) && !is_string($settlement_Bank_Account_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlement_Bank_Account_ID, true), gettype($settlement_Bank_Account_ID)), __LINE__);
        }
        $this->Settlement_Bank_Account_ID = $settlement_Bank_Account_ID;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Bank_Account_Nickname value
     * @return string|null
     */
    public function getBank_Account_Nickname()
    {
        return $this->Bank_Account_Nickname;
    }
    /**
     * Set Bank_Account_Nickname value
     * @param string $bank_Account_Nickname
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBank_Account_Nickname($bank_Account_Nickname = null)
    {
        // validation for constraint: string
        if (!is_null($bank_Account_Nickname) && !is_string($bank_Account_Nickname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_Account_Nickname, true), gettype($bank_Account_Nickname)), __LINE__);
        }
        $this->Bank_Account_Nickname = $bank_Account_Nickname;
        return $this;
    }
    /**
     * Get Bank_Account_Type_Reference value
     * @return \StructType\Bank_Account_TypeObjectType|null
     */
    public function getBank_Account_Type_Reference()
    {
        return $this->Bank_Account_Type_Reference;
    }
    /**
     * Set Bank_Account_Type_Reference value
     * @param \StructType\Bank_Account_TypeObjectType $bank_Account_Type_Reference
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBank_Account_Type_Reference(\StructType\Bank_Account_TypeObjectType $bank_Account_Type_Reference = null)
    {
        $this->Bank_Account_Type_Reference = $bank_Account_Type_Reference;
        return $this;
    }
    /**
     * Get Bank_Name value
     * @return string|null
     */
    public function getBank_Name()
    {
        return $this->Bank_Name;
    }
    /**
     * Set Bank_Name value
     * @param string $bank_Name
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBank_Name($bank_Name = null)
    {
        // validation for constraint: string
        if (!is_null($bank_Name) && !is_string($bank_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_Name, true), gettype($bank_Name)), __LINE__);
        }
        $this->Bank_Name = $bank_Name;
        return $this;
    }
    /**
     * Get Routing_Transit_Number value
     * @return string|null
     */
    public function getRouting_Transit_Number()
    {
        return $this->Routing_Transit_Number;
    }
    /**
     * Set Routing_Transit_Number value
     * @param string $routing_Transit_Number
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setRouting_Transit_Number($routing_Transit_Number = null)
    {
        // validation for constraint: string
        if (!is_null($routing_Transit_Number) && !is_string($routing_Transit_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routing_Transit_Number, true), gettype($routing_Transit_Number)), __LINE__);
        }
        $this->Routing_Transit_Number = $routing_Transit_Number;
        return $this;
    }
    /**
     * Get Branch_ID value
     * @return string|null
     */
    public function getBranch_ID()
    {
        return $this->Branch_ID;
    }
    /**
     * Set Branch_ID value
     * @param string $branch_ID
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBranch_ID($branch_ID = null)
    {
        // validation for constraint: string
        if (!is_null($branch_ID) && !is_string($branch_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branch_ID, true), gettype($branch_ID)), __LINE__);
        }
        $this->Branch_ID = $branch_ID;
        return $this;
    }
    /**
     * Get Branch_Name value
     * @return string|null
     */
    public function getBranch_Name()
    {
        return $this->Branch_Name;
    }
    /**
     * Set Branch_Name value
     * @param string $branch_Name
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBranch_Name($branch_Name = null)
    {
        // validation for constraint: string
        if (!is_null($branch_Name) && !is_string($branch_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branch_Name, true), gettype($branch_Name)), __LINE__);
        }
        $this->Branch_Name = $branch_Name;
        return $this;
    }
    /**
     * Get Bank_Account_Number value
     * @return string|null
     */
    public function getBank_Account_Number()
    {
        return $this->Bank_Account_Number;
    }
    /**
     * Set Bank_Account_Number value
     * @param string $bank_Account_Number
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBank_Account_Number($bank_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($bank_Account_Number) && !is_string($bank_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_Account_Number, true), gettype($bank_Account_Number)), __LINE__);
        }
        $this->Bank_Account_Number = $bank_Account_Number;
        return $this;
    }
    /**
     * Get Check_Digit value
     * @return string|null
     */
    public function getCheck_Digit()
    {
        return $this->Check_Digit;
    }
    /**
     * Set Check_Digit value
     * @param string $check_Digit
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setCheck_Digit($check_Digit = null)
    {
        // validation for constraint: string
        if (!is_null($check_Digit) && !is_string($check_Digit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($check_Digit, true), gettype($check_Digit)), __LINE__);
        }
        $this->Check_Digit = $check_Digit;
        return $this;
    }
    /**
     * Get Bank_Account_Name value
     * @return string|null
     */
    public function getBank_Account_Name()
    {
        return $this->Bank_Account_Name;
    }
    /**
     * Set Bank_Account_Name value
     * @param string $bank_Account_Name
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBank_Account_Name($bank_Account_Name = null)
    {
        // validation for constraint: string
        if (!is_null($bank_Account_Name) && !is_string($bank_Account_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_Account_Name, true), gettype($bank_Account_Name)), __LINE__);
        }
        $this->Bank_Account_Name = $bank_Account_Name;
        return $this;
    }
    /**
     * Get Roll_Number value
     * @return string|null
     */
    public function getRoll_Number()
    {
        return $this->Roll_Number;
    }
    /**
     * Set Roll_Number value
     * @param string $roll_Number
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setRoll_Number($roll_Number = null)
    {
        // validation for constraint: string
        if (!is_null($roll_Number) && !is_string($roll_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roll_Number, true), gettype($roll_Number)), __LINE__);
        }
        $this->Roll_Number = $roll_Number;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Get SWIFT_Bank_Identification_Code value
     * @return string|null
     */
    public function getSWIFT_Bank_Identification_Code()
    {
        return $this->SWIFT_Bank_Identification_Code;
    }
    /**
     * Set SWIFT_Bank_Identification_Code value
     * @param string $sWIFT_Bank_Identification_Code
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setSWIFT_Bank_Identification_Code($sWIFT_Bank_Identification_Code = null)
    {
        // validation for constraint: string
        if (!is_null($sWIFT_Bank_Identification_Code) && !is_string($sWIFT_Bank_Identification_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sWIFT_Bank_Identification_Code, true), gettype($sWIFT_Bank_Identification_Code)), __LINE__);
        }
        $this->SWIFT_Bank_Identification_Code = $sWIFT_Bank_Identification_Code;
        return $this;
    }
    /**
     * Get Accepts_Payment_Types_Reference value
     * @return \StructType\Payment_TypeObjectType[]|null
     */
    public function getAccepts_Payment_Types_Reference()
    {
        return $this->Accepts_Payment_Types_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAccepts_Payment_Types_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccepts_Payment_Types_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccepts_Payment_Types_ReferenceForArrayConstraintsFromSetAccepts_Payment_Types_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlement_Bank_Account_WWS_DataTypeAccepts_Payment_Types_ReferenceItem) {
            // validation for constraint: itemType
            if (!$settlement_Bank_Account_WWS_DataTypeAccepts_Payment_Types_ReferenceItem instanceof \StructType\Payment_TypeObjectType) {
                $invalidValues[] = is_object($settlement_Bank_Account_WWS_DataTypeAccepts_Payment_Types_ReferenceItem) ? get_class($settlement_Bank_Account_WWS_DataTypeAccepts_Payment_Types_ReferenceItem) : sprintf('%s(%s)', gettype($settlement_Bank_Account_WWS_DataTypeAccepts_Payment_Types_ReferenceItem), var_export($settlement_Bank_Account_WWS_DataTypeAccepts_Payment_Types_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Accepts_Payment_Types_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Accepts_Payment_Types_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType[] $accepts_Payment_Types_Reference
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setAccepts_Payment_Types_Reference(array $accepts_Payment_Types_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($accepts_Payment_Types_ReferenceArrayErrorMessage = self::validateAccepts_Payment_Types_ReferenceForArrayConstraintsFromSetAccepts_Payment_Types_Reference($accepts_Payment_Types_Reference))) {
            throw new \InvalidArgumentException($accepts_Payment_Types_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Accepts_Payment_Types_Reference = $accepts_Payment_Types_Reference;
        return $this;
    }
    /**
     * Add item to Accepts_Payment_Types_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType $item
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function addToAccepts_Payment_Types_Reference(\StructType\Payment_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Accepts_Payment_Types_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Accepts_Payment_Types_Reference[] = $item;
        return $this;
    }
    /**
     * Get Payment_Types_Reference value
     * @return \StructType\Payment_TypeObjectType[]|null
     */
    public function getPayment_Types_Reference()
    {
        return $this->Payment_Types_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment_Types_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment_Types_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayment_Types_ReferenceForArrayConstraintsFromSetPayment_Types_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlement_Bank_Account_WWS_DataTypePayment_Types_ReferenceItem) {
            // validation for constraint: itemType
            if (!$settlement_Bank_Account_WWS_DataTypePayment_Types_ReferenceItem instanceof \StructType\Payment_TypeObjectType) {
                $invalidValues[] = is_object($settlement_Bank_Account_WWS_DataTypePayment_Types_ReferenceItem) ? get_class($settlement_Bank_Account_WWS_DataTypePayment_Types_ReferenceItem) : sprintf('%s(%s)', gettype($settlement_Bank_Account_WWS_DataTypePayment_Types_ReferenceItem), var_export($settlement_Bank_Account_WWS_DataTypePayment_Types_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payment_Types_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payment_Types_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType[] $payment_Types_Reference
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setPayment_Types_Reference(array $payment_Types_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($payment_Types_ReferenceArrayErrorMessage = self::validatePayment_Types_ReferenceForArrayConstraintsFromSetPayment_Types_Reference($payment_Types_Reference))) {
            throw new \InvalidArgumentException($payment_Types_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Payment_Types_Reference = $payment_Types_Reference;
        return $this;
    }
    /**
     * Add item to Payment_Types_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType $item
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function addToPayment_Types_Reference(\StructType\Payment_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Payment_Types_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payment_Types_Reference[] = $item;
        return $this;
    }
    /**
     * Get For_Supplier_Connections_Only value
     * @return bool|null
     */
    public function getFor_Supplier_Connections_Only()
    {
        return $this->For_Supplier_Connections_Only;
    }
    /**
     * Set For_Supplier_Connections_Only value
     * @param bool $for_Supplier_Connections_Only
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setFor_Supplier_Connections_Only($for_Supplier_Connections_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($for_Supplier_Connections_Only) && !is_bool($for_Supplier_Connections_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($for_Supplier_Connections_Only, true), gettype($for_Supplier_Connections_Only)), __LINE__);
        }
        $this->For_Supplier_Connections_Only = $for_Supplier_Connections_Only;
        return $this;
    }
    /**
     * Get Requires_Prenote value
     * @return bool|null
     */
    public function getRequires_Prenote()
    {
        return $this->Requires_Prenote;
    }
    /**
     * Set Requires_Prenote value
     * @param bool $requires_Prenote
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setRequires_Prenote($requires_Prenote = null)
    {
        // validation for constraint: boolean
        if (!is_null($requires_Prenote) && !is_bool($requires_Prenote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requires_Prenote, true), gettype($requires_Prenote)), __LINE__);
        }
        $this->Requires_Prenote = $requires_Prenote;
        return $this;
    }
    /**
     * Get Payment_Type_Prenote_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Prenote_Reference()
    {
        return $this->Payment_Type_Prenote_Reference;
    }
    /**
     * Set Payment_Type_Prenote_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Prenote_Reference
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setPayment_Type_Prenote_Reference(\StructType\Payment_TypeObjectType $payment_Type_Prenote_Reference = null)
    {
        $this->Payment_Type_Prenote_Reference = $payment_Type_Prenote_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Bank_Instructions value
     * @return string|null
     */
    public function getBank_Instructions()
    {
        return $this->Bank_Instructions;
    }
    /**
     * Set Bank_Instructions value
     * @param string $bank_Instructions
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setBank_Instructions($bank_Instructions = null)
    {
        // validation for constraint: string
        if (!is_null($bank_Instructions) && !is_string($bank_Instructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bank_Instructions, true), gettype($bank_Instructions)), __LINE__);
        }
        $this->Bank_Instructions = $bank_Instructions;
        return $this;
    }
    /**
     * Get Address_Data value
     * @return \StructType\Address_Information_DataType[]|null
     */
    public function getAddress_Data()
    {
        return $this->Address_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddress_DataForArrayConstraintsFromSetAddress_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlement_Bank_Account_WWS_DataTypeAddress_DataItem) {
            // validation for constraint: itemType
            if (!$settlement_Bank_Account_WWS_DataTypeAddress_DataItem instanceof \StructType\Address_Information_DataType) {
                $invalidValues[] = is_object($settlement_Bank_Account_WWS_DataTypeAddress_DataItem) ? get_class($settlement_Bank_Account_WWS_DataTypeAddress_DataItem) : sprintf('%s(%s)', gettype($settlement_Bank_Account_WWS_DataTypeAddress_DataItem), var_export($settlement_Bank_Account_WWS_DataTypeAddress_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address_Data property can only contain items of type \StructType\Address_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_Information_DataType[] $address_Data
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setAddress_Data(array $address_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($address_DataArrayErrorMessage = self::validateAddress_DataForArrayConstraintsFromSetAddress_Data($address_Data))) {
            throw new \InvalidArgumentException($address_DataArrayErrorMessage, __LINE__);
        }
        $this->Address_Data = $address_Data;
        return $this;
    }
    /**
     * Add item to Address_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_Information_DataType $item
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function addToAddress_Data(\StructType\Address_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Address_Data property can only contain items of type \StructType\Address_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address_Data[] = $item;
        return $this;
    }
    /**
     * Get Intermediary_Bank_Widget_Data value
     * @return \StructType\Intermediary_Bank_Account_Widget_DataType|null
     */
    public function getIntermediary_Bank_Widget_Data()
    {
        return $this->Intermediary_Bank_Widget_Data;
    }
    /**
     * Set Intermediary_Bank_Widget_Data value
     * @param \StructType\Intermediary_Bank_Account_Widget_DataType $intermediary_Bank_Widget_Data
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setIntermediary_Bank_Widget_Data(\StructType\Intermediary_Bank_Account_Widget_DataType $intermediary_Bank_Widget_Data = null)
    {
        $this->Intermediary_Bank_Widget_Data = $intermediary_Bank_Widget_Data;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Settlement_Bank_Account_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
