<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Category_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Supplier Category
 * @subpackage Structs
 */
class Supplier_Category_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Category
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_CategoryObjectType[]
     */
    public $Supplier_Category_Reference;
    /**
     * Constructor method for Supplier_Category_Request_ReferencesType
     * @uses Supplier_Category_Request_ReferencesType::setSupplier_Category_Reference()
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Category_Reference
     */
    public function __construct(array $supplier_Category_Reference = array())
    {
        $this
            ->setSupplier_Category_Reference($supplier_Category_Reference);
    }
    /**
     * Get Supplier_Category_Reference value
     * @return \StructType\Supplier_CategoryObjectType[]|null
     */
    public function getSupplier_Category_Reference()
    {
        return $this->Supplier_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Category_ReferenceForArrayConstraintsFromSetSupplier_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Category_Request_ReferencesTypeSupplier_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Category_Request_ReferencesTypeSupplier_Category_ReferenceItem instanceof \StructType\Supplier_CategoryObjectType) {
                $invalidValues[] = is_object($supplier_Category_Request_ReferencesTypeSupplier_Category_ReferenceItem) ? get_class($supplier_Category_Request_ReferencesTypeSupplier_Category_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Category_Request_ReferencesTypeSupplier_Category_ReferenceItem), var_export($supplier_Category_Request_ReferencesTypeSupplier_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Category_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType[] $supplier_Category_Reference
     * @return \StructType\Supplier_Category_Request_ReferencesType
     */
    public function setSupplier_Category_Reference(array $supplier_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Category_ReferenceArrayErrorMessage = self::validateSupplier_Category_ReferenceForArrayConstraintsFromSetSupplier_Category_Reference($supplier_Category_Reference))) {
            throw new \InvalidArgumentException($supplier_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Category_Reference = $supplier_Category_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_CategoryObjectType $item
     * @return \StructType\Supplier_Category_Request_ReferencesType
     */
    public function addToSupplier_Category_Reference(\StructType\Supplier_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Category_Reference property can only contain items of type \StructType\Supplier_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Category_Reference[] = $item;
        return $this;
    }
}
