<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of the entire RFQ Response Document
 * @subpackage Structs
 */
class RFQ_Response_DataType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Response_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for RFQ Response Document
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Response_ID;
    /**
     * The Request_for_Quote_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Request for Quote document that is associated with the RFQ Response.
     * - minOccurs: 0
     * @var \StructType\Request_for_QuoteObjectType
     */
    public $Request_for_Quote_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company on the RFQ Response.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier who responded to the RFQ.
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The RFQ_Response_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The status of the RFQ Response document.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $RFQ_Response_Status_Reference;
    /**
     * The Response_Date
     * Meta information extracted from the WSDL
     * - documentation: The date on which the RFQ Response was created.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Date;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The currency on the Request for Quote document.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Recorded_By
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contact who recorded the response to the RFQ.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recorded_By;
    /**
     * The Shipping_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping terms on Request for Quote Response.
     * - minOccurs: 0
     * @var \StructType\Shipping_TermsObjectType
     */
    public $Shipping_Terms_Reference;
    /**
     * The Shipping_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping method on Request for Quote Response.
     * - minOccurs: 0
     * @var \StructType\Shipping_MethodObjectType
     */
    public $Shipping_Method_Reference;
    /**
     * The Shipping_Instruction
     * Meta information extracted from the WSDL
     * - documentation: Shipping instructions on Request for Quote Response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping_Instruction;
    /**
     * The Response_Memo
     * Meta information extracted from the WSDL
     * - documentation: Response Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Memo;
    /**
     * The RFQ_Document_Date
     * Meta information extracted from the WSDL
     * - documentation: The date on which the RFQ was created.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Document_Date;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Sourcing_Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Sourcing Buyer on RFQ
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Sourcing_Buyer_Reference;
    /**
     * The RFQ_Document_Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo recorded on Request for Quote
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Document_Memo;
    /**
     * The Request_for_Quote_Terms_and_Conditions
     * Meta information extracted from the WSDL
     * - documentation: Terms and conditions on Request for Quote.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Terms_and_Conditions;
    /**
     * The Request_for_Quote_Response_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures information related to RFQ response lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Response_Line_DataType[]
     */
    public $Request_for_Quote_Response_Line_Data;
    /**
     * The RFQ_Response_Bid_Response_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that contains information related to RFQ Bid responses.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Header_or_Line_Bid_Response_DataType[]
     */
    public $RFQ_Response_Bid_Response_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for RFQ_Response_DataType
     * @uses RFQ_Response_DataType::setRequest_for_Quote_Response_ID()
     * @uses RFQ_Response_DataType::setRequest_for_Quote_Reference()
     * @uses RFQ_Response_DataType::setCompany_Reference()
     * @uses RFQ_Response_DataType::setSupplier_Reference()
     * @uses RFQ_Response_DataType::setRFQ_Response_Status_Reference()
     * @uses RFQ_Response_DataType::setResponse_Date()
     * @uses RFQ_Response_DataType::setCurrency_Reference()
     * @uses RFQ_Response_DataType::setRecorded_By()
     * @uses RFQ_Response_DataType::setShipping_Terms_Reference()
     * @uses RFQ_Response_DataType::setShipping_Method_Reference()
     * @uses RFQ_Response_DataType::setShipping_Instruction()
     * @uses RFQ_Response_DataType::setResponse_Memo()
     * @uses RFQ_Response_DataType::setRFQ_Document_Date()
     * @uses RFQ_Response_DataType::setStart_Date()
     * @uses RFQ_Response_DataType::setEnd_Date()
     * @uses RFQ_Response_DataType::setSourcing_Buyer_Reference()
     * @uses RFQ_Response_DataType::setRFQ_Document_Memo()
     * @uses RFQ_Response_DataType::setRequest_for_Quote_Terms_and_Conditions()
     * @uses RFQ_Response_DataType::setRequest_for_Quote_Response_Line_Data()
     * @uses RFQ_Response_DataType::setRFQ_Response_Bid_Response_Data()
     * @uses RFQ_Response_DataType::setAttachment_Data()
     * @param string $request_for_Quote_Response_ID
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Document_StatusObjectType $rFQ_Response_Status_Reference
     * @param string $response_Date
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $recorded_By
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @param string $shipping_Instruction
     * @param string $response_Memo
     * @param string $rFQ_Document_Date
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @param string $rFQ_Document_Memo
     * @param string $request_for_Quote_Terms_and_Conditions
     * @param \StructType\RFQ_Response_Line_DataType[] $request_for_Quote_Response_Line_Data
     * @param \StructType\RFQ_Header_or_Line_Bid_Response_DataType[] $rFQ_Response_Bid_Response_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     */
    public function __construct($request_for_Quote_Response_ID = null, \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Document_StatusObjectType $rFQ_Response_Status_Reference = null, $response_Date = null, \StructType\CurrencyObjectType $currency_Reference = null, $recorded_By = null, \StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null, \StructType\Shipping_MethodObjectType $shipping_Method_Reference = null, $shipping_Instruction = null, $response_Memo = null, $rFQ_Document_Date = null, $start_Date = null, $end_Date = null, \StructType\WorkerObjectType $sourcing_Buyer_Reference = null, $rFQ_Document_Memo = null, $request_for_Quote_Terms_and_Conditions = null, array $request_for_Quote_Response_Line_Data = array(), array $rFQ_Response_Bid_Response_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setRequest_for_Quote_Response_ID($request_for_Quote_Response_ID)
            ->setRequest_for_Quote_Reference($request_for_Quote_Reference)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setRFQ_Response_Status_Reference($rFQ_Response_Status_Reference)
            ->setResponse_Date($response_Date)
            ->setCurrency_Reference($currency_Reference)
            ->setRecorded_By($recorded_By)
            ->setShipping_Terms_Reference($shipping_Terms_Reference)
            ->setShipping_Method_Reference($shipping_Method_Reference)
            ->setShipping_Instruction($shipping_Instruction)
            ->setResponse_Memo($response_Memo)
            ->setRFQ_Document_Date($rFQ_Document_Date)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setSourcing_Buyer_Reference($sourcing_Buyer_Reference)
            ->setRFQ_Document_Memo($rFQ_Document_Memo)
            ->setRequest_for_Quote_Terms_and_Conditions($request_for_Quote_Terms_and_Conditions)
            ->setRequest_for_Quote_Response_Line_Data($request_for_Quote_Response_Line_Data)
            ->setRFQ_Response_Bid_Response_Data($rFQ_Response_Bid_Response_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Request_for_Quote_Response_ID value
     * @return string|null
     */
    public function getRequest_for_Quote_Response_ID()
    {
        return $this->Request_for_Quote_Response_ID;
    }
    /**
     * Set Request_for_Quote_Response_ID value
     * @param string $request_for_Quote_Response_ID
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRequest_for_Quote_Response_ID($request_for_Quote_Response_ID = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Response_ID) && !is_string($request_for_Quote_Response_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Response_ID, true), gettype($request_for_Quote_Response_ID)), __LINE__);
        }
        $this->Request_for_Quote_Response_ID = $request_for_Quote_Response_ID;
        return $this;
    }
    /**
     * Get Request_for_Quote_Reference value
     * @return \StructType\Request_for_QuoteObjectType|null
     */
    public function getRequest_for_Quote_Reference()
    {
        return $this->Request_for_Quote_Reference;
    }
    /**
     * Set Request_for_Quote_Reference value
     * @param \StructType\Request_for_QuoteObjectType $request_for_Quote_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRequest_for_Quote_Reference(\StructType\Request_for_QuoteObjectType $request_for_Quote_Reference = null)
    {
        $this->Request_for_Quote_Reference = $request_for_Quote_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get RFQ_Response_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getRFQ_Response_Status_Reference()
    {
        return $this->RFQ_Response_Status_Reference;
    }
    /**
     * Set RFQ_Response_Status_Reference value
     * @param \StructType\Document_StatusObjectType $rFQ_Response_Status_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRFQ_Response_Status_Reference(\StructType\Document_StatusObjectType $rFQ_Response_Status_Reference = null)
    {
        $this->RFQ_Response_Status_Reference = $rFQ_Response_Status_Reference;
        return $this;
    }
    /**
     * Get Response_Date value
     * @return string|null
     */
    public function getResponse_Date()
    {
        return $this->Response_Date;
    }
    /**
     * Set Response_Date value
     * @param string $response_Date
     * @return \StructType\RFQ_Response_DataType
     */
    public function setResponse_Date($response_Date = null)
    {
        // validation for constraint: string
        if (!is_null($response_Date) && !is_string($response_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Date, true), gettype($response_Date)), __LINE__);
        }
        $this->Response_Date = $response_Date;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Recorded_By value
     * @return string|null
     */
    public function getRecorded_By()
    {
        return $this->Recorded_By;
    }
    /**
     * Set Recorded_By value
     * @param string $recorded_By
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRecorded_By($recorded_By = null)
    {
        // validation for constraint: string
        if (!is_null($recorded_By) && !is_string($recorded_By)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recorded_By, true), gettype($recorded_By)), __LINE__);
        }
        $this->Recorded_By = $recorded_By;
        return $this;
    }
    /**
     * Get Shipping_Terms_Reference value
     * @return \StructType\Shipping_TermsObjectType|null
     */
    public function getShipping_Terms_Reference()
    {
        return $this->Shipping_Terms_Reference;
    }
    /**
     * Set Shipping_Terms_Reference value
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setShipping_Terms_Reference(\StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null)
    {
        $this->Shipping_Terms_Reference = $shipping_Terms_Reference;
        return $this;
    }
    /**
     * Get Shipping_Method_Reference value
     * @return \StructType\Shipping_MethodObjectType|null
     */
    public function getShipping_Method_Reference()
    {
        return $this->Shipping_Method_Reference;
    }
    /**
     * Set Shipping_Method_Reference value
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setShipping_Method_Reference(\StructType\Shipping_MethodObjectType $shipping_Method_Reference = null)
    {
        $this->Shipping_Method_Reference = $shipping_Method_Reference;
        return $this;
    }
    /**
     * Get Shipping_Instruction value
     * @return string|null
     */
    public function getShipping_Instruction()
    {
        return $this->Shipping_Instruction;
    }
    /**
     * Set Shipping_Instruction value
     * @param string $shipping_Instruction
     * @return \StructType\RFQ_Response_DataType
     */
    public function setShipping_Instruction($shipping_Instruction = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_Instruction) && !is_string($shipping_Instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_Instruction, true), gettype($shipping_Instruction)), __LINE__);
        }
        $this->Shipping_Instruction = $shipping_Instruction;
        return $this;
    }
    /**
     * Get Response_Memo value
     * @return string|null
     */
    public function getResponse_Memo()
    {
        return $this->Response_Memo;
    }
    /**
     * Set Response_Memo value
     * @param string $response_Memo
     * @return \StructType\RFQ_Response_DataType
     */
    public function setResponse_Memo($response_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($response_Memo) && !is_string($response_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Memo, true), gettype($response_Memo)), __LINE__);
        }
        $this->Response_Memo = $response_Memo;
        return $this;
    }
    /**
     * Get RFQ_Document_Date value
     * @return string|null
     */
    public function getRFQ_Document_Date()
    {
        return $this->RFQ_Document_Date;
    }
    /**
     * Set RFQ_Document_Date value
     * @param string $rFQ_Document_Date
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRFQ_Document_Date($rFQ_Document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Document_Date) && !is_string($rFQ_Document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Document_Date, true), gettype($rFQ_Document_Date)), __LINE__);
        }
        $this->RFQ_Document_Date = $rFQ_Document_Date;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\RFQ_Response_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\RFQ_Response_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Sourcing_Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getSourcing_Buyer_Reference()
    {
        return $this->Sourcing_Buyer_Reference;
    }
    /**
     * Set Sourcing_Buyer_Reference value
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @return \StructType\RFQ_Response_DataType
     */
    public function setSourcing_Buyer_Reference(\StructType\WorkerObjectType $sourcing_Buyer_Reference = null)
    {
        $this->Sourcing_Buyer_Reference = $sourcing_Buyer_Reference;
        return $this;
    }
    /**
     * Get RFQ_Document_Memo value
     * @return string|null
     */
    public function getRFQ_Document_Memo()
    {
        return $this->RFQ_Document_Memo;
    }
    /**
     * Set RFQ_Document_Memo value
     * @param string $rFQ_Document_Memo
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRFQ_Document_Memo($rFQ_Document_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Document_Memo) && !is_string($rFQ_Document_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Document_Memo, true), gettype($rFQ_Document_Memo)), __LINE__);
        }
        $this->RFQ_Document_Memo = $rFQ_Document_Memo;
        return $this;
    }
    /**
     * Get Request_for_Quote_Terms_and_Conditions value
     * @return string|null
     */
    public function getRequest_for_Quote_Terms_and_Conditions()
    {
        return $this->Request_for_Quote_Terms_and_Conditions;
    }
    /**
     * Set Request_for_Quote_Terms_and_Conditions value
     * @param string $request_for_Quote_Terms_and_Conditions
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRequest_for_Quote_Terms_and_Conditions($request_for_Quote_Terms_and_Conditions = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Terms_and_Conditions) && !is_string($request_for_Quote_Terms_and_Conditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Terms_and_Conditions, true), gettype($request_for_Quote_Terms_and_Conditions)), __LINE__);
        }
        $this->Request_for_Quote_Terms_and_Conditions = $request_for_Quote_Terms_and_Conditions;
        return $this;
    }
    /**
     * Get Request_for_Quote_Response_Line_Data value
     * @return \StructType\RFQ_Response_Line_DataType[]|null
     */
    public function getRequest_for_Quote_Response_Line_Data()
    {
        return $this->Request_for_Quote_Response_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Response_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Response_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Response_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Response_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_DataTypeRequest_for_Quote_Response_Line_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_DataTypeRequest_for_Quote_Response_Line_DataItem instanceof \StructType\RFQ_Response_Line_DataType) {
                $invalidValues[] = is_object($rFQ_Response_DataTypeRequest_for_Quote_Response_Line_DataItem) ? get_class($rFQ_Response_DataTypeRequest_for_Quote_Response_Line_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_DataTypeRequest_for_Quote_Response_Line_DataItem), var_export($rFQ_Response_DataTypeRequest_for_Quote_Response_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Response_Line_Data property can only contain items of type \StructType\RFQ_Response_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Response_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Response_Line_DataType[] $request_for_Quote_Response_Line_Data
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRequest_for_Quote_Response_Line_Data(array $request_for_Quote_Response_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Response_Line_DataArrayErrorMessage = self::validateRequest_for_Quote_Response_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Response_Line_Data($request_for_Quote_Response_Line_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Response_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Response_Line_Data = $request_for_Quote_Response_Line_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Response_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Response_Line_DataType $item
     * @return \StructType\RFQ_Response_DataType
     */
    public function addToRequest_for_Quote_Response_Line_Data(\StructType\RFQ_Response_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Response_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Response_Line_Data property can only contain items of type \StructType\RFQ_Response_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Response_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get RFQ_Response_Bid_Response_Data value
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType[]|null
     */
    public function getRFQ_Response_Bid_Response_Data()
    {
        return $this->RFQ_Response_Bid_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Response_Bid_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Response_Bid_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Response_Bid_Response_DataForArrayConstraintsFromSetRFQ_Response_Bid_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_DataTypeRFQ_Response_Bid_Response_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_DataTypeRFQ_Response_Bid_Response_DataItem instanceof \StructType\RFQ_Header_or_Line_Bid_Response_DataType) {
                $invalidValues[] = is_object($rFQ_Response_DataTypeRFQ_Response_Bid_Response_DataItem) ? get_class($rFQ_Response_DataTypeRFQ_Response_Bid_Response_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_DataTypeRFQ_Response_Bid_Response_DataItem), var_export($rFQ_Response_DataTypeRFQ_Response_Bid_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Response_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_or_Line_Bid_Response_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Response_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_or_Line_Bid_Response_DataType[] $rFQ_Response_Bid_Response_Data
     * @return \StructType\RFQ_Response_DataType
     */
    public function setRFQ_Response_Bid_Response_Data(array $rFQ_Response_Bid_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Response_Bid_Response_DataArrayErrorMessage = self::validateRFQ_Response_Bid_Response_DataForArrayConstraintsFromSetRFQ_Response_Bid_Response_Data($rFQ_Response_Bid_Response_Data))) {
            throw new \InvalidArgumentException($rFQ_Response_Bid_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Response_Bid_Response_Data = $rFQ_Response_Bid_Response_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Response_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_or_Line_Bid_Response_DataType $item
     * @return \StructType\RFQ_Response_DataType
     */
    public function addToRFQ_Response_Bid_Response_Data(\StructType\RFQ_Header_or_Line_Bid_Response_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Header_or_Line_Bid_Response_DataType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Response_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_or_Line_Bid_Response_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Response_Bid_Response_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($rFQ_Response_DataTypeAttachment_DataItem) ? get_class($rFQ_Response_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_DataTypeAttachment_DataItem), var_export($rFQ_Response_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\RFQ_Response_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\RFQ_Response_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
