<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Guest Reference element contains the specific instance set containing the requested Guest.
 * @subpackage Structs
 */
class Guest_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Guest_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Guest object.
     * - maxOccurs: unbounded
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Guest_Reference;
    /**
     * Constructor method for Guest_Request_ReferencesType
     * @uses Guest_Request_ReferencesType::setGuest_Reference()
     * @param \StructType\Unique_IdentifierObjectType[] $guest_Reference
     */
    public function __construct(array $guest_Reference = array())
    {
        $this
            ->setGuest_Reference($guest_Reference);
    }
    /**
     * Get Guest_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getGuest_Reference()
    {
        return $this->Guest_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuest_ReferenceForArrayConstraintsFromSetGuest_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guest_Request_ReferencesTypeGuest_ReferenceItem) {
            // validation for constraint: itemType
            if (!$guest_Request_ReferencesTypeGuest_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($guest_Request_ReferencesTypeGuest_ReferenceItem) ? get_class($guest_Request_ReferencesTypeGuest_ReferenceItem) : sprintf('%s(%s)', gettype($guest_Request_ReferencesTypeGuest_ReferenceItem), var_export($guest_Request_ReferencesTypeGuest_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $guest_Reference
     * @return \StructType\Guest_Request_ReferencesType
     */
    public function setGuest_Reference(array $guest_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($guest_ReferenceArrayErrorMessage = self::validateGuest_ReferenceForArrayConstraintsFromSetGuest_Reference($guest_Reference))) {
            throw new \InvalidArgumentException($guest_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Guest_Reference = $guest_Reference;
        return $this;
    }
    /**
     * Add item to Guest_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Guest_Request_ReferencesType
     */
    public function addToGuest_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Guest_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest_Reference[] = $item;
        return $this;
    }
}
