<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Expense_Report_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Only certain Expense Reports are cancelable. | The Project Transaction Adjustment Event is in progress for this expense report. You can't cancel or update the expense report until the event completes. | You cannot cancel your expense
 * report or lines with an intercompany status of Billed. Cancel any billed intercompany invoices to update the expense report. | You can't cancel your expense report for project billable lines with a status of Billed, marked To Bill, or Revenue
 * Recognized. Cancel any Billed invoices or Completed Revenue Recognition installments, clear any lines marked To Bill, or both. | Element encapsulating the reference to the expense report that should be canceled.
 * @subpackage Structs
 */
class Cancel_Expense_Report_RequestType extends AbstractStructBase
{
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to expense report that should be canceled.
     * @var \StructType\Expense_ReportObjectType
     */
    public $Expense_Report_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Expense_Report_RequestType
     * @uses Cancel_Expense_Report_RequestType::setExpense_Report_Reference()
     * @uses Cancel_Expense_Report_RequestType::setVersion()
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @param string $version
     */
    public function __construct(\StructType\Expense_ReportObjectType $expense_Report_Reference = null, $version = null)
    {
        $this
            ->setExpense_Report_Reference($expense_Report_Reference)
            ->setVersion($version);
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * Set Expense_Report_Reference value
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @return \StructType\Cancel_Expense_Report_RequestType
     */
    public function setExpense_Report_Reference(\StructType\Expense_ReportObjectType $expense_Report_Reference = null)
    {
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Expense_Report_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
