<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_PoolType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Pool Element.
 * @subpackage Structs
 */
class Resource_PoolType extends AbstractStructBase
{
    /**
     * The Resource_Pool_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Reference.
     * - minOccurs: 0
     * @var \StructType\Resource_PoolObjectType
     */
    public $Resource_Pool_Reference;
    /**
     * The Resource_Pool_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_DataType[]
     */
    public $Resource_Pool_Data;
    /**
     * Constructor method for Resource_PoolType
     * @uses Resource_PoolType::setResource_Pool_Reference()
     * @uses Resource_PoolType::setResource_Pool_Data()
     * @param \StructType\Resource_PoolObjectType $resource_Pool_Reference
     * @param \StructType\Resource_Pool_DataType[] $resource_Pool_Data
     */
    public function __construct(\StructType\Resource_PoolObjectType $resource_Pool_Reference = null, array $resource_Pool_Data = array())
    {
        $this
            ->setResource_Pool_Reference($resource_Pool_Reference)
            ->setResource_Pool_Data($resource_Pool_Data);
    }
    /**
     * Get Resource_Pool_Reference value
     * @return \StructType\Resource_PoolObjectType|null
     */
    public function getResource_Pool_Reference()
    {
        return $this->Resource_Pool_Reference;
    }
    /**
     * Set Resource_Pool_Reference value
     * @param \StructType\Resource_PoolObjectType $resource_Pool_Reference
     * @return \StructType\Resource_PoolType
     */
    public function setResource_Pool_Reference(\StructType\Resource_PoolObjectType $resource_Pool_Reference = null)
    {
        $this->Resource_Pool_Reference = $resource_Pool_Reference;
        return $this;
    }
    /**
     * Get Resource_Pool_Data value
     * @return \StructType\Resource_Pool_DataType[]|null
     */
    public function getResource_Pool_Data()
    {
        return $this->Resource_Pool_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Pool_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Pool_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Pool_DataForArrayConstraintsFromSetResource_Pool_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_PoolTypeResource_Pool_DataItem) {
            // validation for constraint: itemType
            if (!$resource_PoolTypeResource_Pool_DataItem instanceof \StructType\Resource_Pool_DataType) {
                $invalidValues[] = is_object($resource_PoolTypeResource_Pool_DataItem) ? get_class($resource_PoolTypeResource_Pool_DataItem) : sprintf('%s(%s)', gettype($resource_PoolTypeResource_Pool_DataItem), var_export($resource_PoolTypeResource_Pool_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Pool_Data property can only contain items of type \StructType\Resource_Pool_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Pool_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_DataType[] $resource_Pool_Data
     * @return \StructType\Resource_PoolType
     */
    public function setResource_Pool_Data(array $resource_Pool_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Pool_DataArrayErrorMessage = self::validateResource_Pool_DataForArrayConstraintsFromSetResource_Pool_Data($resource_Pool_Data))) {
            throw new \InvalidArgumentException($resource_Pool_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Pool_Data = $resource_Pool_Data;
        return $this;
    }
    /**
     * Add item to Resource_Pool_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_DataType $item
     * @return \StructType\Resource_PoolType
     */
    public function addToResource_Pool_Data(\StructType\Resource_Pool_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Pool_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Pool_Data property can only contain items of type \StructType\Resource_Pool_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Pool_Data[] = $item;
        return $this;
    }
}
