<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Award_Line_Splits_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element to capture RFQ Award Line Splits information
 * @subpackage Structs
 */
class Request_for_Quote_Award_Line_Splits_DataType extends AbstractStructBase
{
    /**
     * The RFQ_Award_Line_Split_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Award_Line_Split_ID;
    /**
     * The RFQ_Award_Line_Split_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Line Split Reference. Only to be used with the Get Web Service to retrieve the Integration ID.
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_SplitObjectType
     */
    public $RFQ_Award_Line_Split_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Quantity;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo on RFQ Award Line Split
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Line_Split_Allocation_Reference
     * Meta information extracted from the WSDL
     * - documentation: Line Split Allocated From Reference
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_SplitObjectType
     */
    public $Line_Split_Allocation_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags on RFQ Award Line Split
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Request_for_Quote_Award_Line_Splits_DataType
     * @uses Request_for_Quote_Award_Line_Splits_DataType::setRFQ_Award_Line_Split_ID()
     * @uses Request_for_Quote_Award_Line_Splits_DataType::setRFQ_Award_Line_Split_Reference()
     * @uses Request_for_Quote_Award_Line_Splits_DataType::setQuantity()
     * @uses Request_for_Quote_Award_Line_Splits_DataType::setExtended_Amount()
     * @uses Request_for_Quote_Award_Line_Splits_DataType::setMemo()
     * @uses Request_for_Quote_Award_Line_Splits_DataType::setLine_Split_Allocation_Reference()
     * @uses Request_for_Quote_Award_Line_Splits_DataType::setWorktags_Reference()
     * @param string $rFQ_Award_Line_Split_ID
     * @param \StructType\Business_Document_Line_SplitObjectType $rFQ_Award_Line_Split_Reference
     * @param float $quantity
     * @param float $extended_Amount
     * @param string $memo
     * @param \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct($rFQ_Award_Line_Split_ID = null, \StructType\Business_Document_Line_SplitObjectType $rFQ_Award_Line_Split_Reference = null, $quantity = null, $extended_Amount = null, $memo = null, \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference = null, array $worktags_Reference = array())
    {
        $this
            ->setRFQ_Award_Line_Split_ID($rFQ_Award_Line_Split_ID)
            ->setRFQ_Award_Line_Split_Reference($rFQ_Award_Line_Split_Reference)
            ->setQuantity($quantity)
            ->setExtended_Amount($extended_Amount)
            ->setMemo($memo)
            ->setLine_Split_Allocation_Reference($line_Split_Allocation_Reference)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get RFQ_Award_Line_Split_ID value
     * @return string|null
     */
    public function getRFQ_Award_Line_Split_ID()
    {
        return $this->RFQ_Award_Line_Split_ID;
    }
    /**
     * Set RFQ_Award_Line_Split_ID value
     * @param string $rFQ_Award_Line_Split_ID
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function setRFQ_Award_Line_Split_ID($rFQ_Award_Line_Split_ID = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Award_Line_Split_ID) && !is_string($rFQ_Award_Line_Split_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Award_Line_Split_ID, true), gettype($rFQ_Award_Line_Split_ID)), __LINE__);
        }
        $this->RFQ_Award_Line_Split_ID = $rFQ_Award_Line_Split_ID;
        return $this;
    }
    /**
     * Get RFQ_Award_Line_Split_Reference value
     * @return \StructType\Business_Document_Line_SplitObjectType|null
     */
    public function getRFQ_Award_Line_Split_Reference()
    {
        return $this->RFQ_Award_Line_Split_Reference;
    }
    /**
     * Set RFQ_Award_Line_Split_Reference value
     * @param \StructType\Business_Document_Line_SplitObjectType $rFQ_Award_Line_Split_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function setRFQ_Award_Line_Split_Reference(\StructType\Business_Document_Line_SplitObjectType $rFQ_Award_Line_Split_Reference = null)
    {
        $this->RFQ_Award_Line_Split_Reference = $rFQ_Award_Line_Split_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Line_Split_Allocation_Reference value
     * @return \StructType\Business_Document_Line_SplitObjectType|null
     */
    public function getLine_Split_Allocation_Reference()
    {
        return $this->Line_Split_Allocation_Reference;
    }
    /**
     * Set Line_Split_Allocation_Reference value
     * @param \StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function setLine_Split_Allocation_Reference(\StructType\Business_Document_Line_SplitObjectType $line_Split_Allocation_Reference = null)
    {
        $this->Line_Split_Allocation_Reference = $line_Split_Allocation_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Award_Line_Splits_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Award_Line_Splits_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Award_Line_Splits_DataTypeWorktags_ReferenceItem) ? get_class($request_for_Quote_Award_Line_Splits_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Award_Line_Splits_DataTypeWorktags_ReferenceItem), var_export($request_for_Quote_Award_Line_Splits_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Request_for_Quote_Award_Line_Splits_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
