<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Counting_Attributes_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter a valid Inventory ABC Classification | Attributes related to Inventory Count for the Site/Item combination.
 * @subpackage Structs
 */
class Counting_Attributes_DataType extends AbstractStructBase
{
    /**
     * The Inventory_ABC_Classification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Inventory ABC Classification for the Site and Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Inventory_ABC_ClassificationObjectType
     */
    public $Inventory_ABC_Classification_Reference;
    /**
     * The Include_in_Count
     * Meta information extracted from the WSDL
     * - documentation: The option of including Count
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_in_Count;
    /**
     * Constructor method for Counting_Attributes_DataType
     * @uses Counting_Attributes_DataType::setInventory_ABC_Classification_Reference()
     * @uses Counting_Attributes_DataType::setInclude_in_Count()
     * @param \StructType\Inventory_ABC_ClassificationObjectType $inventory_ABC_Classification_Reference
     * @param bool $include_in_Count
     */
    public function __construct(\StructType\Inventory_ABC_ClassificationObjectType $inventory_ABC_Classification_Reference = null, $include_in_Count = null)
    {
        $this
            ->setInventory_ABC_Classification_Reference($inventory_ABC_Classification_Reference)
            ->setInclude_in_Count($include_in_Count);
    }
    /**
     * Get Inventory_ABC_Classification_Reference value
     * @return \StructType\Inventory_ABC_ClassificationObjectType|null
     */
    public function getInventory_ABC_Classification_Reference()
    {
        return $this->Inventory_ABC_Classification_Reference;
    }
    /**
     * Set Inventory_ABC_Classification_Reference value
     * @param \StructType\Inventory_ABC_ClassificationObjectType $inventory_ABC_Classification_Reference
     * @return \StructType\Counting_Attributes_DataType
     */
    public function setInventory_ABC_Classification_Reference(\StructType\Inventory_ABC_ClassificationObjectType $inventory_ABC_Classification_Reference = null)
    {
        $this->Inventory_ABC_Classification_Reference = $inventory_ABC_Classification_Reference;
        return $this;
    }
    /**
     * Get Include_in_Count value
     * @return bool|null
     */
    public function getInclude_in_Count()
    {
        return $this->Include_in_Count;
    }
    /**
     * Set Include_in_Count value
     * @param bool $include_in_Count
     * @return \StructType\Counting_Attributes_DataType
     */
    public function setInclude_in_Count($include_in_Count = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_in_Count) && !is_bool($include_in_Count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_in_Count, true), gettype($include_in_Count)), __LINE__);
        }
        $this->Include_in_Count = $include_in_Count;
        return $this;
    }
}
